package ipipan.poliqarp.stat;

import java.util.HashMap;
import java.util.Map;

import ipipan.poliqarp.logic.Match;
import ipipan.poliqarp.logic.MatchList;

/**
 * Simple (not allowing multiple selectors) match counter.  Segregates
 * incoming matches into kinds (according to values returned by
 * constructed selector) and counts the number of occurences for each
 * kind (selector value).
 */
public class SimpleMatchCounter {
   Selector selector;
   Map<String, MatchCount> count = new HashMap<String, MatchCount>();
   int counted = 0;

   /**
    * Fake (empty) constructor, do not use.
    */
   public SimpleMatchCounter() {
      selector = null;
   }

   public SimpleMatchCounter(String groupby, Tagset tagset)
   throws StatQueryException {
      selector = new Selector(groupby, tagset);
   }

   public MatchCount count(Match match, int matchRef) {
      String val = selector.value(match);
      MatchCount c = count.get(val);
      if (c == null) {
         c = new MatchCount(val, matchRef);
         count.put(val, c);
      } else
         c.inc();

      counted ++;
      return c;
   }

   public int getCount(String val) {
      return count.get(val).getCount();
   }
}
