/*
 * This file is part of the Poliqarp suite.
 * 
 * Copyright (C) 2004-2009 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 * 
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file gpl.txt included in the packaging
 * of this file.  (See http://www.gnu.org/licenses/translations.html for
 * unofficial translations.)
 * 
 * A commercial license is available from IPI PAN (contact
 * Michal.Ciesiolka@ipipan.waw.pl or ipi@ipipan.waw.pl for more
 * information).  Licensees holding a valid commercial license from IPI
 * PAN may use this file in accordance with that license.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */

package ipipan.poliqarp.stat;

import ipipan.poliqarp.logic.IConfiguration;
import ipipan.poliqarp.logic.results.ResultCell;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class StatCell extends ResultCell
{
   public static final int TEXT = 0;
   public static final int INTEGER = 1;
   public static final int FLOAT = 2;

   int val;
   String txt;
   float fval;
   int kind;

   private static final NumberFormat format = new DecimalFormat("0.000");

   public StatCell(String text) {
      val = 0;
      fval = 0.0f;
      txt = text;
      kind = TEXT;
   }

   public StatCell(int value) {
      val = value;
      fval = (float)value;
      txt = String.valueOf(value);
      kind = INTEGER;
   }

   public StatCell(float fvalue) {
      val = 0;
      fval = fvalue;
      txt = format.format(fvalue);
      kind = FLOAT;
   }

   public String toString(IConfiguration cfg) {
      return txt;
   }
}
