/*
 * This file is part of the Poliqarp suite.
 * 
 * Copyright (C) 2004-2009 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 * 
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file gpl.txt included in the packaging
 * of this file.  (See http://www.gnu.org/licenses/translations.html for
 * unofficial translations.)
 * 
 * A commercial license is available from IPI PAN (contact
 * Michal.Ciesiolka@ipipan.waw.pl or ipi@ipipan.waw.pl for more
 * information).  Licensees holding a valid commercial license from IPI
 * PAN may use this file in accordance with that license.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */

package ipipan.poliqarp.util;

/**
 * A collection of various useful routines.
 */
public final class PoliqarpUtilities
{
   /** 
    * Looks up the hot key in a string (typically a label). The hot key is
    * prefixed by a '&amp;' (ampersand) character, which this method removes
    * and returns an object that remembers the hot key.
    */
   public static HotString getHotKey(String text)
   {
      boolean haveHotKey = false;
      char hotKey = ' ';
      int ampersandPos = text.indexOf("&");
      if (ampersandPos != -1) {
         hotKey = text.charAt(ampersandPos + 1);
         text = text.substring(0, ampersandPos) + 
            text.substring(ampersandPos + 1);
         haveHotKey = true;
      }
      return new HotString(text, hotKey, haveHotKey);
   }

   /**
    * Converts a text to a form that, when rendered by a HTML browser, will
    * produce the output identical to the original.
    *
    * @note This function is named after its PHP counterpart.
    */
   public static String htmlSpecialChars(String s)
   {
      return s.replaceAll("&", "&amp;").replaceAll("<", "&lt;")
         .replaceAll(">", "&gt;").replaceAll("\"", "&quot;");
   }
}
