package pl.waw.ipipan.corpcor.client;

import pl.waw.ipipan.corpcor.client.view.BrowseTextView;
import pl.waw.ipipan.corpcor.client.view.BrowseTextViewImpl;
import pl.waw.ipipan.corpcor.client.view.ChangesView;
import pl.waw.ipipan.corpcor.client.view.ChangesViewImpl;
import pl.waw.ipipan.corpcor.client.view.EditSegmentMorphoView;
import pl.waw.ipipan.corpcor.client.view.EditSegmentMorphoViewImpl;
import pl.waw.ipipan.corpcor.client.view.SearchView;
import pl.waw.ipipan.corpcor.client.view.SearchViewImpl;
import pl.waw.ipipan.corpcor.client.view.SearchDetailsView;
import pl.waw.ipipan.corpcor.client.view.SearchDetailsViewImpl;
import pl.waw.ipipan.corpcor.client.view.BrowseView;
import pl.waw.ipipan.corpcor.client.view.BrowseViewImpl;
import pl.waw.ipipan.corpcor.client.view.MenuView;
import pl.waw.ipipan.corpcor.client.view.MenuViewImpl;
import pl.waw.ipipan.corpcor.client.view.TextBlockView;
import pl.waw.ipipan.corpcor.client.view.TextBlockViewImpl;
import pl.waw.ipipan.corpcor.shared.CorpCorRequestFactory;

import com.google.gwt.core.client.GWT;
import com.google.gwt.place.shared.PlaceController;
import com.google.web.bindery.event.shared.EventBus;
import com.google.web.bindery.event.shared.SimpleEventBus;

public class ClientFactoryImpl implements ClientFactory {
	private final EventBus eventBus = new SimpleEventBus();
	private final PlaceController placeController = new PlaceController(eventBus);
	private final BrowseView loginView = new BrowseViewImpl();
	private final SearchView commentsView = new SearchViewImpl();
	private final SearchDetailsView editCommentView = new SearchDetailsViewImpl();
	private final MenuView menuView = new MenuViewImpl();
	private final CorpCorServiceAsync rpcService = GWT.create(CorpCorService.class);
	private final CorpCorRequestFactory requestFactory = GWT.create(CorpCorRequestFactory.class);
	private final BrowseTextView browseTextView = new BrowseTextViewImpl();
	private final TextBlockView textBlockView = new TextBlockViewImpl();
	private final EditSegmentMorphoView editSegmentMorphoView = new EditSegmentMorphoViewImpl();
	private final ChangesView changesView = new ChangesViewImpl();
	
	public ClientFactoryImpl() {
		requestFactory.initialize(eventBus);
	}
	
	@Override
	public EventBus getEventBus() {
		return eventBus;
	}

	@Override
	public PlaceController getPlaceController() {
		return placeController;
	}

	@Override
	public BrowseView getBrowseView() {
		return loginView;
	}

	@Override
	public SearchView getSearchView() {
		return commentsView;
	}

	@Override
	public SearchDetailsView getSearchDetailsView() {
		return editCommentView;
	}

	@Override
	public CorpCorServiceAsync getRpcService() {
		return rpcService;
	}
	
	@Override
	public CorpCorRequestFactory getRequestFactory() {
		return requestFactory;
	}

	@Override
	public MenuView getMenuView() {
		return menuView;
	}

	@Override
	public BrowseTextView getBrowseTextView() {
		return browseTextView;
	}

	@Override
	public TextBlockView getTextBlockView() {
		return textBlockView;
	}

	@Override
	public EditSegmentMorphoView getEditSegmentMorphoView() {
		return editSegmentMorphoView;
	}

	@Override
	public ChangesView getChangesView() {
		return changesView ;
	}

}
