package pl.waw.ipipan.corpcor.client;

import pl.waw.ipipan.corpcor.shared.SessionExpiredException;
import pl.waw.ipipan.corpcor.shared.pq.PoliqarpException;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.InvocationException;

public abstract class CorpCorAsyncCallback<T> implements AsyncCallback<T> {

	@Override
	public void onFailure(Throwable caught) {
		try {
			throw caught;
		} catch (SessionExpiredException e) {
			Window.alert("Bieżąca sesja została zakończona. Zaloguj się ponownie.");
			Window.Location.reload();
		} catch (InvocationException e) {
			Window.alert("Wystąpił błąd w komunikacji z serwerem (być może sesja została zakończona). Okno zostanie przeładowane.");
			e.printStackTrace();
			Window.Location.reload();
		} catch (PoliqarpException e) {
            Window.alert(e.getLocalizedMessage());
            e.printStackTrace();
		} catch (Throwable e) {
			Window.alert("Wystąpił nieoczekiwany błąd.");
			e.printStackTrace();
		}
		
	}
}
