package pl.waw.ipipan.corpcor.client;

import pl.waw.ipipan.corpcor.client.activity.BrowseTextActivity;
import pl.waw.ipipan.corpcor.client.activity.EditSegmentMorphoActivity;
import pl.waw.ipipan.corpcor.client.activity.SearchDetailsActivity;
import pl.waw.ipipan.corpcor.client.place.BrowseTextPlace;
import pl.waw.ipipan.corpcor.client.place.EditSegmentMorphoPlace;
import pl.waw.ipipan.corpcor.client.place.SearchDetailsPlace;

import com.google.gwt.activity.shared.Activity;
import com.google.gwt.activity.shared.ActivityMapper;
import com.google.gwt.place.shared.Place;

public class DetailActivityMapper implements ActivityMapper {

	private ClientFactory clientFactory;

	public DetailActivityMapper(ClientFactory clientFactory) {
		this.clientFactory = clientFactory;
	}

	@Override
	public Activity getActivity(Place place) {
		if (place instanceof SearchDetailsPlace) {
			return new SearchDetailsActivity((SearchDetailsPlace)place, clientFactory);
		} else if (place instanceof BrowseTextPlace) {
			return new BrowseTextActivity((BrowseTextPlace)place, clientFactory);
		} else if (place instanceof EditSegmentMorphoPlace) {
			return new EditSegmentMorphoActivity((EditSegmentMorphoPlace)place, clientFactory);
		}
		
		return null;
	}

}
