package pl.waw.ipipan.corpcor.client.activity;

import java.util.List;

import pl.waw.ipipan.corpcor.client.ClientFactory;
import pl.waw.ipipan.corpcor.client.place.ChangesPlace;
import pl.waw.ipipan.corpcor.client.view.ChangesView;
import pl.waw.ipipan.corpcor.shared.AnnotationProxy;
import pl.waw.ipipan.corpcor.shared.AnnotationRequest;

import com.google.gwt.activity.shared.AbstractActivity;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.AcceptsOneWidget;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.Range;
import com.google.web.bindery.requestfactory.shared.Receiver;

public class ChangesActivity extends AbstractActivity implements ChangesView.Presenter {

	private ClientFactory clientFactory;
	private ChangesPlace place;
	private ChangesAsyncDataProvider dataProvider = new ChangesAsyncDataProvider();

	public ChangesActivity(ChangesPlace place, ClientFactory clientFactory) {
		this.clientFactory = clientFactory;
		this.place = place;
	}

	private class ChangesAsyncDataProvider extends AsyncDataProvider<AnnotationProxy> {

		@Override
		protected void onRangeChanged(final HasData<AnnotationProxy> display) {
		    final Range range = display.getVisibleRange();
		    final int start = range.getStart();
	        final int length = range.getLength();
	        
	        String sort = clientFactory.getChangesView().getColumnSort();
	        
	        AnnotationRequest request = clientFactory.getRequestFactory().annotationRequest();
	        request.findAllByUser(null, start, length, sort).fire(new Receiver<List<AnnotationProxy>>() {

				@Override
				public void onSuccess(List<AnnotationProxy> result) {
					updateRowData(start, result);
				}
			});
		}
	}
	
	@Override
	public void start(final AcceptsOneWidget panel, EventBus eventBus) {
		ChangesView view = clientFactory.getChangesView();
		view.setPresenter(this);
		
		dataProvider.addDataDisplay(view.getTable());
		
		panel.setWidget(view.asWidget());
		
		// TODO
		//view.getQuery().setText(place.getQuery());
	}
	
	@Override
	public void onStop() {
		for (HasData<AnnotationProxy> display : dataProvider.getDataDisplays()) {
			dataProvider.removeDataDisplay(display);
		}
	}

}
