package pl.waw.ipipan.corpcor.client.activity;

import java.util.List;
import java.util.Set;

import javax.validation.ConstraintViolation;

import pl.waw.ipipan.corpcor.client.ClientFactory;
import pl.waw.ipipan.corpcor.client.CorpCorAsyncCallback;
import pl.waw.ipipan.corpcor.client.place.EditSegmentMorphoPlace;
import pl.waw.ipipan.corpcor.client.place.TextBlockPlace;
import pl.waw.ipipan.corpcor.client.view.EditSegmentMorphoView;
import pl.waw.ipipan.corpcor.shared.AnnotationProxy;
import pl.waw.ipipan.corpcor.shared.AnnotationProxyUtils;
import pl.waw.ipipan.corpcor.shared.AnnotationRequest;
import pl.waw.ipipan.corpcor.shared.corpusapi.CorpusSegment;

import com.google.gwt.activity.shared.AbstractActivity;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.AcceptsOneWidget;
import com.google.web.bindery.requestfactory.gwt.client.RequestFactoryEditorDriver;
import com.google.web.bindery.requestfactory.shared.Receiver;
import com.google.web.bindery.requestfactory.shared.RequestContext;

public class EditSegmentMorphoActivity extends AbstractActivity implements EditSegmentMorphoView.Presenter {

	private EditSegmentMorphoPlace place;
	private ClientFactory clientFactory;

	public EditSegmentMorphoActivity(EditSegmentMorphoPlace place,
			ClientFactory clientFactory) {
		this.place = place;
		this.clientFactory = clientFactory;
	}

	@Override
	public void start(AcceptsOneWidget panel, EventBus eventBus) {
		EditSegmentMorphoView view = clientFactory.getEditSegmentMorphoView();
		view.setPresenter(this);
		
		retrieveData();
		
		panel.setWidget(view.asWidget());
	}

	private void retrieveData() {
		final EditSegmentMorphoView view = clientFactory.getEditSegmentMorphoView();
		final RequestFactoryEditorDriver<AnnotationProxy, ?> driver = view.getEditorDriver();
		
		clientFactory.getRpcService().getCorpusSegment(place.getTextId(), 
				place.getId(), place.getSegmentId(), true, new CorpCorAsyncCallback<CorpusSegment>() {

			@Override
			public void onSuccess(final CorpusSegment result) {
				if (result != null) {
					AnnotationRequest editRequest = clientFactory.getRequestFactory().annotationRequest();
					AnnotationProxy editProxy = editRequest.create(AnnotationProxy.class);

					AnnotationProxyUtils.populateFromCorpusSegment(result, editProxy);

					editRequest.persist(editProxy);
					driver.edit(editProxy, editRequest);
				}
			}
		});
	}

	@Override
	public void onCancelButtonClicked(ClickEvent e) {
		clientFactory.getPlaceController().goTo(new TextBlockPlace(place.getId(), place.getTextId()));
	}

	@Override
	public void onSaveButtonClicked(ClickEvent e) {
		final RequestFactoryEditorDriver<AnnotationProxy, ?> driver = clientFactory.getEditSegmentMorphoView().getEditorDriver();
		RequestContext rc = driver.flush();
		
		if (driver.hasErrors()) {
			Window.alert("Formularz zawiera błędy.");
			return;
		}
		
		rc.fire(new Receiver<Void>() {

			@Override
			public void onSuccess(Void arg0) {
				clientFactory.getPlaceController().goTo(new TextBlockPlace(place.getId(), place.getTextId()));
			}

			@Override
			public void onConstraintViolation(
					Set<ConstraintViolation<?>> violations) {
				for (ConstraintViolation cv : violations) {
					Window.alert(cv.getMessage() + " (" + cv.getInvalidValue() + "): " + cv.getPropertyPath());
				}
			}
		});
	}

	@Override
	public void onHistoryButtonClicked(ClickEvent e) {
		clientFactory.getRpcService().getCorpusSegment(place.getTextId(), 
				place.getId(), place.getSegmentId(), false, new CorpCorAsyncCallback<CorpusSegment>() {

					@Override
					public void onSuccess(CorpusSegment result) {
						AnnotationRequest request = clientFactory.getRequestFactory().annotationRequest();
						final AnnotationProxy originalProxy = request.create(AnnotationProxy.class);
						AnnotationProxyUtils.populateFromCorpusSegment(result, originalProxy);
						originalProxy.setUserName("XML");						
						
						request = clientFactory.getRequestFactory().annotationRequest();
						request.findAllByPath(place.getSegmentId(), place.getId(), place.getTextId(), 0, -1, false)
						.fire(new Receiver<List<AnnotationProxy>>() {

							@Override
							public void onSuccess(List<AnnotationProxy> response) {
								if (originalProxy != null) {
									response.add(originalProxy);
								}
								clientFactory.getEditSegmentMorphoView().showEditHistory(response);
							}
						});
					}
		});
	}

}
