package pl.waw.ipipan.corpcor.client.activity;

import pl.waw.ipipan.corpcor.client.ClientFactory;
import pl.waw.ipipan.corpcor.client.place.ChangesPlace;
import pl.waw.ipipan.corpcor.client.place.SearchPlace;
import pl.waw.ipipan.corpcor.client.place.BrowsePlace;
import pl.waw.ipipan.corpcor.client.view.MenuView;

import com.google.gwt.activity.shared.AbstractActivity;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.ui.AcceptsOneWidget;

public class MenuActivity extends AbstractActivity implements MenuView.Presenter {
	
	private ClientFactory clientFactory;

	public MenuActivity(ClientFactory clientFactory) {
		this.clientFactory = clientFactory;
	}

	@Override
	public void start(AcceptsOneWidget panel, EventBus eventBus) {
			MenuView menuView = clientFactory.getMenuView();
			menuView.setPresenter(this);
					
			panel.setWidget(menuView.asWidget());
	}

	@Override
	public void onSearchButtonClicked() {
		clientFactory.getPlaceController().goTo(new SearchPlace(null));
	}

	@Override
	public void onBrowseButtonClicked() {
		clientFactory.getPlaceController().goTo(new BrowsePlace(null));
	}

	@Override
	public void onChangesButtonClicked() {
		clientFactory.getPlaceController().goTo(new ChangesPlace(null));
	}

}
