package pl.waw.ipipan.corpcor.client.activity;

import java.util.ArrayList;
import java.util.Set;

import pl.waw.ipipan.corpcor.client.ClientFactory;
import pl.waw.ipipan.corpcor.client.CorpCorAsyncCallback;
import pl.waw.ipipan.corpcor.client.CorpCorServiceAsync;
import pl.waw.ipipan.corpcor.client.place.SearchDetailsPlace;
import pl.waw.ipipan.corpcor.client.place.SearchPlace;
import pl.waw.ipipan.corpcor.client.view.SearchView;
import pl.waw.ipipan.corpcor.shared.ResultsPage;
import pl.waw.ipipan.corpcor.shared.pq.PoliqarpResult;

import com.google.gwt.activity.shared.AbstractActivity;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.AcceptsOneWidget;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.MultiSelectionModel;
import com.google.gwt.view.client.Range;

public class SearchActivity extends AbstractActivity implements
		SearchView.Presenter {

	private ClientFactory clientFactory;
	private SearchPlace place;
	private SearchResultsAsyncDataProvider dataProvider = new SearchResultsAsyncDataProvider();

	public SearchActivity(SearchPlace place, ClientFactory clientFactory) {
		this.clientFactory = clientFactory;
		this.place = place;
	}

	private class SearchResultsAsyncDataProvider extends AsyncDataProvider<PoliqarpResult> {

		@Override
		protected void onRangeChanged(final HasData<PoliqarpResult> display) {
			if ((place.getQuery() == null) || (place.getQuery().length() == 0)) {
				updateRowCount(0, true);
				return;
			}
			
			clientFactory.getSearchView().setLoadingIndicator(true);
			
		    final Range range = display.getVisibleRange();
		    final int start = range.getStart();
	        final int length = range.getLength();
	        
	        // TODO: Ignored for now
	        // final ColumnSortList sortList = clientFactory.getSearchView().getColumnSortList();
	        CorpCorServiceAsync rpcService = clientFactory.getRpcService();
	        
	        boolean showModified = clientFactory.getSearchView().isShowModified();
	        rpcService.getQueryResults(place.getQuery(), new PoliqarpResult.PQViewItemId(start), length, true, showModified, 
	                new CorpCorAsyncCallback<ResultsPage<PoliqarpResult>>() {
				@Override
				public void onSuccess(ResultsPage<PoliqarpResult> result) {
					updateRowData(start, result.getEntries());
					updateRowCount(result.getGlobalSize(), true);
					checkPageSelected();
					clientFactory.getSearchView().setLoadingIndicator(false);
				}
			});
	        
		}
	}

	@Override
	public void onStop() {
		for (HasData<PoliqarpResult> display : dataProvider.getDataDisplays()) {
			dataProvider.removeDataDisplay(display);
		}
	}
	
	@Override
	public void start(final AcceptsOneWidget panel, EventBus eventBus) {
		SearchView commentsView = clientFactory.getSearchView();
		commentsView.setPresenter(this);
		
		HasData<PoliqarpResult> table = clientFactory.getSearchView().getTable();
        dataProvider.addDataDisplay(table);
		
		panel.setWidget(commentsView.asWidget());
		commentsView.getQuery().setText(place.getQuery());
	}

	protected void checkPageSelected() {
		HasData<PoliqarpResult> table = clientFactory.getSearchView().getTable();
		boolean allSelected = true;
		for (PoliqarpResult pr : table.getVisibleItems()) {
			if (!table.getSelectionModel().isSelected(pr)) {
				allSelected = false;
			}
		}
		
		clientFactory.getSearchView().setPageSelector(allSelected);
	}

	@Override
	public void onResultClicked(PoliqarpResult pr) {
		clientFactory.getPlaceController().goTo(new SearchDetailsPlace(place.getQuery(), pr.getEntryId()));
	}

	@Override
	public void onSendQueryButtonClicked() {
		SearchView searchView = clientFactory.getSearchView();
		
		String query = searchView.getQuery().getText();
		if ((query != null) && (query.equals(place.getQuery()))) {
			searchView.getTable().setVisibleRangeAndClearData(searchView.getTable().getVisibleRange(), true);
		}
		
		onDeselectAllButtonClicked();
		clientFactory.getPlaceController().goTo(new SearchPlace(query));
	}

	@Override
	public void onEditSelectedButtonClicked() {
	    MultiSelectionModel<? super PoliqarpResult> selectionModel = (MultiSelectionModel<? super PoliqarpResult>) clientFactory.getSearchView().getTable().getSelectionModel();
        Set<? super PoliqarpResult> selectedSet = selectionModel.getSelectedSet();
        if (selectedSet.size() < 1)
            return;
        PoliqarpResult item = (PoliqarpResult) selectedSet.iterator().next();
	    onResultClicked(item);
	    clientFactory.getSearchDetailsView().getTabLayout().selectTab(2);
	}

	@Override
	public void onSelectAllButtonClicked() {
		final HasData<PoliqarpResult> table = clientFactory.getSearchView().getTable();
        if (!Window.confirm("Operacja spowoduje pobranie " + table.getRowCount() 
        		+ " wyników. Czy kontynuować?")) {
        	return;
        }
        boolean showModified = clientFactory.getSearchView().isShowModified();
		clientFactory.getRpcService().getQueryResults(place.getQuery(), null, -1, false, showModified, new CorpCorAsyncCallback<ResultsPage<PoliqarpResult>>() {
			@Override
			public void onSuccess(ResultsPage<PoliqarpResult> result) {
				table.setRowData(0, result.getEntries());
				table.setRowCount(result.getGlobalSize(), true);
				for (PoliqarpResult pr : result.getEntries()) {
					table.getSelectionModel().setSelected(pr, true);
				}
				clientFactory.getSearchView().setPageSelector(true);
			}
		});
	}

    @Override
    public void onDeselectAllButtonClicked() {
        ((MultiSelectionModel) clientFactory.getSearchView().getTable().getSelectionModel()).clear();
        clientFactory.getSearchView().setPageSelector(false);
    }

	@Override
	public void onDeselectPageButtonClicked() {
		HasData<PoliqarpResult> table = clientFactory.getSearchView().getTable();
		for (PoliqarpResult pr : table.getVisibleItems()) {
			table.getSelectionModel().setSelected(pr, false);
		}
	}

	@Override
	public void onSelectPageButtonClicked() {
		HasData<PoliqarpResult> table = clientFactory.getSearchView().getTable();
		for (PoliqarpResult pr : table.getVisibleItems()) {
			table.getSelectionModel().setSelected(pr, true);
		}
	}
	
	@Override
	public void reload() {
	    onSendQueryButtonClicked();
	}
}
