package pl.waw.ipipan.corpcor.client.place;

import java.util.HashMap;
import java.util.Map;

import com.google.gwt.place.shared.PlaceTokenizer;
import com.google.gwt.place.shared.Prefix;

public class BrowseTextPlace extends BrowsePlace {
	protected String id;
	
	@Prefix("browseText")
	public static class Tokenizer implements PlaceTokenizer<BrowseTextPlace> {

		@Override
		public BrowseTextPlace getPlace(String token) {
			Map<String, String> paramMap = TokenizerUtils.asMap(token);
			return new BrowseTextPlace(paramMap.get("query"), paramMap.get("id"));
		}

		@Override
		public String getToken(BrowseTextPlace place) {
			Map<Object, Object> map = new HashMap<Object, Object>();
			map.put("query", place.getQuery());
			map.put("id", place.getId());
			return TokenizerUtils.asString(map);
		}

	}
	
	public BrowseTextPlace(String query, String id) {
		super(query);
		this.id = id;
	}

	public String getId() {
		return id;
	}

}
