package pl.waw.ipipan.corpcor.client.place;

import java.util.HashMap;
import java.util.Map;

import com.google.gwt.place.shared.Place;
import com.google.gwt.place.shared.PlaceTokenizer;
import com.google.gwt.place.shared.Prefix;

public class ChangesPlace extends Place {
	private String query;
	
	@Prefix("changes")
	public static class Tokenizer implements PlaceTokenizer<ChangesPlace> {

		@Override
		public ChangesPlace getPlace(String token) {
			Map<String, String> paramMap = TokenizerUtils.asMap(token);
			return new ChangesPlace(paramMap.get("query"));
		}

		@Override
		public String getToken(ChangesPlace place) {
			Map<Object, Object> map = new HashMap<Object, Object>();
			map.put("query", place.getQuery());
			return TokenizerUtils.asString(map);
		}

	}

	public ChangesPlace(String query) {
		this.query = query;
	}

	public String getQuery() {
		return query;
	}

	public boolean equalFields(ChangesPlace obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		
		if (query == null) {
			if (obj.query != null)
				return false;
		} else if (!query.equals(obj.query))
			return false;
		
		return true;
	}

}
