package pl.waw.ipipan.corpcor.client.place;

import java.util.HashMap;
import java.util.Map;

import pl.waw.ipipan.corpcor.shared.pq.PoliqarpResult;

import com.google.gwt.place.shared.PlaceTokenizer;
import com.google.gwt.place.shared.Prefix;

public class SearchDetailsPlace extends SearchPlace {
	protected PoliqarpResult.PQEntryId id;
	
	@Prefix("details")
	public static class Tokenizer implements PlaceTokenizer<SearchDetailsPlace> {

		@Override
		public SearchDetailsPlace getPlace(String token) {
			Map<String, String> paramMap = TokenizerUtils.asMap(token);
			String string = paramMap.get("query");
            Integer rid = new Integer(paramMap.get("rid"));
            Integer vid = new Integer(paramMap.get("vid"));
            PoliqarpResult.PQEntryId id2 = new PoliqarpResult.PQEntryId(rid != null ? rid.intValue() : 0);
            id2.viewId.id = vid != null ? vid.intValue() : 0;
            return new SearchDetailsPlace(string, id2);
		}

		@Override
		public String getToken(SearchDetailsPlace place) {
			Map<Object, Object> map = new HashMap<Object, Object>();
			map.put("query", place.getQuery());
			map.put("rid", place.getEntryId().resultId.id);
            map.put("vid", place.getEntryId().viewId.id);
			return TokenizerUtils.asString(map);
		}

	}

	public SearchDetailsPlace(String query, PoliqarpResult.PQEntryId id) {
		super(query);
        this.id = id;
	}

	public PoliqarpResult.PQEntryId getEntryId() {
		return id;
	}
}
