package pl.waw.ipipan.corpcor.client.place;

import java.util.HashMap;
import java.util.Map;

import com.google.gwt.place.shared.Place;
import com.google.gwt.place.shared.PlaceTokenizer;
import com.google.gwt.place.shared.Prefix;

public class TextBlockPlace extends Place {
	protected String id;
	protected String textId;
	
	@Prefix("textBlock")
	public static class Tokenizer implements PlaceTokenizer<TextBlockPlace> {

		@Override
		public TextBlockPlace getPlace(String token) {
			Map<String, String> paramMap = TokenizerUtils.asMap(token);
			return new TextBlockPlace(paramMap.get("id"), paramMap.get("textId"));
		}

		@Override
		public String getToken(TextBlockPlace place) {
			Map<Object, Object> map = new HashMap<Object, Object>();
			map.put("id", place.getId());
			map.put("textId", place.getTextId());
			return TokenizerUtils.asString(map);
		}

	}
	public TextBlockPlace(String id, String textId) {
		this.id = id;
		this.textId = textId;
	}
	
	public String getId() {
		return id;
	}
	
	public String getTextId() {
		return textId;
	}

	public boolean equalFields(TextBlockPlace obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		
		if (id == null) {
			if (obj.id != null)
				return false;
		} else if (!id.equals(obj.id))
			return false;
		
		if (textId == null) {
			if (obj.textId != null)
				return false;
		} else if (!textId.equals(obj.textId))
			return false;
		
		return true;
	}

}
