package pl.waw.ipipan.corpcor.client.view;

import java.util.Date;
import java.util.List;

import pl.waw.ipipan.corpcor.shared.AnnotationProxy;

import com.google.gwt.cell.client.DateCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.client.DateTimeFormat.PredefinedFormat;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;

public class AnnotationHistoryDialog extends DialogBox {
	public interface EditedHandler {
		void onEdited(String text);
	}

	private static AnnotationHistoryDialogUiBinder uiBinder = GWT
			.create(AnnotationHistoryDialogUiBinder.class);

	interface AnnotationHistoryDialogUiBinder extends UiBinder<Widget, AnnotationHistoryDialog> {
	}

	@UiField(provided=true)
	CellTable<AnnotationProxy> cellTable;

	public AnnotationHistoryDialog() {
		// Set the dialog box's caption.
		setText("Historia anotacji");

		// Enable glass background.
		setGlassEnabled(true);
		
		initCellTable();

		setWidget(uiBinder.createAndBindUi(this));
	}

	private void initCellTable() {
		cellTable = new CellTable<AnnotationProxy>();
		
		TextColumn<AnnotationProxy> userColumn = new TextColumn<AnnotationProxy>() {

			@Override
			public String getValue(AnnotationProxy object) {
				return object.getUserName();
			}
			
		};
		Column<AnnotationProxy, Date> dateColumn = new Column<AnnotationProxy, Date>(
				new DateCell(DateTimeFormat.getFormat(PredefinedFormat.DATE_TIME_MEDIUM))) {

			@Override
			public Date getValue(AnnotationProxy object) {
				return object.getAdded();
			}
			
		};
		TextColumn<AnnotationProxy> orthColumn = new TextColumn<AnnotationProxy>() {

			@Override
			public String getValue(AnnotationProxy object) {
				return object.getOrth();
			}
			
		};
		TextColumn<AnnotationProxy> baseColumn = new TextColumn<AnnotationProxy>() {

			@Override
			public String getValue(AnnotationProxy object) {
				return object.getBase();
			}
			
		};
		TextColumn<AnnotationProxy> msdColumn = new TextColumn<AnnotationProxy>() {

			@Override
			public String getValue(AnnotationProxy object) {
				return object.getMsd();
			}
			
		};
		TextColumn<AnnotationProxy> ctagColumn = new TextColumn<AnnotationProxy>() {

			@Override
			public String getValue(AnnotationProxy object) {
				return object.getCtag();
			}
			
		};
		TextColumn<AnnotationProxy> commentColumn = new TextColumn<AnnotationProxy>() {

			@Override
			public String getValue(AnnotationProxy object) {
				return object.getComment();
			}
			
		};
		TextColumn<AnnotationProxy> queryColumn = new TextColumn<AnnotationProxy>() {

			@Override
			public String getValue(AnnotationProxy object) {
				return object.getQuery();
			}
			
		};
		
		cellTable.addColumn(userColumn, "Użytkownik");
		cellTable.addColumn(dateColumn, "Data");
		cellTable.addColumn(orthColumn, "Forma ortograficzna");
		cellTable.addColumn(baseColumn, "Forma bazowa");
		cellTable.addColumn(msdColumn, "MSD");
		cellTable.addColumn(ctagColumn, "CTAG");
		cellTable.addColumn(commentColumn, "Komentarz");
		cellTable.addColumn(queryColumn, "Zapytanie");
		
		Label label = new Label("Anotacja nie została zmodyfikowana względem wersji źródłowej.");
		cellTable.setEmptyTableWidget(label);
	}

	@UiHandler("closeButton")
	void onCloseButtonClicked(ClickEvent e) {
		this.hide();
	}

	public void setHistoryItems(List<AnnotationProxy> response) {
		cellTable.setRowData(0, response);
		cellTable.setRowCount(response.size());
	}
}
