package pl.waw.ipipan.corpcor.client.view;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.cellview.client.DataGrid;
import com.google.gwt.user.cellview.client.SimplePager;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.TabLayoutPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionChangeEvent.Handler;
import com.google.gwt.view.client.SingleSelectionModel;

public class BrowseViewImpl extends Composite implements BrowseView {
	private static final int PAGE_SIZE = 5;

	private static LoginViewImplUiBinder uiBinder = GWT
			.create(LoginViewImplUiBinder.class);

	interface LoginViewImplUiBinder extends UiBinder<Widget, BrowseViewImpl> {
	}

	@UiField(provided=true) DataGrid<String> cellTable;
	@UiField SimplePager simplePager;
	
	@UiField TextBox queryBox;
	//@UiField TabLayoutPanel tabPanel;
	
	private Presenter presenter;
	//private BrowseViewBundle bundle = GWT.create(BrowseViewBundle.class);

	public BrowseViewImpl() {
		initCellTable();
		
		initWidget(uiBinder.createAndBindUi(this));
		
		simplePager.setDisplay(cellTable);
	    simplePager.setPageSize(PAGE_SIZE);
	}

	private void initCellTable() {
		cellTable = new DataGrid<String>();
		
		TextColumn<String> textColumn = new TextColumn<String>() {
			@Override
			public String getValue(String object) {
				return object;
			}
		};
		
		cellTable.addColumn(textColumn, "Tekst");
		/*
		Column<String, String> openColumn = new Column<String, String>(new ButtonCell()) {

			@Override
			public String getValue(String object) {
				return "Otwórz";
			}
			
		};
		
		cellTable.addColumn(openColumn, "Otwórz");
		
		openColumn.setFieldUpdater(new FieldUpdater<String, String>() {
			
			@Override
			public void update(int index, String object, String value) {
				if (presenter != null) {
					presenter.onOpenButtonClicked(object);
				}
			}
		});*/

		final SingleSelectionModel<String> selectionModel
			= new SingleSelectionModel<String>();
		selectionModel.addSelectionChangeHandler(new Handler() {
			
			@Override
			public void onSelectionChange(SelectionChangeEvent event) {
				if (presenter != null) {
					presenter.onTextClicked(selectionModel.getSelectedObject());
				}
			}
		});
		cellTable.setSelectionModel(selectionModel);
		
		//cellTable.addColumnSortHandler(new ColumnSortEvent.AsyncHandler(cellTable));
	}

	@Override
	public void setPresenter(Presenter presenter) {
		this.presenter = presenter;
	}

	@Override
	public Widget asWidget() {
		return this;
	}

	@Override
	public HasData<String> getTable() {
		return cellTable;
	}

	@Override
	public HasText getQuery() {
		return queryBox;
	}
	
	@UiHandler("sendQueryButton")
	void onSendQueryButtonClicked(ClickEvent e) {
		if (presenter != null) {
			presenter.onSendQueryButtonClicked();
		}
	}
	/*
	@Override
	public void showCorpusTextTab(String object,
			ResultsPage<CorpusTextBlock> result) {
		Widget corpusTextDisplay = createCorpusTextDisplay(result);
		tabPanel.add(corpusTextDisplay, createClosingTabHeader(object, corpusTextDisplay));
		tabPanel.selectTab(corpusTextDisplay);
	}

	private IsWidget createClosingTabHeader(String object, final Widget corpusTextDisplay) {
		final FlowPanel panel = new FlowPanel();
		Image image = new Image(bundle.closeIcon());
		image.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				tabPanel.remove(corpusTextDisplay);
			}
		});
		
		panel.add(new InlineLabel(object));
		panel.add(image);
		
		return panel;
	}

	private Widget createCorpusTextDisplay(ResultsPage<CorpusTextBlock> result) {
		ScrollPanel panel = new ScrollPanel();
		CellList<CorpusTextBlock> cellList = new CellList<CorpusTextBlock>(new TextBlockCell());
		final SingleSelectionModel<CorpusTextBlock> selectionModel
			= new SingleSelectionModel<CorpusTextBlock>();
		selectionModel.addSelectionChangeHandler(new Handler() {
		
			@Override
			public void onSelectionChange(SelectionChangeEvent event) {
				if (presenter != null) {
					presenter.onTextBlockClicked(selectionModel.getSelectedObject());
				}
			}
		});
		cellList.setSelectionModel(selectionModel);
		
		cellList.setRowData(result.getEntries());
		cellList.setRowCount(result.getEntries().size());
		
		panel.add(cellList);
		
		return panel;
	}
	*/
}
