package pl.waw.ipipan.corpcor.client.view;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import pl.waw.ipipan.corpcor.shared.AnnotationProxy;
import pl.waw.ipipan.corpcor.shared.AnnotationProxyUtils;

import com.google.gwt.cell.client.DateCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style.Unit;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.client.DateTimeFormat.PredefinedFormat;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.user.cellview.client.DataGrid;
import com.google.gwt.user.cellview.client.SimplePager;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.cellview.client.ColumnSortList.ColumnSortInfo;
import com.google.gwt.user.cellview.client.SimplePager.TextLocation;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;

public class ChangesViewImpl extends Composite implements ChangesView {
	private static final int PAGE_SIZE = 5;

	private static ChangesViewImplUiBinder uiBinder = GWT
			.create(ChangesViewImplUiBinder.class);

	interface ChangesViewImplUiBinder extends UiBinder<Widget, ChangesViewImpl> {
	}

	@UiField(provided=true) DataGrid<AnnotationProxy> cellTable;
	@UiField(provided=true) SimplePager simplePager;
	
//	@UiField TextBox queryBox;

	private Presenter presenter;
	private List<ColumnDef<AnnotationProxy>> columnOrder;
	
	public ChangesViewImpl() {
		initCellTable();
		
		SimplePager.Resources resources = GWT.create(SimplePager.Resources.class);
		simplePager = new SimplePager(TextLocation.CENTER, resources , false, 1000, true);
		
		initWidget(uiBinder.createAndBindUi(this));
		
		simplePager.setDisplay(cellTable);
	    simplePager.setPageSize(PAGE_SIZE);
	}

	private void initCellTable() {
		cellTable = new DataGrid<AnnotationProxy>();
		
		TextColumn<AnnotationProxy> userColumn = new TextColumn<AnnotationProxy>() {

			@Override
			public String getValue(AnnotationProxy object) {
				return object.getUserName();
			}
			
		};
		Column<AnnotationProxy, Date> dateColumn = new Column<AnnotationProxy, Date>(
				new DateCell(DateTimeFormat.getFormat(PredefinedFormat.DATE_TIME_MEDIUM))) {

			@Override
			public Date getValue(AnnotationProxy object) {
				return object.getAdded();
			}
			
		};
		TextColumn<AnnotationProxy> segmentIdColumn = new TextColumn<AnnotationProxy>() {

			@Override
			public String getValue(AnnotationProxy object) {
				return object.getSegmentId();
			}
			
		};
		/*TextColumn<AnnotationProxy> blockIdColumn = new TextColumn<AnnotationProxy>() {

			@Override
			public String getValue(AnnotationProxy object) {
				return object.getBlockId();
			}
			
		};*/
		TextColumn<AnnotationProxy> textIdColumn = new TextColumn<AnnotationProxy>() {

			@Override
			public String getValue(AnnotationProxy object) {
				return object.getTextId();
			}
			
		};
		TextColumn<AnnotationProxy> changeColumn = new TextColumn<AnnotationProxy>() {

			@Override
			public String getValue(AnnotationProxy object) {
				return AnnotationProxyUtils.changesAsString(object);
			}
			
		};
		TextColumn<AnnotationProxy> commentColumn = new TextColumn<AnnotationProxy>() {

			@Override
			public String getValue(AnnotationProxy object) {
				return object.getComment();
			}
			
		};
		/*TextColumn<AnnotationProxy> queryColumn = new TextColumn<AnnotationProxy>() {

			@Override
			public String getValue(AnnotationProxy object) {
				return object.getQuery();
			}
			
		};*/
		
		
		columnOrder = new ArrayList<ColumnDef<AnnotationProxy>>();
		columnOrder.add(new ColumnDef<AnnotationProxy>(userColumn, "Użytkownik", 
				AnnotationProxyUtils.getUserNameField()));
		columnOrder.add(new ColumnDef<AnnotationProxy>(dateColumn, "Data", 
				AnnotationProxyUtils.getAddedField()));
		columnOrder.add(new ColumnDef<AnnotationProxy>(segmentIdColumn, "ID", 
				AnnotationProxyUtils.getSegmentIdField()));
		columnOrder.add(new ColumnDef<AnnotationProxy>(textIdColumn, "Text ID", 
				AnnotationProxyUtils.getTextIdField()));
		columnOrder.add(new ColumnDef<AnnotationProxy>(changeColumn, "Zmiany", null));
		columnOrder.add(new ColumnDef<AnnotationProxy>(commentColumn, "Komentarz", null));
		
		cellTable.getColumnSortList().push(new ColumnSortInfo(dateColumn, false));
		
		for (ColumnDef<AnnotationProxy> cd : columnOrder) {
			cellTable.addColumn(cd.getColumn(), cd.getHeader());
		}
		
		cellTable.setColumnWidth(changeColumn,  40, Unit.PCT);
		
		userColumn.setSortable(true);
		dateColumn.setSortable(true);
		segmentIdColumn.setSortable(true);
		textIdColumn.setSortable(true);
		
		cellTable.addColumnSortHandler(new ColumnSortEvent.AsyncHandler(cellTable));
		
		Label label = new Label("Brak rezultatów.");
		cellTable.setEmptyTableWidget(label);
	}

	@Override
	public void setPresenter(Presenter presenter) {
		this.presenter = presenter;
	}

	@Override
	public HasData<AnnotationProxy> getTable() {
		return cellTable;
	}

	@Override
	public HasText getQuery() {
		//return queryBox;
		// TODO
		return null;
	}

	@Override
	public String getColumnSort() {
		ColumnSortList sortList = cellTable.getColumnSortList();
		StringBuilder sb = new StringBuilder();
		for (int i = 0; i < sortList.size(); i++) {
			if (i != 0) {
				sb.append(",");
			}
			
        	ColumnSortInfo csi = sortList.get(i);
        	sb.append(columnOrder.get(
    				cellTable.getColumnIndex((Column<AnnotationProxy, ?>) csi.getColumn())).getId());
        	if (csi.isAscending()) {
        		sb.append(":ASC");
        	} else {
        		sb.append(":DESC");
        	}
        }
		
		return sb.toString();
	}
}
