package pl.waw.ipipan.corpcor.client.view;

import java.util.List;

import pl.waw.ipipan.corpcor.shared.AnnotationProxy;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RootLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.web.bindery.requestfactory.gwt.client.RequestFactoryEditorDriver;

public class EditSegmentMorphoViewImpl extends Composite implements EditSegmentMorphoView {

	private static EditSegmentMorphoViewImplUiBinder uiBinder = GWT
			.create(EditSegmentMorphoViewImplUiBinder.class);

	interface EditSegmentMorphoViewImplUiBinder extends
			UiBinder<Widget, EditSegmentMorphoViewImpl> {
	}

	private Presenter presenter;
	
	private Driver editorDriver;
	
	interface Driver extends RequestFactoryEditorDriver<AnnotationProxy, SegmentEditor> {}
	
	@UiField SegmentEditor segmentEditor;
	
	private AnnotationHistoryDialog historyDialog;

	public EditSegmentMorphoViewImpl() {
		initWidget(uiBinder.createAndBindUi(this));
		editorDriver = GWT.create(Driver.class);
		editorDriver.initialize(segmentEditor);
	}

	@Override
	public void setPresenter(Presenter presenter) {
		this.presenter = presenter;
	}
	
	@UiHandler("cancelButton")
	void onCancelButtonClicked(ClickEvent e) {
		if (presenter != null) {
			presenter.onCancelButtonClicked(e);
		}
	}
	
	@UiHandler("saveButton")
	void onSaveButtonClicked(ClickEvent e) {
		if (presenter != null) {
			presenter.onSaveButtonClicked(e);
		}
	}
	
	@UiHandler("historyButton")
	void onHistoryButtonClicked(ClickEvent e) {
		if (presenter != null) {
			presenter.onHistoryButtonClicked(e);
		}
	}

	@Override
	public RequestFactoryEditorDriver<AnnotationProxy, ?> getEditorDriver() {
		return editorDriver;
	}

	@Override
	public void showEditHistory(List<AnnotationProxy> response) {
		if (historyDialog == null) {
			historyDialog = new AnnotationHistoryDialog();
		}
		
		historyDialog.setHistoryItems(response);
		historyDialog.setPopupPositionAndShow(new PopupPanel.PositionCallback() {
			
			@Override
			public void setPosition(int offsetWidth, int offsetHeight) {
				//FIXME: hardcoded sizes, but offsetWidth/Height are incorrect
				int left = (Window.getClientWidth() - 850) / 2;
	            int top = (Window.getClientHeight() - 500) / 3;
				historyDialog.setPopupPosition(left, top);
			}
		});
	}
}
