package pl.waw.ipipan.corpcor.client.view;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;

public class MenuViewImpl extends Composite implements MenuView {

	private static MenuViewImplUiBinder uiBinder = GWT
			.create(MenuViewImplUiBinder.class);

	interface MenuViewImplUiBinder extends UiBinder<Widget, MenuViewImpl> {
	}

	public MenuViewImpl() {
		initWidget(uiBinder.createAndBindUi(this));
	}
	
	private Presenter presenter;
	
	@UiHandler("searchButton")
	void onSearchButtonClicked(ClickEvent e) {
		if (presenter != null) {
			presenter.onSearchButtonClicked();
		}
	}
	
	@UiHandler("browseButton")
	void onBrowseButtonClicked(ClickEvent e) {
		if (presenter != null) {
			presenter.onBrowseButtonClicked();
		}
	}
	
	@UiHandler("changesButton")
	void onChangesButtonClicked(ClickEvent e) {
		if (presenter != null) {
			presenter.onChangesButtonClicked();
		}
	}

	@Override
	public void setPresenter(Presenter presenter) {
		this.presenter = presenter;
	}

}
