package pl.waw.ipipan.corpcor.client.view;

import pl.waw.ipipan.corpcor.client.view.res.CorpCorStyles;
import pl.waw.ipipan.corpcor.shared.ResultsPage;
import pl.waw.ipipan.corpcor.shared.corpusapi.CorpusSegment;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SingleSelectionModel;

public class TextBlockViewImpl extends Composite implements TextBlockView {

	private static TextBlockViewImplUiBinder uiBinder = GWT
			.create(TextBlockViewImplUiBinder.class);

	interface TextBlockViewImplUiBinder extends
			UiBinder<Widget, TextBlockViewImpl> {
	}

	private Presenter presenter;
	
	@UiField Panel contentPanel;
	@UiField(provided=true) CellTable<CorpusSegment> cellTable;
	@UiField CorpCorStyles styles;
	
	@UiField Button goLeftButton;
	@UiField Button goUpButton;
	@UiField Button goRightButton;

	public TextBlockViewImpl() {
		initCellTable();
		
		initWidget(uiBinder.createAndBindUi(this));
	}

	private void initCellTable() {
		cellTable = new CellTable<CorpusSegment>();
		
		TextColumn<CorpusSegment> idCol = new TextColumn<CorpusSegment>() {

			@Override
			public String getValue(CorpusSegment object) {
				return object.getSegmentId();
			}
			
		};
		TextColumn<CorpusSegment> orthCol = new TextColumn<CorpusSegment>() {

			@Override
			public String getValue(CorpusSegment object) {
				return object.getOrth();
			}
			
		};
		TextColumn<CorpusSegment> baseCol = new TextColumn<CorpusSegment>() {

			@Override
			public String getValue(CorpusSegment object) {
				return object.getBase();
			}
			
		};
		TextColumn<CorpusSegment> msdCol = new TextColumn<CorpusSegment>() {

			@Override
			public String getValue(CorpusSegment object) {
				return object.getMsd();
			}
			
		};
		TextColumn<CorpusSegment> ctagCol = new TextColumn<CorpusSegment>() {

			@Override
			public String getValue(CorpusSegment object) {
				return object.getCtag();
			}
			
		};
		
		cellTable.addColumn(idCol, "Id");
		cellTable.addColumn(orthCol, "Forma ortograficzna");
		cellTable.addColumn(baseCol, "Forma bazowa");
		cellTable.addColumn(msdCol, "MSD");
		cellTable.addColumn(ctagCol, "CTAG");
		
		final SingleSelectionModel<CorpusSegment> selModel = new SingleSelectionModel<CorpusSegment>();
		cellTable.setSelectionModel(selModel);
		selModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler() {
			
			@Override
			public void onSelectionChange(SelectionChangeEvent event) {
				if (presenter != null) {
					presenter.onSegmentClicked(selModel.getSelectedObject().getSegmentId());
				}
			}
		});
	}

	@Override
	public void setPresenter(Presenter presenter) {
		this.presenter = presenter;
	}

	@Override
	public void setData(ResultsPage<CorpusSegment> result) {
		contentPanel.clear();
		contentPanel.add(createSentenceView(result));
				
		cellTable.setPageSize(result.getEntries().size());
		cellTable.setRowData(0, result.getEntries());
		cellTable.setRowCount(result.getEntries().size(), true);
	}

	private Widget createSentenceView(ResultsPage<CorpusSegment> result) {
		FlowPanel panel = new FlowPanel();
		
		for (final CorpusSegment s : result.getEntries()) {
			final InlineLabel label = new InlineLabel(s.getOrth() + " ");
			label.setTitle(s.getBase() + ":" + s.getCtag() + ":" + s.getMsd());
			if (s.isDeleted()) {
				label.setStyleName(styles.segmentLabelDeleted());
			} else {
				label.setStyleName(styles.segmentLabel());
			}
			
			label.addMouseOverHandler(new MouseOverHandler() {
				
				@Override
				public void onMouseOver(MouseOverEvent event) {
					label.setStyleName(styles.segmentLabelSelected());
				}
			});
			label.addMouseOutHandler(new MouseOutHandler() {
				
				@Override
				public void onMouseOut(MouseOutEvent event) {
					if (s.isDeleted()) {
						label.setStyleName(styles.segmentLabelDeleted());
					} else {
						label.setStyleName(styles.segmentLabel());
					}
				}
			});
			
			label.addClickHandler(new ClickHandler() {
				
				@Override
				public void onClick(ClickEvent event) {
					if (presenter != null) {
						presenter.onSegmentClicked(s.getSegmentId());
					}
				}
			});
			panel.add(label);
		}
		
		return panel;
	}
	
	@UiHandler("goLeftButton")
	void onGoLeftButtonClicked(ClickEvent e) {
		if (presenter != null) {
			presenter.onGoLeftButtonClicked();
		}
	}
	
	@UiHandler("goUpButton")
	void onGoUpButtonClicked(ClickEvent e) {
		if (presenter != null) {
			presenter.onGoUpButtonClicked();
		}
	}
	
	@UiHandler("goRightButton")
	void onGoRightButtonClicked(ClickEvent e) {
		if (presenter != null) {
			presenter.onGoRightButtonClicked();
		}
	}

	@Override
	public void setPrevButtonEnabled(boolean b) {
		goLeftButton.setEnabled(b);
	}

	@Override
	public void setNextButtonEnabled(boolean b) {
		goRightButton.setEnabled(b);
	}
}
