package pl.waw.ipipan.corpcor.server;

import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import pl.waw.ipipan.corpcor.server.dao.AnnotationDao;
import pl.waw.ipipan.corpcor.server.model.Annotation;
import pl.waw.ipipan.corpcor.server.model.User;
 
@Component
public class AnnotationService {
	@Autowired
	private AnnotationDao annotationDao;

	@Transactional(propagation = Propagation.REQUIRED, rollbackFor=Exception.class)
	public void persist(Annotation c) {
		c.setAdded(new Date());
		User u = (User) SecurityContextHolder.getContext().getAuthentication().getPrincipal();
		c.setUserName(u.getUsername());
		c.setUserId(u.getId());
		annotationDao.persist(c);
	}
	
	@Transactional(propagation = Propagation.REQUIRED, rollbackFor=Exception.class)
	public void merge(Annotation c) {
		annotationDao.merge(c);
	}
	
	@Transactional(propagation = Propagation.REQUIRED, rollbackFor=Exception.class)
	public void remove(Annotation c) {
		Annotation comment = annotationDao.findById(c.getId());
		if (comment != null) {
			annotationDao.remove(comment);
		}
	}
	
	public List<Annotation> findAll(int start, int length, boolean ascending) {
		return annotationDao.findAll(start, length, ascending);
	}
	
	public List<Annotation> findAllByUser(String userName, int start, int length, String sort) {
		if (userName == null) {
			userName = SecurityContextHolder.getContext().getAuthentication().getName();
		}
		return annotationDao.findAllByUser(userName, start, length, sort);
	}
	
	public List<Annotation> findAllByPath(String segmentId, String blockId, String textId, int start, int length, boolean ascending) {
		return annotationDao.findAllByPath(segmentId, blockId, textId, start, length, ascending);
	}
	
	public Annotation findLatestByPath(String segmentId, String blockId, String textId) {
		return annotationDao.findLatestByPath(segmentId, blockId, textId);
	}
	
	public Annotation findById(Long id) {
		return annotationDao.findById(id);
	}
}