package pl.waw.ipipan.corpcor.server;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutHandler;

import pl.waw.ipipan.corpcor.server.pq.PQBridge;

public class CorpCorLogoutHandler implements LogoutHandler {
	private static final Logger LOG = LoggerFactory.getLogger(CorpCorLogoutHandler.class);
	
	@Override
	public void logout(HttpServletRequest arg0, HttpServletResponse arg1,
			Authentication arg2) {
		HttpSession session = arg0.getSession(false);
		LOG.info("LOGOUT HANDLER, SESSION ID: " + ((session == null) ? "NULL" : session.getId()));
		PQBridge.getInstance().forwardSessionClose(session.getId());
	}
}
