/*
 * This file is part of the CorpCorCorpCor suite.
 * 
 * Copyright (C) 2012 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 * 
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file gpl.txt included in the packaging
 * of this file.  (See http://www.gnu.org/licenses/translations.html for
 * unofficial translations.)
 * 
 * A commercial license is available from IPI PAN (contact 
 * ipi@ipipan.waw.pl for more information).  Licensees holding a valid 
 * commercial license from IPI PAN may use this file in accordance with 
 * that license.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */
package pl.waw.ipipan.corpcor.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import pl.waw.ipipan.corpcor.client.CorpCorService;
import pl.waw.ipipan.corpcor.server.CorpCorServiceCaches.GetCorpusSegmentsAction;
import pl.waw.ipipan.corpcor.shared.ResultsPage;
import pl.waw.ipipan.corpcor.shared.pq.PoliqarpContext;
import pl.waw.ipipan.corpcor.shared.pq.PoliqarpException;
import pl.waw.ipipan.corpcor.shared.pq.PoliqarpMetaData;
import pl.waw.ipipan.corpcor.shared.pq.PoliqarpResult;

@Deprecated // unused
public class CorpCorServiceExecutors {
    
    private static final Logger LOG = LoggerFactory.getLogger(CorpCorServiceExecutors.class);

    /*
    // TODO cannot run async yet:
    // 1. CorpusAPI requires a pool
    // 2. corpusApiBridge cannot be accessed in other thread
    static ExecutorService executor = new ScheduledThreadPoolExecutor(5, new ThreadFactory() {
        private AtomicInteger next = new AtomicInteger();
        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "CorpusSegment-loading-thread#" + next.incrementAndGet());
            t.setDaemon(true);
            t.setPriority(Thread.NORM_PRIORITY - 1);
            return t;
        }
    });
    */
    
    static ExecutorService executor = new AbstractExecutorService() {
        
        @Override
        public void execute(Runnable command) {
            command.run();
        }
        
        @Override
        public List<Runnable> shutdownNow() {
            return Collections.emptyList();
        }
        
        @Override
        public void shutdown() {
        }
        
        @Override
        public boolean isTerminated() {
            return false;
        }
        
        @Override
        public boolean isShutdown() {
            return false;
        }
        
        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return false;
        }
    };
    
    void loadCorpusSegmentsSync(CorpCorService service, String query, ResultsPage<PoliqarpResult> results) throws PoliqarpException {
        ArrayList<PoliqarpResult> entries = results.getEntries();
        ArrayList<Future<PoliqarpResult>> futures = new ArrayList<Future<PoliqarpResult>>(entries.size());
        for (PoliqarpResult pqr : entries) {
            // get all metadata and wide context synchronously - that will be faster than concurrently
            // concurrent runs may cause that mutile PQ deamons will be spawned and each will re-run the
            // query which takes time if done for the first time
//            PoliqarpMetaData pqMetaData = service.getPoliqarpMetaData(pqr.getEntryId());
//            PoliqarpContext pqWideContext = service.getPoliqarpWideContext(pqr.getEntryId());
            // but corpus should be searched ideally in parallel - to speed up text browsing
            // on a MP machine
            // TODO
//            GetCorpusSegmentsAction task = new GetCorpusSegmentsAction(service, CorpCorServiceUtils.getSessionId(), pqr, pqMetaData, pqWideContext);
//            futures.add(executor.submit(task));
        }
        try {
            for (Future<PoliqarpResult> future : futures) {
                try {
                    // just wait for the command to complete
                    future.get();
                } catch (ExecutionException e) {
                    LOG.warn("Unhandled GetCorpusSegmentsCmd execution exception", e);
                }
            }
        } catch (InterruptedException e) {
            for (PoliqarpResult pqr : entries) {
                pqr.updateFromCorpusFailed();
            }
        }
    }

}
