/*
 * This file is part of the CorpCorCorpCor suite.
 * 
 * Copyright (C) 2012 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 * 
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file gpl.txt included in the packaging
 * of this file.  (See http://www.gnu.org/licenses/translations.html for
 * unofficial translations.)
 * 
 * A commercial license is available from IPI PAN (contact 
 * ipi@ipipan.waw.pl for more information).  Licensees holding a valid 
 * commercial license from IPI PAN may use this file in accordance with 
 * that license.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */
package pl.waw.ipipan.corpcor.server;

import java.util.StringTokenizer;

import javax.servlet.http.HttpServletRequest;

import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import pl.waw.ipipan.corpcor.shared.pq.PoliqarpResult;

public class CorpCorServiceUtils {

    static int getIndexOfMatchInContext(String contextStr, PoliqarpResult r) {
        int bestmIndex = -1;
        int smallestWordCountDiff = Integer.MAX_VALUE;
        String match = r.getMatch();
        String lContext = r.getLeftContext();
        String rContext = r.getRightContext();
        for (int mIndex = contextStr.indexOf(match); mIndex != -1; mIndex = contextStr.indexOf(match, mIndex + 1)) {
            String lPart = contextStr.substring(0, mIndex);
            String rPart = contextStr.substring(mIndex + match.length());
            // check if L and R contexts are directly aligned to this match position
            int idxOfLMatch = lPart.lastIndexOf(lContext);
            if (idxOfLMatch == -1)
                continue;
            if (!lPart.substring(idxOfLMatch + lContext.length()).replaceAll("\\s", "").isEmpty())
                continue;
            int idxOfRMatch = rPart.indexOf(rContext);
            if (idxOfRMatch == -1)
                continue;
            if (!rPart.substring(0, idxOfRMatch).replaceAll("\\s", "").isEmpty())
                continue;
            // find out how close we're to the middle of context
            int lWordCnt = new StringTokenizer(lPart).countTokens();
            int rWordCnt = new StringTokenizer(rPart).countTokens();
            if (Math.abs(lWordCnt - rWordCnt) < smallestWordCountDiff) {
                smallestWordCountDiff = Math.abs(lWordCnt - rWordCnt);
                bestmIndex = mIndex;
            }
        }
        return bestmIndex;
    }

    static boolean isTestRun() {
        return Thread.currentThread().getName().equals("main");
    }

    private static ThreadLocal<String> temporarySessionOverride = new ThreadLocal<String>();

    static void temporarilyOverrideSessionId(String sessionId) {
        temporarySessionOverride.set(sessionId);
    }

    static String getSessionId() {
        try {
            String string = CorpCorServiceUtils.temporarySessionOverride.get();
            if (string != null)
                return string;
            ServletRequestAttributes cr = (ServletRequestAttributes) RequestContextHolder.currentRequestAttributes();
            HttpServletRequest request = cr.getRequest();
            String sid = request.getSession(false).getId();
            return sid;
        } catch (IllegalStateException e) {
            if (isTestRun())
                return "test-session";
            throw e;
        }
    }
}
