package pl.waw.ipipan.corpcor.server;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;

import pl.waw.ipipan.corpcor.server.model.User;

@Component
public class JpaUserDetailsService implements UserDetailsService {
	@PersistenceContext
    private EntityManager em;
	
	@Override
	public UserDetails loadUserByUsername(String username)
			throws UsernameNotFoundException {
		return em.createQuery("from User where username = :username", User.class)
				.setParameter("username", username)
				.getSingleResult();
	}

}
