package pl.waw.ipipan.corpcor.server.corpusapi.tei;

import java.io.IOException;
import java.util.List;

import javax.xml.stream.XMLStreamException;

import pl.waw.ipipan.corpcor.server.corpusapi.ContinueMode;
import pl.waw.ipipan.corpcor.server.corpusapi.SentenceSegmentGroup;
import pl.waw.ipipan.corpcor.server.corpusapi.tei.readers.TEIReader;
import pl.waw.ipipan.corpcor.server.corpusapi.tei.readers.TEISegmentationReader;


public class TEISentenceSegmentGroup extends TEISegmentGroup implements
		SentenceSegmentGroup {
	
	public TEISentenceSegmentGroup(String id, List<String> segmentIdList, String nextGroupId, String prevGroupId, TEICorpusText corpusText) {
		super(id, corpusText, segmentIdList, nextGroupId, prevGroupId);
	}

	@Override
	public TEISentenceSegmentGroup getNext(ContinueMode mode) {

		if (nextGroupId == null) return null;

		//obliczanie kolejnej grupy
		TEISegmentGroup nextSentence = null; 
		try {
			TEISegmentationReader segmentationReader = ((TEICorpus)corpusText.getCorpus()).getTEISegmentationReader(corpusText);
			nextSentence = segmentationReader.getSentenceSegmentGroupById(nextGroupId);
		} catch (XMLStreamException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		return (TEISentenceSegmentGroup) getNeighbour(mode, this, nextSentence, false);
	}

	@Override
	public TEISentenceSegmentGroup getPrev(ContinueMode mode) {

		if (prevGroupId == null) return null;
		
		//obliczanie poprzedniej grupy
		TEISegmentGroup prevSentence = null; 
		try {
			TEISegmentationReader segmentationReader = ((TEICorpus)corpusText.getCorpus()).getTEISegmentationReader(corpusText);
			prevSentence = segmentationReader.getSentenceSegmentGroupById(prevGroupId);
		} catch (XMLStreamException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		return (TEISentenceSegmentGroup) getNeighbour(mode, prevSentence, this, true);
	}

	@Override
	public int[] getSegmentPositions() {
		int[] result = new int[segmentIdList.size()];
	
		//zalozenie - zdanie jest w jednym bloku tekstu i jest ciagle.
		try {			
			TEISegmentationReader segmentationReader = ((TEICorpus)corpusText.getCorpus()).getTEISegmentationReader(corpusText);
			TEISegment seg = segmentationReader.getSegmentById(segmentIdList.get(0));
			int start = seg.segmentPosition;
			for (int i = 0; i < segmentIdList.size(); i++) {
				result[i] = start + i;
			}
		} catch (XMLStreamException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
				
		return result;
	}
	
	@Override
	public String toString() {
		String sentence = "";
		for (String id : segmentIdList) {
			TEISegment s = null;
			try {
				TEISegmentationReader segmentationReader = ((TEICorpus)corpusText.getCorpus()).getTEISegmentationReader(corpusText);
				s = segmentationReader.getSegmentById(id);
			} catch (XMLStreamException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			sentence += s.getOrth()+" ";
		}
		return "TEISentence ["+sentence+"]";
	}

}
