package pl.waw.ipipan.corpcor.server.corpusapi.tei;

import java.io.IOException;

import javax.xml.stream.XMLStreamException;

import pl.waw.ipipan.corpcor.server.corpusapi.SegmentGroup;
import pl.waw.ipipan.corpcor.server.corpusapi.TextBlock;
import pl.waw.ipipan.corpcor.server.corpusapi.tei.readers.TEIReader;
import pl.waw.ipipan.corpcor.server.corpusapi.tei.readers.TEISegmentationReader;


public class TEITextBlock implements TextBlock {
	private TEICorpusText corpusText;
	private String textBlockId;
	private TextBlockType textBlockType;

	protected long filePosition; // pozycja w pliku text.xml
	protected int position; // pozycja na liscie w TEICorpusText
	protected boolean prevRelated;
	protected boolean nextRelated;
	protected long length;
	private int size = -1; // ilosc segmentow

	public TEITextBlock(TEICorpusText corpusText, String textBlockId, String textBlockType, long filePosition,
			int length, boolean prevRelated, boolean nextRelated, int position) {
		this.corpusText = corpusText;
		this.length = length;
		this.textBlockId = textBlockId;
		if ("ab".equalsIgnoreCase(textBlockType)) {
			this.textBlockType = TextBlockType.AB;
		} else if ("ab".equalsIgnoreCase(textBlockType)) {
			this.textBlockType = TextBlockType.P;
		} else if ("u".equalsIgnoreCase(textBlockType)) {
			this.textBlockType = TextBlockType.U;
		}

		this.filePosition = filePosition;
		this.prevRelated = prevRelated;
		this.nextRelated = nextRelated;
		this.position = position;
	}

	@Override
	public TEISegment getSegment(int idx) throws Exception {
		if (idx < 0 || idx >= getSize()) {
			return null;
		}

		TEISegment result = null;
		TEISegmentationReader reader = ((TEICorpus)corpusText.getCorpus()).getTEISegmentationReader(corpusText);
		try {
			int currentIndex = 0;
			result = reader.getFirstSegmentInBlock(textBlockId);

			while (currentIndex < idx && result != null) {
				result = result.getNext();
				currentIndex++;
			}

		} catch (XMLStreamException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		if (result != null) {
			result.textBlock = this;
		}
		return result;
	}

	@Override
	public int getSize() {
		if (size == -1) {
			TEISegmentationReader reader = ((TEICorpus)corpusText.getCorpus()).getTEISegmentationReader(corpusText);
			try {
				size = reader.getBlockSize(textBlockId);
			} catch (XMLStreamException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

		return size;
	}

	@Override
	public TextBlockType getType() {
		return textBlockType;
	}

	@Override
	public boolean isNextRelated() {
		return nextRelated;
	}

	@Override
	public boolean isPrevRelated() {
		return prevRelated;
	}

	@Override
	public TEICorpusText getCorpusText() {
		return corpusText;
	}

	public String toString() {
		return textBlockType + " : " + filePosition + " : " + length + " : " + textBlockId + " : " + prevRelated
				+ " : " + nextRelated;
	}

	@Override
	public long getLength() {
		return length;
	}

	@Override
	public TEITextBlock getNext() {
		return corpusText.getTextBlock(position + 1);
	}

	@Override
	public TEITextBlock getPrev() {
		return corpusText.getTextBlock(position - 1);
	}

	@Override
	public TEISegmentGroup getSegmentGroup(int idx, Class<? extends SegmentGroup> type) throws Exception {

		TEISegment s = getSegment(idx);
		if (s != null) {
			return s.getSegmentGroup(type);
		}

		return null;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((corpusText == null) ? 0 : corpusText.hashCode());
		result = prime * result + ((textBlockId == null) ? 0 : textBlockId.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		TEITextBlock other = (TEITextBlock) obj;
		if (corpusText == null) {
			if (other.corpusText != null)
				return false;
		} else if (!corpusText.equals(other.corpusText))
			return false;
		if (textBlockId == null) {
			if (other.textBlockId != null)
				return false;
		} else if (!textBlockId.equals(other.textBlockId))
			return false;
		return true;
	}

	public boolean isRelatedToSuccessor(TEITextBlock other) {
		// To są te same bloki
		if (this.equals(other))
			return true;

		// Bieżący nie jest związany z żadnym kolejnym
		if (!this.isNextRelated())
			return false;

		TEITextBlock block = this.getNext();
		while ((block != null) && (!block.equals(other))) {
			if (block.isNextRelated()) {
				block = block.getNext();
			} else {
				return false;
			}
		}

		if (block == null) {
			return false;
		} else {
			return true;
		}
	}

	@Override
	public String getId() {
		return textBlockId;
	}

	public int getPosition() {
		return position;
	}
}
