package pl.waw.ipipan.corpcor.server.corpusapi.tei.readers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashSet;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;

import org.codehaus.stax2.XMLStreamReader2;

import pl.waw.ipipan.corpcor.server.corpusapi.tei.TEICorpus;
import pl.waw.ipipan.corpcor.server.corpusapi.tei.TEICorpusText;


public class TEIReader {
	protected TEICorpusText corpusText;
	protected File file;
	protected String fileContents;
	protected Collection<Reader> readers = new HashSet<Reader>();
	protected boolean cached;
	protected Integer cacheMaxItems = null;

	public TEIReader(String fileName, TEICorpusText corpusText) {
		this.file = new File(fileName);
		this.corpusText = corpusText;
		this.cached = corpusText.getCorpus().isCached();
		if (this.cached) {
			cacheMaxItems = 100;
		}
	}

	

	/**
	 * Wczytuje plik XML do pamieci, jesli wczesniej nie zostal wczytany oraz
	 * tworzy nowy obiekt klasy StringReader do odczytu z tego pliku. Ta metoda
	 * odczytuje plik z dysku maksymalnie jeden raz.
	 * 
	 * @return obiekt klasy StringReader do czytania z pliku XML
	 * @throws IOException
	 */
	public Reader createTextReader() throws IOException {
		Reader r = new BufferedReader(new InputStreamReader(new FileInputStream(file), "UTF-8"));
		readers.add(r);
		return r;
	}

	/**
	 * Tworzy nowy EventReader na nowym strumieniu StringReader.
	 * 
	 * @return obiekt XMLEventReader dla pliku
	 * @throws XMLStreamException
	 * @throws IOException
	 */
	public XMLEventReader createEventReader() throws XMLStreamException, IOException {
		return ((TEICorpus)corpusText.getCorpus()).getXMLInputFactory().createXMLEventReader(createTextReader());
	}

	/**
	 * Tworzy nowy StreamReader na nowym strumieniu StringReader.
	 * 
	 * @return obiekt XMLStreamReader dla pliku
	 * @throws XMLStreamException
	 * @throws IOException
	 */
	public XMLStreamReader2 createStreamReader() throws XMLStreamException, IOException {
		return (XMLStreamReader2)((TEICorpus)corpusText.getCorpus()).getXMLInputFactory().createXMLStreamReader(createTextReader());
	}

	/**
	 * Probuje zwolnic wykorzystywane zasoby poprzez zwolnienie pamieci
	 * zarezerwowanej na wczytany plik, zamkniecie domyslnego parsera i
	 * strumienia znakowego.
	 * 
	 * @throws XMLStreamException
	 * @throws IOException 
	 * 
	 */
	public void close() throws XMLStreamException, IOException {
				
		for (Reader r : readers) {
			r.close();
		}
		
		readers.clear();
		
		fileContents = null;
		file = null;
		corpusText = null;
	}

}
