package pl.waw.ipipan.corpcor.server.dao;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

import org.springframework.stereotype.Repository;

import com.google.common.base.Splitter;

import pl.waw.ipipan.corpcor.server.model.Annotation;
import pl.waw.ipipan.corpcor.shared.AnnotationProxyUtils;

@Repository("annotationDao")
public class AnnotationDao implements JpaDAO<Long, Annotation> {
	@PersistenceContext
    private EntityManager em;
    
	@Override
	public void persist(Annotation entity) {
		em.persist(entity);
	}

	@Override
	public void remove(Annotation entity) {
		em.remove(entity);
	}

	@Override
	public Annotation merge(Annotation entity) {
		return em.merge(entity);
	}

	@Override
	public void refresh(Annotation entity) {
		em.refresh(entity);
	}

	@Override
	public Annotation findById(Long id) {
		return em.find(Annotation.class, id);
	}

	@Override
	public Annotation flush(Annotation entity) {
		em.flush();
		return entity;
	}

	@Override
	public List<Annotation> findAll() {
		return em.createQuery("FROM Annotation", Annotation.class).getResultList();
	}
	
	public List<Annotation> findAll(int start, int length, boolean ascending) {
		String query = "FROM Annotation ORDER BY added " + ((ascending) ? "ASC" : "DESC");
		if (length >= 0) {
			return em.createQuery(query, Annotation.class)
					.setFirstResult(start).setMaxResults(length).getResultList();
		} else {
			return em.createQuery(query, Annotation.class)
					.setFirstResult(start).getResultList();
		}
	}

	@Override
	public Integer removeAll() {
		return em.createQuery("DELETE FROM Annotation").executeUpdate();
	}
	
	public List<Annotation> findAllByUser(String userName, int start, int length, String sort) {
		Splitter splitter = Splitter.on(",").omitEmptyStrings().trimResults();
		Iterable<String> column = splitter.split(sort);
		
		StringBuffer query = new StringBuffer();
		query.append("FROM Annotation AS a Where a.userName=:userName");
		boolean first = true;
		for (String s : column) {
			if (first) {
				query.append(" ORDER BY ");
			} else {
				query.append(",");
			}
			first = false;
			
			String[] pair = s.split(":");
			if (AnnotationProxyUtils.getUserNameField().equals(pair[0])) {
				query.append("userName");
			} else if (AnnotationProxyUtils.getAddedField().equals(pair[0])) {
				query.append("added");
			} else if (AnnotationProxyUtils.getSegmentIdField().equals(pair[0])) {
				query.append("segmentId");
			} else if (AnnotationProxyUtils.getTextIdField().equals(pair[0])) {
				query.append("textId");
			}
			
			if ("ASC".equals(pair[1])) {
				query.append(" ASC");
			} else {
				query.append(" DESC");
			}
		}
		
		if (length >= 0) {
			return em.createQuery(query.toString(), Annotation.class).setParameter("userName", userName)
					.setFirstResult(start).setMaxResults(length).getResultList();
		} else {
			return em.createQuery(query.toString(), Annotation.class).setParameter("userName", userName)
					.setFirstResult(start).getResultList();
		}
	}
	
	public List<Annotation> findAllByPath(String segmentId, String blockId, String textId, int start, int length, boolean ascending) {
		String query = "FROM Annotation AS a Where a.segmentId=:segmentId AND a.blockId=:blockId AND a.textId=:textId ORDER BY added " + ((ascending) ? "ASC" : "DESC");
		if (length >= 0) {
			return em.createQuery(query, Annotation.class).setParameter("segmentId", segmentId).setParameter("blockId", blockId).setParameter("textId", textId)
					.setFirstResult(start).setMaxResults(length).getResultList();
		} else {
			return em.createQuery(query, Annotation.class).setParameter("segmentId", segmentId).setParameter("blockId", blockId).setParameter("textId", textId)
					.setFirstResult(start).getResultList();
		}
	}

	public Annotation findLatestByPath(String segmentId, String blockId,
			String textId) {
		String query = "FROM Annotation AS a Where a.segmentId=:segmentId AND a.blockId=:blockId AND a.textId=:textId ORDER BY added DESC";
		List<Annotation> results = em.createQuery(query, Annotation.class).setParameter("segmentId", segmentId).setParameter("blockId", blockId).setParameter("textId", textId)
				.getResultList();
		
		if (results.size() > 0) {
			return results.get(0);
		}
		
		return null;
	}
	
}
