/*
 * This file is part of the CorpCor suite.
 * 
 * Copyright (C) 2012 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 * 
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file gpl.txt included in the packaging
 * of this file.  (See http://www.gnu.org/licenses/translations.html for
 * unofficial translations.)
 * 
 * A commercial license is available from IPI PAN (contact 
 * ipi@ipipan.waw.pl for more information).  Licensees holding a valid 
 * commercial license from IPI PAN may use this file in accordance with 
 * that license.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */
package pl.waw.ipipan.corpcor.server.pq.client.api.common_1_3_12.brokers;

import ipipan.poliqarp.logic.Corpus;

public interface CorpusListener {

    public static interface InvocationHandler {
        void invoke(CorpusListener l, Corpus cs);
    }

    public static enum Transition implements InvocationHandler {
        OPENED {
            public void invoke(CorpusListener l, Corpus cs) {
                l.opened(cs);
            }
        },
        OPEN_FAILED {
            public void invoke(CorpusListener l, Corpus cs) {
                l.openFailed(cs);
            }
        },
        CLOSED {
            public void invoke(CorpusListener l, Corpus cs) {
                l.closed(cs);
            }
        },
        UNKNOWN {
            public void invoke(CorpusListener l, Corpus cs) {
                System.err.println("Unmapped transition on CorpusService " + cs);
            }
        };
    }

    void opened(Corpus corpus);

    void openFailed(Corpus corpus);

    void closed(Corpus corpus);
}
