/*
 * This file is part of the CorpCor suite.
 * 
 * Copyright (C) 2012 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 * 
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file gpl.txt included in the packaging
 * of this file.  (See http://www.gnu.org/licenses/translations.html for
 * unofficial translations.)
 * 
 * A commercial license is available from IPI PAN (contact 
 * ipi@ipipan.waw.pl for more information).  Licensees holding a valid 
 * commercial license from IPI PAN may use this file in accordance with 
 * that license.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */
package pl.waw.ipipan.corpcor.server.pq.client.api.common_1_3_12.requests;

import ipipan.poliqarp.connection.PoliqarpConnection;
import ipipan.poliqarp.gui.Configuration;
import ipipan.poliqarp.logic.Corpus;
import ipipan.poliqarp.stat.Tagset;

import java.util.Locale;
import java.util.concurrent.Executor;

import pl.waw.ipipan.corpcor.server.pq.client.tickets.PQCRequestTicket;

public class RequestFactory {

    private final Executor executor;
    private final Configuration config;
    private final PoliqarpConnection connection;
    private final Corpus corpus;
    private final Tagset tagset;

    public RequestFactory(Executor executor, Configuration config, PoliqarpConnection connection, Corpus corpus,
            Tagset tagset) {
        this.executor = executor;
        this.config = config;
        this.connection = connection;
        this.corpus = corpus;
        this.tagset = tagset;
    }

    public Request createRequest(PQCRequestTicket.TicketType tt) {
        switch (tt) {
        case QUERY:
            return new QueryRequest(this);
        default:
            throw new IllegalArgumentException(tt.toString());
        }
    }

    public Executor getExecutor() {
        return executor;
    }

    public Configuration getConfig() {
        return config;
    }

    public PoliqarpConnection getConnection() {
        return connection;
    }

    public Corpus getCorpus() {
        return corpus;
    }

    public Tagset getTagset() {
        return tagset;
    }

    public Locale getLocale() {
        // TODO
        return Locale.getDefault();
    }
}
