package pl.waw.ipipan.corpcor.shared;

import pl.waw.ipipan.corpcor.shared.corpusapi.CorpusSegment;

public class AnnotationProxyUtils {
	public static String getUserNameField() {
		return "USERNAME";
	}
	public static String getAddedField() {
		return "ADDED";
	}
	public static String getSegmentIdField() {
		return "SEGMENTID";
	}
	public static String getTextIdField() {
		return "TEXTID";
	}
	
	public static void populateFromCorpusSegment(CorpusSegment cs, AnnotationProxy ap) {
		ap.setSegmentId(cs.getSegmentId());
		ap.setBlockId(cs.getBlockId());
		ap.setTextId(cs.getTextId());
		ap.setOrth(cs.getOrth());
		ap.setBase(cs.getBase());
		ap.setMsd(cs.getMsd());
		ap.setCtag(cs.getCtag());
		ap.setComment(cs.getComment());
		ap.setDeleted(cs.isDeleted());
		
		ap.setLastOrth(cs.getOrth());
		ap.setLastBase(cs.getBase());
		ap.setLastMsd(cs.getMsd());
		ap.setLastCtag(cs.getCtag());
		ap.setLastDeleted(cs.isDeleted());
	}
	
	public static void populateFromAnnotationProxy(AnnotationProxy from, AnnotationProxy to) {
		to.setSegmentId(from.getSegmentId());
		to.setBlockId(from.getBlockId());
		to.setTextId(from.getTextId());
		to.setOrth(from.getOrth());
		to.setBase(from.getBase());
		to.setMsd(from.getMsd());
		to.setCtag(from.getCtag());
		to.setComment(from.getComment());
		to.setDeleted(from.isDeleted());
		
		to.setLastOrth(from.getOrth());
		to.setLastBase(from.getBase());
		to.setLastMsd(from.getMsd());
		to.setLastCtag(from.getCtag());
		to.setLastDeleted(from.isDeleted());
	}
	
	public static void cloneAnnotationProxy(AnnotationProxy from, AnnotationProxy to) {
		to.setSegmentId(from.getSegmentId());
		to.setBlockId(from.getBlockId());
		to.setTextId(from.getTextId());
		to.setOrth(from.getOrth());
		to.setBase(from.getBase());
		to.setMsd(from.getMsd());
		to.setCtag(from.getCtag());
		to.setComment(from.getComment());
		to.setDeleted(from.isDeleted());
		
		to.setLastOrth(from.getLastOrth());
		to.setLastBase(from.getLastBase());
		to.setLastMsd(from.getLastMsd());
		to.setLastCtag(from.getLastCtag());
		to.setLastDeleted(from.isLastDeleted());
	}
	
	public static String changesAsString(AnnotationProxy object) {
		StringBuilder sb = new StringBuilder();
		String changed = getChange(object.getLastOrth(), object.getOrth());
		if (changed != null) {
			sb.append(" [orth=" + changed + "]");
		}
		
		changed = getChange(object.getLastBase(), object.getBase());
		if (changed != null) {
			sb.append(" [base=" + changed + "]");
		}
			
		changed = getChange(object.getLastMsd(), object.getMsd());
		if (changed != null) {
			sb.append(" [msd=" + changed + "]");
		}
			
		changed = getChange(object.getLastCtag(), object.getCtag());
		if (changed != null) {
			sb.append(" [ctag=" + changed + "]");
		}
		
		if (object.isLastDeleted() != object.isDeleted()) {
			sb.append(" [deleted=" + object.isDeleted() + "]");
		}
		
		return sb.toString();
	}
	
	private static String getChange(String first, String second) {
		if (first == null) {
			if (second == null) {
				return null;
			}
			
			if (second.trim().length() == 0) {
				return null;
			}
			
			return "NULL --> " + second;
		}
		
		if (second == null) {
			if (first.trim().length() == 0) {
				return null;
			}
			
			return first + " --> NULL";
		}
		
		if (first.equals(second)) {
			return null;
		}
		
		return first + " --> " + second;
	}
}
