package pl.waw.ipipan.corpcor.shared;

import java.util.List;

import pl.waw.ipipan.corpcor.server.AnnotationService;
import pl.waw.ipipan.corpcor.server.GwtServiceLocator;

import com.google.web.bindery.requestfactory.shared.Request;
import com.google.web.bindery.requestfactory.shared.RequestContext;
import com.google.web.bindery.requestfactory.shared.Service;

@Service(value=AnnotationService.class, locator=GwtServiceLocator.class)
public interface AnnotationRequest extends RequestContext {
	Request<AnnotationProxy> findById(Long key);
	Request<List<AnnotationProxy>> findAll(int start, int length, boolean ascending);
	Request<Void> persist(AnnotationProxy annotation);
	Request<Void> remove(AnnotationProxy annotation);
	Request<Void> merge(AnnotationProxy annotation);
	Request<List<AnnotationProxy>> findAllByUser(String userName, int start, int length, String sort);
	Request<List<AnnotationProxy>> findAllByPath(String segmentId, String blockId, String textId, int start, int length, boolean ascending);
	Request<AnnotationProxy> findLatestByPath(String segmentId, String blockId, String textId);
}
