/*
 * This file is part of the CorpCor suite.
 * 
 * Copyright (C) 2012 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 * 
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file gpl.txt included in the packaging
 * of this file.  (See http://www.gnu.org/licenses/translations.html for
 * unofficial translations.)
 * 
 * A commercial license is available from IPI PAN (contact 
 * ipi@ipipan.waw.pl for more information).  Licensees holding a valid 
 * commercial license from IPI PAN may use this file in accordance with 
 * that license.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */
package pl.waw.ipipan.corpcor.shared;

import java.io.Serializable;
import java.util.ArrayList;

public class ResultsPage<T extends Serializable> implements Serializable {
    private static final long serialVersionUID = 1L;

    private ArrayList<T> entries;
    private int globalSize;
    
    public ResultsPage() {
        entries = new ArrayList<T>();
        globalSize = 0;
    }

	public ResultsPage(ArrayList<T> entries, int globalSize) {
        this.entries = entries;
        this.globalSize = globalSize;
    }

    public ArrayList<T> getEntries() {
        return entries;
    }

    public int getGlobalSize() {
        return globalSize;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ResultsPage globalSize = ");
        sb.append(this.globalSize);
        sb.append("\n");
        for (T pqres : this.entries) {
            sb.append(pqres);
            sb.append("\n");
        }
        return sb.toString();
    }

	public void setGlobalSize(int count) {
		this.globalSize = count;
	}

	public void setEntries(ArrayList<T> list) {
		this.entries = list;
	}
}
