/*
 * This file is part of the CorpCor suite.
 * 
 * Copyright (C) 2012 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 * 
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file gpl.txt included in the packaging
 * of this file.  (See http://www.gnu.org/licenses/translations.html for
 * unofficial translations.)
 * 
 * A commercial license is available from IPI PAN (contact 
 * ipi@ipipan.waw.pl for more information).  Licensees holding a valid 
 * commercial license from IPI PAN may use this file in accordance with 
 * that license.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */
package pl.waw.ipipan.corpcor.shared.corpusapi;

import java.io.Serializable;

public class CorpusSegment implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    private String textId;
    private String blockId;
    private String segmentId;
    private String orth;
    private String base;
    private String msd;
    private String ctag;
    private String comment;
    private boolean deleted;

    public CorpusSegment() {
        this("", "", "");
    }

    public CorpusSegment(String textId, String blockId, String segmentId) {
        this.textId = textId;
        this.blockId = blockId;
        this.segmentId = segmentId;
    }

    public String getBlockId() {
        return blockId;
    }

    public String getTextId() {
        return textId;
    }

    public String getSegmentId() {
        return segmentId;
    }

    public String getOrth() {
        return orth;
    }

    public String getBase() {
        return base;
    }

    public String getMsd() {
        return msd;
    }

    public String getCtag() {
        return ctag;
    }

    public void setMorpho(String orth, String base, String msd, String ctag) {
        this.orth = orth;
    	this.base = base;
        this.msd = msd;
        this.ctag = ctag;
    }

    public void copyFrom(CorpusSegment other) {
    	this.orth = other.orth;
        this.base = other.base;
        this.msd = other.msd;
        this.ctag = other.ctag;
        this.comment = other.comment;
        this.deleted = other.deleted;
    }

    public String toAnnotationString() {
        return "[base=" + base + ", msd=" + msd + ", ctag=" + ctag + "]";
    }
    
    public CorpusSegment clone() {
        CorpusSegment corpusSegment = new CorpusSegment(textId, blockId, segmentId);
        corpusSegment.setMorpho(orth, base, msd, ctag);
        corpusSegment.setComment(comment);
        corpusSegment.setDeleted(deleted);
        return corpusSegment;
    }

	@Override
	public String toString() {
		return "CorpusSegment [textId=" + textId + ", blockId=" + blockId
				+ ", segmentId=" + segmentId + ", orth=" + orth + ", base="
				+ base + ", msd=" + msd + ", ctag=" + ctag + ", comment="
				+ comment + ", deleted=" + deleted + "]";
	}

	public String getComment() {
		return comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}

	public boolean isDeleted() {
		return deleted;
	}

	public void setDeleted(boolean deleted) {
		this.deleted = deleted;
	}
}
