#!/bin/bash

TEI_ROOT=`pwd`
if [ "$1" != "" ]
then
    TEI_ROOT=$1
fi

echo 'Validating LUNA...'

function doValidate {
    filepath=$1
    what=`echo $filepath | sed 's/.*\/[a-z]\+_\([a-z]\+\).xml$/\1/g'`
    xmllint --noout --xinclude --relaxng LUNA_$what.rng $filepath
    if [ $? -ne 0 ]
    then
        echo "Validation failed" >&2
        exit 1
    fi
}

for f in `find $TEI_ROOT -name text_structure.xml | sort`
do
  dirpath=`dirname $f`
  echo "Validating $dirpath ..."
  doValidate $dirpath/text_structure.xml
  doValidate $dirpath/ann_segmentation.xml
  doValidate $dirpath/ann_morphosyntax.xml
  doValidate $dirpath/ann_words.xml
  doValidate $dirpath/ann_concepts.xml
  if [ -f $dirpath/LUNA_header.xml ]
  then
    doValidate $dirpath/ann_frames.xml
    doValidate $dirpath/ann_anaphoras.xml
  fi
done

