/*
 * Decompiled with CFR 0.152.
 */
package org.eml.MMAX2.core;

import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.eml.MMAX2.Messages;
import org.eml.MMAX2.core.MMAX2;
import org.eml.MMAX2.core.UserSettings;

public class MainMenu
extends JMenuBar
implements ActionListener {
    private static final long serialVersionUID = 2276500931396328244L;
    private static final Logger logger = Logger.getLogger(MainMenu.class);
    private final MMAX2 mmax;
    private JMenuItem saveAll;
    private JMenuItem undo;
    private JMenu autoSaveMenu;
    private JMenu autoSaveEveryMenu;
    private final JMenu settingsMenu;
    private final JMenu displayMenu;
    private final JMenu browserMenu;
    private JMenuItem markableBrowserItem;
    private JMenuItem setBrowserItem;
    private JMenuItem pointerBrowserItem;
    private final JMenu pluginMenu;
    private JMenuItem superannoItem;

    public MainMenu(MMAX2 mmax2, UserSettings us) {
        this.mmax = mmax2;
        JMenu fileMenu = new JMenu(Messages.getString("MMAX2.File"));
        this.fillFileMenu(fileMenu);
        this.add(fileMenu);
        this.settingsMenu = new JMenu(Messages.getString("MMAX2.Settings"));
        this.settingsMenu.setEnabled(false);
        this.fillSettingsMenu(this.settingsMenu, us);
        this.add(this.settingsMenu);
        this.displayMenu = new JMenu(Messages.getString("MMAX2.Display"));
        this.displayMenu.setEnabled(false);
        this.fillDisplayMenu(this.displayMenu, us);
        this.add(this.displayMenu);
        this.browserMenu = new JMenu(Messages.getString("MMAX2.Browsers"));
        this.browserMenu.setEnabled(false);
        this.fillBrowserMenu(this.browserMenu);
        this.add(this.browserMenu);
        this.pluginMenu = new JMenu(Messages.getString("MMAX2.Plugins"));
        this.pluginMenu.setEnabled(false);
        this.fillPluginMenu(this.pluginMenu);
        this.add(this.pluginMenu);
    }

    private void fillBrowserMenu(JMenu browserMenu) {
        browserMenu.removeAll();
        this.markableBrowserItem = new JMenuItem(Messages.getString("MMAX2.Markable_browser"));
        this.markableBrowserItem.setEnabled(false);
        this.markableBrowserItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MainMenu.this.mmax.requestMarkableBrowser();
            }
        });
        browserMenu.add(this.markableBrowserItem);
        this.setBrowserItem = new JMenuItem(Messages.getString("MMAX2.Markable_set_browser"));
        this.setBrowserItem.setEnabled(false);
        this.setBrowserItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MainMenu.this.mmax.requestMarkableSetBrowser();
            }
        });
        browserMenu.add(this.setBrowserItem);
        this.pointerBrowserItem = new JMenuItem(Messages.getString("MMAX2.Markable_pointer_browser"));
        this.pointerBrowserItem.setEnabled(false);
        this.pointerBrowserItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MainMenu.this.mmax.requestMarkablePointerBrowser();
            }
        });
        browserMenu.add(this.pointerBrowserItem);
    }

    private void fillFileMenu(JMenu fileMenu) {
        fileMenu.removeAll();
        JMenuItem loadFile = new JMenuItem(Messages.getString("MMAX2.Load"));
        loadFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MainMenu.this.mmax.requestLoadFile();
            }
        });
        fileMenu.add(loadFile);
        JMenuItem loadNextFile = new JMenuItem(Messages.getString("MMAX2.Load_next"));
        loadNextFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MainMenu.this.mmax.loadNextText();
            }
        });
        loadNextFile.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        fileMenu.add(loadNextFile);
        this.undo = new JMenuItem(Messages.getString("MMAX2.Undo"));
        this.undo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MainMenu.this.mmax.requestUndo();
            }
        });
        this.undo.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.undo.setEnabled(false);
        fileMenu.add(this.undo);
        this.saveAll = new JMenuItem(Messages.getString("MMAX2.Save"));
        this.saveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MainMenu.this.mmax.requestSaveAll();
            }
        });
        this.saveAll.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveAll.setEnabled(false);
        fileMenu.add(this.saveAll);
        ButtonGroup autoSaveEveryMenuButtongroup = new ButtonGroup();
        this.autoSaveMenu = new JMenu(Messages.getString("MMAX2.Auto-save"));
        this.autoSaveMenu.setEnabled(false);
        this.autoSaveEveryMenu = new JMenu(Messages.getString("MMAX2.Every"));
        JRadioButtonMenuItem tempAutoSaveItem0 = new JRadioButtonMenuItem(Messages.getString("MMAX2.0_mins_off"));
        autoSaveEveryMenuButtongroup.add(tempAutoSaveItem0);
        tempAutoSaveItem0.setSelected(true);
        tempAutoSaveItem0.addActionListener(this);
        tempAutoSaveItem0.setActionCommand("auto-save:0");
        this.autoSaveEveryMenu.add(tempAutoSaveItem0);
        JRadioButtonMenuItem tempAutoSaveItem1 = null;
        tempAutoSaveItem1 = new JRadioButtonMenuItem(Messages.getString("MMAX2.1_min"));
        autoSaveEveryMenuButtongroup.add(tempAutoSaveItem1);
        tempAutoSaveItem1.addActionListener(this);
        tempAutoSaveItem1.setActionCommand("auto-save:1");
        this.autoSaveEveryMenu.add(tempAutoSaveItem1);
        JRadioButtonMenuItem tempAutoSaveItem5 = null;
        tempAutoSaveItem5 = new JRadioButtonMenuItem(Messages.getString("MMAX2.5_mins"));
        autoSaveEveryMenuButtongroup.add(tempAutoSaveItem5);
        tempAutoSaveItem5.addActionListener(this);
        tempAutoSaveItem5.setActionCommand("auto-save:5");
        this.autoSaveEveryMenu.add(tempAutoSaveItem5);
        JRadioButtonMenuItem tempAutoSaveItem10 = null;
        tempAutoSaveItem10 = new JRadioButtonMenuItem(Messages.getString("MMAX2.10_mins"));
        autoSaveEveryMenuButtongroup.add(tempAutoSaveItem10);
        tempAutoSaveItem10.addActionListener(this);
        tempAutoSaveItem10.setActionCommand("auto-save:10");
        this.autoSaveEveryMenu.add(tempAutoSaveItem10);
        JRadioButtonMenuItem tempAutoSaveItem15 = null;
        tempAutoSaveItem15 = new JRadioButtonMenuItem(Messages.getString("MMAX2.15_mins"));
        autoSaveEveryMenuButtongroup.add(tempAutoSaveItem15);
        tempAutoSaveItem15.addActionListener(this);
        tempAutoSaveItem15.setActionCommand("auto-save:15");
        this.autoSaveEveryMenu.add(tempAutoSaveItem15);
        this.autoSaveMenu.add(this.autoSaveEveryMenu);
        fileMenu.add(this.autoSaveMenu);
        JMenuItem exit = new JMenuItem(Messages.getString("MMAX2.Exit"));
        exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MainMenu.this.mmax.requestExit();
            }
        });
        exit.setEnabled(true);
        exit.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        fileMenu.add(exit);
    }

    private JMenu fillSettingsMenu(JMenu settingsMenu, final UserSettings us) {
        settingsMenu.removeAll();
        final JCheckBoxMenuItem suppressHandlesWhenRenderingMenuItem = new JCheckBoxMenuItem(Messages.getString("MMAX2.Suppress_handle_highlights_when_rendering_sets"));
        suppressHandlesWhenRenderingMenuItem.setSelected(us.isSuppressHandlesWhenRendering());
        suppressHandlesWhenRenderingMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JCheckBoxMenuItem source = (JCheckBoxMenuItem)ae.getSource();
                us.setSuppressHandlesWhenRendering(source.isSelected());
            }
        });
        JCheckBoxMenuItem highlightHandlesMenuItem = new JCheckBoxMenuItem(Messages.getString("MMAX2.Highlight_matching_handles"));
        highlightHandlesMenuItem.setSelected(us.isHighlightMatchingHandles());
        highlightHandlesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JCheckBoxMenuItem source = (JCheckBoxMenuItem)ae.getSource();
                MainMenu.this.mmax.setHighlightMatchingHandles(source.isSelected());
                if (source.isSelected()) {
                    suppressHandlesWhenRenderingMenuItem.setEnabled(true);
                } else {
                    suppressHandlesWhenRenderingMenuItem.setEnabled(false);
                }
            }
        });
        settingsMenu.add(highlightHandlesMenuItem);
        settingsMenu.add(suppressHandlesWhenRenderingMenuItem);
        settingsMenu.addSeparator();
        JCheckBoxMenuItem createSilentlyMenuItem = new JCheckBoxMenuItem(Messages.getString("MMAX2.Create_new_markable_silently"));
        createSilentlyMenuItem.setSelected(us.isCreateSilently());
        createSilentlyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JCheckBoxMenuItem source = (JCheckBoxMenuItem)ae.getSource();
                us.setCreateSilently(source.isSelected());
            }
        });
        settingsMenu.add(createSilentlyMenuItem);
        JCheckBoxMenuItem selectAfterCreationMenuItem = new JCheckBoxMenuItem(Messages.getString("MMAX2.Select_new_markable_after_creation"));
        selectAfterCreationMenuItem.setSelected(us.isSelectAfterCreation());
        selectAfterCreationMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JCheckBoxMenuItem source = (JCheckBoxMenuItem)ae.getSource();
                us.setSelectAfterCreation(source.isSelected());
            }
        });
        settingsMenu.add(selectAfterCreationMenuItem);
        settingsMenu.addSeparator();
        JCheckBoxMenuItem attributePanelToFrontMenuItem = new JCheckBoxMenuItem(Messages.getString("MMAX2.Bring_attribute_panel_to_front_after_selection"));
        attributePanelToFrontMenuItem.setSelected(us.isAttributePanelToFront());
        attributePanelToFrontMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JCheckBoxMenuItem source = (JCheckBoxMenuItem)ae.getSource();
                us.setAttributePanelToFront(source.isSelected());
            }
        });
        settingsMenu.add(attributePanelToFrontMenuItem);
        JCheckBoxMenuItem autoApplyMenuItem = new JCheckBoxMenuItem(Messages.getString("MMAX2.Auto_apply_changes"));
        autoApplyMenuItem.setSelected(us.isAutoApply());
        autoApplyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JCheckBoxMenuItem source = (JCheckBoxMenuItem)ae.getSource();
                us.setAutoApply(source.isSelected());
            }
        });
        settingsMenu.add(autoApplyMenuItem);
        settingsMenu.addSeparator();
        JMenuItem resetSettingMenuItem = new JMenuItem(Messages.getString("MainMenu.Reset_settings_to_default"));
        resetSettingMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MainMenu.this.resetUserSettings();
            }
        });
        settingsMenu.add(resetSettingMenuItem);
        return settingsMenu;
    }

    protected void resetUserSettings() {
        logger.info("Resetting settings to default.");
        this.mmax.resetUserSettings();
        this.fillSettingsMenu(this.settingsMenu, this.mmax.getUserSettings());
        this.fillDisplayMenu(this.displayMenu, this.mmax.getUserSettings());
    }

    private void fillDisplayMenu(JMenu displayMenu, UserSettings userSettings) {
        displayMenu.removeAll();
        JMenuItem reapplyDisplay = new JMenuItem(Messages.getString("MMAX2.Reapply_current_style_sheet"));
        reapplyDisplay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MainMenu.this.mmax.requestReapplyDisplay();
            }
        });
        reapplyDisplay.setAccelerator(KeyStroke.getKeyStroke("F5"));
        displayMenu.add(reapplyDisplay);
        JMenu fontMenu = new JMenu(Messages.getString("MMAX2.Font"));
        JMenu setFontName = new JMenu(Messages.getString("MMAX2.Name"));
        ButtonGroup fontNameButtonGroup = new ButtonGroup();
        GraphicsEnvironment myEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = myEnv.getAvailableFontFamilyNames();
        int maxMenuSize = 30;
        int fontNum = fontNames.length;
        ArrayList buckets = new ArrayList();
        ArrayList<JRadioButtonMenuItem> currList = new ArrayList<JRadioButtonMenuItem>();
        buckets.add(currList);
        JRadioButtonMenuItem temp = null;
        int z = 0;
        while (z < fontNum) {
            final String string = fontNames[z];
            temp = new JRadioButtonMenuItem(string);
            if (string.equalsIgnoreCase(userSettings.getDisplayFontFamily())) {
                temp.setSelected(true);
            }
            temp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    MainMenu.this.mmax.requestSetFontFamily(string);
                }
            });
            if (currList.size() >= maxMenuSize) {
                currList = new ArrayList();
                buckets.add(currList);
            }
            currList.add(temp);
            fontNameButtonGroup.add(temp);
            temp = null;
            ++z;
        }
        if (buckets.size() == 1) {
            for (JRadioButtonMenuItem item : (List)buckets.get(0)) {
                setFontName.add(item);
            }
        } else {
            int c = 1;
            for (List list : buckets) {
                JMenu tempMenu = new JMenu(String.valueOf(Messages.getString("MMAX2.Group")) + " " + c++);
                for (JRadioButtonMenuItem item : list) {
                    tempMenu.add(item);
                }
                setFontName.add(tempMenu);
            }
        }
        fontMenu.add(setFontName);
        ButtonGroup fontSizeButtonGroup = new ButtonGroup();
        JMenu jMenu = new JMenu(Messages.getString("MMAX2.Size"));
        temp = null;
        int z2 = 8;
        while (z2 < 30) {
            final int currentFontSize = z2;
            temp = new JRadioButtonMenuItem(String.valueOf(z2));
            if (z2 == userSettings.getDisplayFontSize()) {
                temp.setSelected(true);
            }
            temp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    MainMenu.this.mmax.requestSetFontSize(currentFontSize);
                }
            });
            fontSizeButtonGroup.add(temp);
            jMenu.add(temp);
            temp = null;
            z2 += 2;
        }
        fontMenu.add(jMenu);
        ButtonGroup lineSpacingButtonGroup = new ButtonGroup();
        JMenu setLineSpacing = new JMenu(Messages.getString("MMAX2.Line_spacing"));
        temp = null;
        int z3 = 0;
        while (z3 < 15) {
            final float currentLineSpacing = (float)z3 / 10.0f;
            temp = new JRadioButtonMenuItem(String.valueOf((float)z3 / 10.0f));
            if (currentLineSpacing == userSettings.getDisplayLineSpacing()) {
                temp.setSelected(true);
            }
            temp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    MainMenu.this.mmax.requestSetLineSpacing(currentLineSpacing);
                }
            });
            lineSpacingButtonGroup.add(temp);
            setLineSpacing.add(temp);
            temp = null;
            ++z3;
        }
        fontMenu.add(setLineSpacing);
        displayMenu.add(fontMenu);
    }

    public void enableSaveAll(boolean val) {
        this.saveAll.setEnabled(val);
    }

    public void enableUndo(boolean val) {
        this.undo.setEnabled(val);
    }

    public void textLoaded() {
        this.autoSaveMenu.setEnabled(true);
        this.browserMenu.setEnabled(true);
        this.setBrowserItem.setEnabled(true);
        this.pointerBrowserItem.setEnabled(true);
        this.markableBrowserItem.setEnabled(true);
        this.pluginMenu.setEnabled(true);
        this.superannoItem.setEnabled(true);
        this.settingsMenu.setEnabled(true);
        this.displayMenu.setEnabled(true);
    }

    private void fillPluginMenu(JMenu pluginMenu) {
        if (pluginMenu != null) {
            pluginMenu.removeAll();
        }
        this.superannoItem = new JMenuItem("Okno superanotacji");
        this.superannoItem.setEnabled(false);
        this.superannoItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MainMenu.this.mmax.requestSuperannotationWindow();
            }
        });
        pluginMenu.add(this.superannoItem);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.startsWith("auto-save")) {
            String newTime = command.substring(command.indexOf(":") + 1);
            int num = Integer.parseInt(newTime);
            this.mmax.requestSetAutoSaveInterval(num);
        } else {
            logger.error("Unknown command: " + command);
        }
    }
}

