/*
 * Decompiled with CFR 0.152.
 */
package org.eml.MMAX2.discourse;

import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.parsers.DOMParser;
import org.eml.MMAX2.discourse.LocalResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class DiscourseElementFileLoader {
    private static EntityResolver resolver = new LocalResolver();
    protected String deFileName = "";
    protected String type = "";
    protected DocumentImpl deDOM = null;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: DiscourseElementFileLoader [words.xml|gestures.xml|keyactions.xml]");
            System.exit(0);
        }
        DiscourseElementFileLoader defl = new DiscourseElementFileLoader();
        defl.load(args[0]);
    }

    public final void load(String fileName) {
        File file = new File(fileName);
        this.deFileName = file.getAbsolutePath();
        DOMParser parser = new DOMParser();
        this.deDOM = null;
        try {
            parser.setFeature("http://xml.org/sax/features/validation", false);
        }
        catch (SAXNotRecognizedException ex) {
            ex.printStackTrace();
            return;
        }
        catch (SAXNotSupportedException ex) {
            ex.printStackTrace();
            return;
        }
        try {
            parser.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", false);
        }
        catch (SAXNotRecognizedException ex) {
            ex.printStackTrace();
            return;
        }
        catch (SAXNotSupportedException ex) {
            ex.printStackTrace();
            return;
        }
        try {
            parser.setEntityResolver(resolver);
            InputSource is = new InputSource(new File(fileName).toURI().toASCIIString());
            parser.parse(is);
        }
        catch (SAXParseException exception) {
            String error = "Line: " + exception.getLineNumber() + " Column: " + exception.getColumnNumber() + "\n" + exception.toString();
            JOptionPane.showMessageDialog(null, error, "DiscourseElementFileLoader: " + fileName, 0);
            System.exit(0);
        }
        catch (SAXException exception) {
            String error = exception.toString();
            JOptionPane.showMessageDialog(null, error, "DiscourseElementFileLoader: " + fileName, 0);
            System.exit(0);
        }
        catch (IOException exception) {
            String error = exception.toString();
            JOptionPane.showMessageDialog(null, error, "DiscourseElementFileLoader: " + fileName, 0);
            exception.printStackTrace();
            System.exit(0);
        }
        this.deDOM = (DocumentImpl)parser.getDocument();
    }

    public final DocumentImpl getDOM() {
        return this.deDOM;
    }
}

