/*
 * Decompiled with CFR 0.152.
 */
package org.eml.MMAX2.discourse;

import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xpath.NodeSet;
import org.eml.MMAX2.annotation.markables.Markable;
import org.eml.MMAX2.annotation.markables.MarkableFileLoader;
import org.eml.MMAX2.annotation.markables.MarkableLevel;
import org.eml.MMAX2.discourse.DiscourseElementFileLoader;
import org.eml.MMAX2.discourse.LocalResolver;
import org.eml.MMAX2.discourse.MMAX2Discourse;
import org.eml.MMAX2.utils.MMAX2Utils;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class MMAX2DiscourseLoader {
    private static final Logger logger = Logger.getLogger(MMAX2DiscourseLoader.class);
    protected String commonPathsFile = "common_paths.xml";
    protected String commonSchemePath = "";
    protected String commonStylePath = "";
    protected String commonBasedataPath = "";
    protected String commonCustomizationPath = "";
    protected String commonMarkablePath = "";
    protected String commonQueryPath = "";
    protected String rootPath = "";
    protected String wordFileName = "";
    protected String[] markableFileNames;
    protected String[] markableLevelNames;
    private String[] markableLevelLocalizedNames;
    protected String[] schemeFileNames;
    protected String[] customizationFileNames;
    protected String[] startupModes;
    protected int levelCount = 0;
    protected String[] styleSheetFileNames = new String[0];
    protected String[] userSwitches = new String[0];
    private String nameSpace = "";
    protected static MMAX2Discourse currentDiscourse;

    public MMAX2DiscourseLoader(String fileName, boolean withGUI, String suppliedCommonPathsFile) {
        NodeList annotations;
        String error;
        DOMParser parser = new DOMParser();
        DocumentImpl MMAXDOM = null;
        this.rootPath = fileName.substring(0, fileName.lastIndexOf(File.separator) + 1);
        this.commonPathsFile = !suppliedCommonPathsFile.equals("") ? suppliedCommonPathsFile : String.valueOf(this.rootPath) + "common_path.xml";
        String commonRoot = this.rootPath;
        File cp = LocalResolver.findCommonPaths();
        if (cp != null) {
            commonRoot = String.valueOf(cp.getParent()) + File.separator;
            this.commonPathsFile = cp.getPath();
            logger.info("Found common_paths near project, using it: " + this.commonPathsFile);
        }
        this.commonSchemePath = commonRoot;
        this.commonStylePath = commonRoot;
        this.commonCustomizationPath = commonRoot;
        this.commonMarkablePath = this.rootPath;
        this.commonQueryPath = this.rootPath;
        this.commonBasedataPath = this.rootPath;
        try {
            parser.setFeature("http://xml.org/sax/features/validation", false);
        }
        catch (SAXNotRecognizedException ex) {
            ex.printStackTrace();
            return;
        }
        catch (SAXNotSupportedException ex) {
            ex.printStackTrace();
            return;
        }
        try {
            parser.parse(new InputSource(new File(fileName).toURI().toASCIIString()));
        }
        catch (SAXParseException exception) {
            error = "Line: " + exception.getLineNumber() + " Column: " + exception.getColumnNumber() + "\n" + exception.toString();
            JOptionPane.showMessageDialog(null, error, "DiscourseLoader: " + fileName, 0);
        }
        catch (SAXException exception) {
            error = exception.toString();
            JOptionPane.showMessageDialog(null, error, "DiscourseLoader: " + fileName, 0);
        }
        catch (IOException exception) {
            error = exception.toString();
            JOptionPane.showMessageDialog(null, error, "DiscourseLoader: " + fileName, 0);
        }
        MMAXDOM = (DocumentImpl)parser.getDocument();
        try {
            parser.parse(new InputSource(new File(this.commonPathsFile).toURI().toASCIIString()));
        }
        catch (SAXParseException exception) {
            error = "Line: " + exception.getLineNumber() + " Column: " + exception.getColumnNumber() + "\n" + exception.toString();
            JOptionPane.showMessageDialog(null, error, "DiscourseLoader: " + fileName, 0);
        }
        catch (SAXException exception) {
            error = exception.toString();
            JOptionPane.showMessageDialog(null, error, "DiscourseLoader: " + fileName, 0);
        }
        catch (FileNotFoundException exception) {
            error = exception.toString();
            JOptionPane.showMessageDialog(null, error, "DiscourseLoader: " + fileName, 0);
            return;
        }
        catch (IOException exception) {
            error = exception.toString();
            JOptionPane.showMessageDialog(null, error, "DiscourseLoader: " + fileName, 0);
        }
        if (parser.getDocument() != null) {
            NodeList temp;
            int z;
            NodeList views;
            DocumentImpl CPFDOM = null;
            CPFDOM = (DocumentImpl)parser.getDocument();
            NodeList currentCommonPathNodeList = null;
            currentCommonPathNodeList = CPFDOM.getElementsByTagName("scheme_path");
            if (currentCommonPathNodeList.getLength() != 0) {
                String tempSchemePath = "";
                try {
                    tempSchemePath = this.toPlatformdependentPath(currentCommonPathNodeList.item(0).getFirstChild().getNodeValue());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                this.commonSchemePath = new File(tempSchemePath).isAbsolute() ? tempSchemePath : String.valueOf(this.commonSchemePath) + tempSchemePath;
            }
            currentCommonPathNodeList = null;
            currentCommonPathNodeList = CPFDOM.getElementsByTagName("style_path");
            if (currentCommonPathNodeList.getLength() != 0) {
                String tempStylePath = "";
                try {
                    tempStylePath = this.toPlatformdependentPath(currentCommonPathNodeList.item(0).getFirstChild().getNodeValue());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                this.commonStylePath = new File(tempStylePath).isAbsolute() ? tempStylePath : String.valueOf(this.commonStylePath) + tempStylePath;
            }
            currentCommonPathNodeList = null;
            currentCommonPathNodeList = CPFDOM.getElementsByTagName("basedata_path");
            if (currentCommonPathNodeList.getLength() != 0) {
                String tempBasedataPath = "";
                try {
                    tempBasedataPath = this.toPlatformdependentPath(currentCommonPathNodeList.item(0).getFirstChild().getNodeValue());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                this.commonBasedataPath = new File(tempBasedataPath).isAbsolute() ? tempBasedataPath : String.valueOf(this.commonBasedataPath) + tempBasedataPath;
            }
            currentCommonPathNodeList = null;
            currentCommonPathNodeList = CPFDOM.getElementsByTagName("customization_path");
            if (currentCommonPathNodeList.getLength() != 0) {
                String tempCustomizationPath = "";
                try {
                    tempCustomizationPath = this.toPlatformdependentPath(currentCommonPathNodeList.item(0).getFirstChild().getNodeValue());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                this.commonCustomizationPath = new File(tempCustomizationPath).isAbsolute() ? tempCustomizationPath : String.valueOf(this.commonCustomizationPath) + tempCustomizationPath;
            }
            currentCommonPathNodeList = null;
            currentCommonPathNodeList = CPFDOM.getElementsByTagName("markable_path");
            if (currentCommonPathNodeList.getLength() != 0) {
                String tempMarkablePath = "";
                try {
                    tempMarkablePath = this.toPlatformdependentPath(currentCommonPathNodeList.item(0).getFirstChild().getNodeValue());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                this.commonMarkablePath = new File(tempMarkablePath).isAbsolute() ? tempMarkablePath : String.valueOf(this.commonMarkablePath) + tempMarkablePath;
            }
            currentCommonPathNodeList = null;
            currentCommonPathNodeList = CPFDOM.getElementsByTagName("query_path");
            if (currentCommonPathNodeList.getLength() != 0) {
                String tempQueryPath = "";
                try {
                    tempQueryPath = this.toPlatformdependentPath(currentCommonPathNodeList.item(0).getFirstChild().getNodeValue());
                }
                catch (NullPointerException ex) {
                    ex.printStackTrace();
                }
                this.commonQueryPath = new File(tempQueryPath).isAbsolute() ? tempQueryPath : String.valueOf(this.commonQueryPath) + tempQueryPath;
            }
            currentCommonPathNodeList = null;
            currentCommonPathNodeList = CPFDOM.getElementsByTagName("views");
            if (currentCommonPathNodeList.getLength() != 0 && (views = CPFDOM.getElementsByTagName("stylesheet")).getLength() != 0) {
                int viewCount = views.getLength();
                this.styleSheetFileNames = new String[viewCount];
                z = 0;
                while (z < viewCount) {
                    try {
                        this.styleSheetFileNames[z] = String.valueOf(this.commonStylePath) + views.item(z).getFirstChild().getNodeValue();
                    }
                    catch (NullPointerException ex) {
                        JOptionPane.showMessageDialog(null, "Empty <stylesheet> entry in .mmax file!", "DiscourseLoader: " + fileName, 0);
                    }
                    ++z;
                }
            }
            if ((currentCommonPathNodeList = CPFDOM.getElementsByTagName("user_switches")).getLength() != 0) {
                NodeList switches = CPFDOM.getElementsByTagName("user_switch");
                this.userSwitches = new String[switches.getLength()];
                int z2 = 0;
                while (z2 < switches.getLength()) {
                    block79: {
                        String name = "";
                        String desc = "";
                        String def = "";
                        try {
                            name = switches.item(z2).getAttributes().getNamedItem("name").getNodeValue();
                        }
                        catch (NullPointerException ex) {
                            System.err.println("User switch with empty 'name' attribute, ignored!");
                            break block79;
                        }
                        try {
                            desc = switches.item(z2).getAttributes().getNamedItem("description").getNodeValue();
                        }
                        catch (NullPointerException ex) {
                            desc = " ";
                        }
                        try {
                            def = switches.item(z2).getAttributes().getNamedItem("default").getNodeValue();
                        }
                        catch (NullPointerException ex) {
                            def = "off";
                        }
                        this.userSwitches[z2] = String.valueOf(name) + ":::" + desc + ":::" + def;
                    }
                    ++z2;
                }
            }
            if ((temp = CPFDOM.getElementsByTagName("annotations")).getLength() != 0) {
                this.nameSpace = fileName.substring(fileName.lastIndexOf(File.separator) + 1);
                this.nameSpace = this.nameSpace.substring(0, this.nameSpace.indexOf(".mmax"));
                NodeList annotations2 = CPFDOM.getElementsByTagName("level");
                if (annotations2.getLength() != 0) {
                    this.levelCount = annotations2.getLength();
                    this.markableFileNames = new String[this.levelCount];
                    this.markableLevelNames = new String[this.levelCount];
                    this.markableLevelLocalizedNames = new String[this.levelCount];
                    this.schemeFileNames = new String[this.levelCount];
                    this.customizationFileNames = new String[this.levelCount];
                    z = 0;
                    while (z < this.levelCount) {
                        String tempMarkablePath = "";
                        try {
                            tempMarkablePath = annotations2.item(z).getFirstChild().getNodeValue();
                            this.markableFileNames[z] = new File(tempMarkablePath).isAbsolute() ? tempMarkablePath : String.valueOf(this.commonMarkablePath) + tempMarkablePath;
                            this.markableFileNames[z] = this.markableFileNames[z].replaceAll("\\$", this.nameSpace);
                        }
                        catch (NullPointerException ex) {
                            JOptionPane.showMessageDialog(null, "Empty <level> entry in common paths file " + this.commonPathsFile + "!", "DiscourseLoader: " + fileName, 0);
                            System.exit(0);
                        }
                        try {
                            this.markableLevelNames[z] = annotations2.item(z).getAttributes().getNamedItem("name").getNodeValue();
                        }
                        catch (NullPointerException ex) {
                            JOptionPane.showMessageDialog(null, "Missing 'name' attribute for level " + this.markableFileNames[z], "DiscourseLoader: " + fileName, 0);
                            System.exit(0);
                        }
                        try {
                            this.markableLevelLocalizedNames[z] = annotations2.item(z).getAttributes().getNamedItem("localized_name").getNodeValue();
                        }
                        catch (NullPointerException ex) {
                            JOptionPane.showMessageDialog(null, "Missing 'localized_name' attribute for level " + this.markableFileNames[z], "DiscourseLoader: " + fileName, 0);
                            System.exit(0);
                        }
                        try {
                            this.schemeFileNames[z] = String.valueOf(this.commonSchemePath) + annotations2.item(z).getAttributes().getNamedItem("schemefile").getNodeValue();
                        }
                        catch (NullPointerException ex) {
                            JOptionPane.showMessageDialog(null, "Missing 'schemefile' attribute for level " + this.markableFileNames[z], "DiscourseLoader: " + fileName, 0);
                            System.exit(0);
                        }
                        try {
                            this.customizationFileNames[z] = String.valueOf(this.commonCustomizationPath) + annotations2.item(z).getAttributes().getNamedItem("customization_file").getNodeValue();
                        }
                        catch (NullPointerException ex) {
                            this.customizationFileNames[z] = "";
                        }
                        ++z;
                    }
                }
            }
        }
        NodeList temp = null;
        temp = MMAXDOM.getElementsByTagName("root_path");
        if (temp.getLength() != 0) {
            System.err.println("Found deprecated <root_path> tag, ignored!");
        }
        if ((temp = MMAXDOM.getElementsByTagName("words")).getLength() != 0) {
            try {
                this.wordFileName = String.valueOf(this.commonBasedataPath) + temp.item(0).getFirstChild().getNodeValue();
            }
            catch (NullPointerException ex) {
                ex.printStackTrace();
            }
        }
        if (this.nameSpace.equals("") && (temp = MMAXDOM.getElementsByTagName("annotations")).getLength() != 0 && (annotations = MMAXDOM.getElementsByTagName("level")).getLength() != 0) {
            this.levelCount = annotations.getLength();
            this.markableFileNames = new String[this.levelCount];
            this.markableLevelNames = new String[this.levelCount];
            this.markableLevelLocalizedNames = new String[this.levelCount];
            this.schemeFileNames = new String[this.levelCount];
            this.customizationFileNames = new String[this.levelCount];
            int z = 0;
            while (z < this.levelCount) {
                try {
                    this.markableFileNames[z] = String.valueOf(this.commonMarkablePath) + annotations.item(z).getFirstChild().getNodeValue();
                }
                catch (NullPointerException ex) {
                    JOptionPane.showMessageDialog(null, "Empty <level> entry in .mmax file!", "DiscourseLoader: " + fileName, 0);
                    System.exit(0);
                }
                try {
                    this.markableLevelNames[z] = annotations.item(z).getAttributes().getNamedItem("name").getNodeValue();
                }
                catch (NullPointerException ex) {
                    JOptionPane.showMessageDialog(null, "Missing 'name' attribute for level " + this.markableFileNames[z], "DiscourseLoader: " + fileName, 0);
                    System.exit(0);
                }
                try {
                    this.markableLevelLocalizedNames[z] = annotations.item(z).getAttributes().getNamedItem("localized_name").getNodeValue();
                }
                catch (NullPointerException ex) {
                    JOptionPane.showMessageDialog(null, "Missing 'localized_name' attribute for level " + this.markableFileNames[z], "DiscourseLoader: " + fileName, 0);
                    System.exit(0);
                }
                try {
                    this.schemeFileNames[z] = String.valueOf(this.commonSchemePath) + annotations.item(z).getAttributes().getNamedItem("schemefile").getNodeValue();
                }
                catch (NullPointerException ex) {
                    JOptionPane.showMessageDialog(null, "Missing 'schemefile' attribute for level " + this.markableFileNames[z], "DiscourseLoader: " + fileName, 0);
                    System.exit(0);
                }
                try {
                    this.customizationFileNames[z] = String.valueOf(this.commonCustomizationPath) + annotations.item(z).getAttributes().getNamedItem("customization_file").getNodeValue();
                }
                catch (NullPointerException ex) {
                    this.customizationFileNames[z] = "";
                }
                ++z;
            }
        }
        currentDiscourse = new MMAX2Discourse();
        currentDiscourse.setCommonBasedataPath(this.commonBasedataPath);
        currentDiscourse.setCurrentStyleSheet(this.styleSheetFileNames[0]);
        currentDiscourse.setNameSpace(this.nameSpace);
        DiscourseElementFileLoader deloader = new DiscourseElementFileLoader();
        if (!new File(this.wordFileName).exists()) {
            String defaultWordFileName = String.valueOf(this.commonBasedataPath) + this.nameSpace + "_words.xml";
            if (new File(defaultWordFileName).exists()) {
                logger.info("Using default word file name");
                this.wordFileName = defaultWordFileName;
            } else {
                logger.error("No word file name given!");
                JOptionPane.showMessageDialog(null, "Words file doesn't exist, \nneither given in mmax file (" + this.wordFileName + ") \nnor the default one (" + defaultWordFileName + ")!", "DiscourseLoader", 0);
                System.exit(0);
            }
        }
        deloader.load(this.wordFileName);
        currentDiscourse.setWordDOM(deloader.getDOM());
        currentDiscourse.setWordFileName(this.wordFileName);
        if (this.styleSheetFileNames.length == 0) {
            JOptionPane.showMessageDialog(null, "You must specify at least one XSL style sheet file!", "DiscourseLoader: " + fileName, 0);
            System.exit(0);
        } else {
            currentDiscourse.setStyleSheetFileNames(this.styleSheetFileNames);
        }
        MarkableFileLoader mfl = new MarkableFileLoader();
        boolean currentMaxID = false;
        boolean totalMaxID = false;
        int p = 0;
        while (p < this.levelCount) {
            logger.debug("Loading level " + this.markableLevelNames[p] + " ... ");
            mfl.load(this.markableFileNames[p], this.markableLevelNames[p], this.schemeFileNames[p], this.customizationFileNames[p], this.markableLevelLocalizedNames[p]);
            MarkableLevel newLevel = mfl.getMarkableLevel();
            newLevel.setCurrentDiscourse(currentDiscourse);
            newLevel.createMarkables();
            currentDiscourse.getCurrentMarkableChart().addMarkableLevel(newLevel);
            ++p;
        }
    }

    private final String toPlatformdependentPath(String inPath) {
        String result = "";
        result = File.separator.equals("/") ? inPath.replace('\\', '/') : inPath.replace('/', '\\');
        return result;
    }

    public final String getCommonQueryPath() {
        return this.commonQueryPath;
    }

    public final String[] getUserSwitches() {
        return this.userSwitches;
    }

    public final String getWorkingDirectory() {
        return this.rootPath;
    }

    public final MMAX2Discourse getCurrentDiscourse() {
        return currentDiscourse;
    }

    public static String addHotSpot(String toDisplay, String hotSpotText) {
        int extent = toDisplay.length();
        int currentDocumentPosition = currentDiscourse.getCurrentDocumentPosition();
        int temp = 0;
        while (temp < extent) {
            MMAX2DiscourseLoader.currentDiscourse.hotSpotDisplayAssociation.put(new Integer(currentDocumentPosition + temp), hotSpotText);
            ++temp;
        }
        return toDisplay;
    }

    public static String concat(String string1, String string2) {
        return String.valueOf(string1) + " " + string2;
    }

    public static String concat(String string1, String string2, String string3) {
        return String.valueOf(string1) + " " + string2 + " " + string3;
    }

    public static String concat(String string1, String string2, String string3, String string4) {
        return String.valueOf(string1) + " " + string2 + " " + string3 + " " + string4;
    }

    public static String concat(String string1, String string2, String string3, String string4, String string5) {
        return String.valueOf(string1) + " " + string2 + " " + string3 + " " + string4 + " " + string5;
    }

    public static void addLeftMarkableHandle(String layerName, String markableId, int extent) {
        Markable currentMarkable = currentDiscourse.getCurrentMarkableChart().getMarkableLevelByName(layerName, true).getMarkableByID(markableId);
        int currentDocumentPosition = currentDiscourse.getCurrentDocumentPosition();
        currentMarkable.addLeftHandlePosition(currentDocumentPosition);
        int temp = 0;
        while (temp < extent) {
            MMAX2DiscourseLoader.currentDiscourse.markableDisplayAssociation.put(new Integer(currentDocumentPosition + temp), currentMarkable);
            ++temp;
        }
    }

    public static void addRightMarkableHandle(String layerName, String markableId, int extent) {
        Markable currentMarkable = currentDiscourse.getCurrentMarkableChart().getMarkableLevelByName(layerName, true).getMarkableByID(markableId);
        int currentDocumentPosition = currentDiscourse.getCurrentDocumentPosition();
        currentMarkable.addRightHandlePosition(currentDocumentPosition + extent - 1);
        int temp = 0;
        while (temp < extent) {
            MMAX2DiscourseLoader.currentDiscourse.markableDisplayAssociation.put(new Integer(currentDocumentPosition + temp), currentMarkable);
            ++temp;
        }
    }

    public static String addLeftMarkableHandle(String layerName, String markableId, String handleText, int highlightPos) {
        Markable currentMarkable = currentDiscourse.getCurrentMarkableChart().getMarkableLevelByName(layerName, true).getMarkableByID(markableId);
        int currentDocumentPosition = currentDiscourse.getCurrentDocumentPosition();
        if (highlightPos == 1) {
            currentMarkable.addLeftHandlePosition(currentDocumentPosition);
        } else {
            currentMarkable.addLeftHandlePosition(currentDocumentPosition + highlightPos - 1);
        }
        int extent = handleText.length();
        int temp = 0;
        while (temp < extent) {
            MMAX2DiscourseLoader.currentDiscourse.markableDisplayAssociation.put(new Integer(currentDocumentPosition + temp), currentMarkable);
            ++temp;
        }
        return handleText;
    }

    public static String addLeftMarkableHandle(String layerName, String markableId, String handleText) {
        Markable currentMarkable = currentDiscourse.getCurrentMarkableChart().getMarkableLevelByName(layerName, true).getMarkableByID(markableId);
        int currentDocumentPosition = currentDiscourse.getCurrentDocumentPosition();
        currentMarkable.addLeftHandlePosition(currentDocumentPosition);
        int extent = handleText.length();
        int temp = 0;
        while (temp < extent) {
            MMAX2DiscourseLoader.currentDiscourse.markableDisplayAssociation.put(new Integer(currentDocumentPosition + temp), currentMarkable);
            ++temp;
        }
        return handleText;
    }

    public static String addRightMarkableHandle(String layerName, String markableId, String handleText, int highlightPos) {
        Markable currentMarkable = currentDiscourse.getCurrentMarkableChart().getMarkableLevelByName(layerName, true).getMarkableByID(markableId);
        int extent = handleText.length();
        int currentDocumentPosition = currentDiscourse.getCurrentDocumentPosition();
        if (highlightPos == extent) {
            currentMarkable.addRightHandlePosition(currentDocumentPosition + extent - 1);
        } else {
            currentMarkable.addRightHandlePosition(currentDocumentPosition + extent - 1 - (extent - highlightPos));
        }
        int temp = 0;
        while (temp < extent) {
            MMAX2DiscourseLoader.currentDiscourse.markableDisplayAssociation.put(new Integer(currentDocumentPosition + temp), currentMarkable);
            ++temp;
        }
        return handleText;
    }

    public static String addRightMarkableHandle(String layerName, String markableId, String handleText) {
        Markable currentMarkable = currentDiscourse.getCurrentMarkableChart().getMarkableLevelByName(layerName, true).getMarkableByID(markableId);
        int extent = handleText.length();
        int currentDocumentPosition = currentDiscourse.getCurrentDocumentPosition();
        currentMarkable.addRightHandlePosition(currentDocumentPosition + extent - 1);
        int temp = 0;
        while (temp < extent) {
            MMAX2DiscourseLoader.currentDiscourse.markableDisplayAssociation.put(new Integer(currentDocumentPosition + temp), currentMarkable);
            ++temp;
        }
        return handleText;
    }

    public static void addLeftMarkableHandle(String layerName, String markableId, int extent, int leftHandle) {
        Markable currentMarkable = currentDiscourse.getCurrentMarkableChart().getMarkableLevelByName(layerName, true).getMarkableByID(markableId);
        int currentDocumentPosition = currentDiscourse.getCurrentDocumentPosition();
        currentMarkable.addLeftHandlePosition(currentDocumentPosition + leftHandle - 1);
        int temp = 0;
        while (temp < extent) {
            MMAX2DiscourseLoader.currentDiscourse.markableDisplayAssociation.put(new Integer(currentDocumentPosition + temp), currentMarkable);
            ++temp;
        }
    }

    public static void addRightMarkableHandle(String layerName, String markableId, int extent, int rightHandle) {
        Markable currentMarkable = currentDiscourse.getCurrentMarkableChart().getMarkableLevelByName(layerName, true).getMarkableByID(markableId);
        int currentDocumentPosition = currentDiscourse.getCurrentDocumentPosition();
        currentMarkable.addRightHandlePosition(currentDocumentPosition + rightHandle - 1);
        int temp = 0;
        while (temp < extent) {
            MMAX2DiscourseLoader.currentDiscourse.markableDisplayAssociation.put(new Integer(currentDocumentPosition + temp), currentMarkable);
            ++temp;
        }
    }

    public static void registerDiscourseElement(String id) {
        currentDiscourse.registerDiscourseElement(id);
    }

    public static void setDiscourseElementStart() {
        try {
            int start = currentDiscourse.getCurrentDocumentPosition();
            MMAX2DiscourseLoader.currentDiscourse.temporaryDisplayStartPosition.add(new Integer(start));
            currentDiscourse.getDisplayDocument().setDefaultColor();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        currentDiscourse.getDisplayDocument().flush();
    }

    public static void setDiscourseElementEnd() {
        try {
            int end = currentDiscourse.getCurrentDocumentPosition() - 1;
            MMAX2DiscourseLoader.currentDiscourse.temporaryDisplayEndPosition.add(new Integer(end));
            currentDiscourse.getDisplayDocument().flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void startItalic() {
        currentDiscourse.getDisplayDocument().setItalic(true);
    }

    public static void endItalic() {
        currentDiscourse.getDisplayDocument().setItalic(false);
    }

    public static void startBold() {
        currentDiscourse.getDisplayDocument().setBold(true);
    }

    public static void endBold() {
        currentDiscourse.getDisplayDocument().setBold(false);
    }

    public static void startUnderline() {
        currentDiscourse.getDisplayDocument().setUnderline(true);
    }

    public static void endUnderline() {
        currentDiscourse.getDisplayDocument().setUnderline(false);
    }

    public static void startSubscript() {
        currentDiscourse.getDisplayDocument().setSubscript(true);
    }

    public static void endSubscript() {
        currentDiscourse.getDisplayDocument().setSubscript(false);
    }

    public static void startStrikeThrough() {
        currentDiscourse.getDisplayDocument().setStrikeThrough(true);
    }

    public static void endStrikeThrough() {
        currentDiscourse.getDisplayDocument().setStrikeThrough(false);
    }

    public static void startSuperscript() {
        currentDiscourse.getDisplayDocument().setSuperscript(true);
    }

    public static void endSuperscript() {
        currentDiscourse.getDisplayDocument().setSuperscript(false);
    }

    public static void startColor(String colorName) {
        Color color = MMAX2Utils.getColorByName(colorName);
        if (color == null) {
            color = Color.black;
        }
        currentDiscourse.getDisplayDocument().setColor(color, true);
    }

    public static void endColor(String colorName) {
        Color color = MMAX2Utils.getColorByName(colorName);
        if (color == null) {
            color = Color.black;
        }
        currentDiscourse.getDisplayDocument().setColor(color, false);
    }

    public static void startAssociatedColor(String levelname) {
        Color color = currentDiscourse.getCurrentMarkableChart().getForegroundColorForLevel(levelname);
        if (color == null) {
            color = Color.black;
        }
        currentDiscourse.getDisplayDocument().setColor(color, true);
    }

    public static void endAssociatedColor(String levelname) {
        Color color = currentDiscourse.getCurrentMarkableChart().getForegroundColorForLevel(levelname);
        if (color == null) {
            color = Color.black;
        }
        currentDiscourse.getDisplayDocument().setColor(color, false);
    }

    public static final String getFromHash(String key) {
        return currentDiscourse.getFromHash(key);
    }

    public static final void putInHash(String key, String value) {
        currentDiscourse.putInHash(key, value);
    }

    public static final boolean inMarkableFromLevel(String DE_ID, String targetLevelName) {
        return currentDiscourse.getCurrentMarkableChart().inMarkableFromLevel(DE_ID, targetLevelName);
    }

    public static final boolean inMarkableFromLevel(String markableID, String ownLevelName, String targetLevelName) {
        return currentDiscourse.getCurrentMarkableChart().inMarkableFromLevel(markableID, ownLevelName, targetLevelName);
    }

    public static final boolean startsMarkableFromLevel(String markableID, String ownLevelName, String targetLevelName) {
        return currentDiscourse.getCurrentMarkableChart().startsMarkableFromLevel(markableID, ownLevelName, targetLevelName);
    }

    public static final boolean finishesMarkableFromLevel(String markableID, String ownLevelName, String targetLevelName) {
        return currentDiscourse.getCurrentMarkableChart().finishesMarkableFromLevel(markableID, ownLevelName, targetLevelName);
    }

    public final String getCommonStylePath() {
        return this.commonStylePath;
    }

    public static void flushDocument() {
        currentDiscourse.getDisplayDocument().flush();
        currentDiscourse.getCurrentDocumentPosition();
    }

    public static final NodeList getStartedMarkables(String discourseElementId) {
        return currentDiscourse.getCurrentMarkableChart().getActiveStartedMarkables(discourseElementId);
    }

    public static final NodeList getStartedMarkables(String discourseElementId, String levels) {
        return currentDiscourse.getCurrentMarkableChart().getActiveStartedMarkables(discourseElementId, levels);
    }

    public static final NodeSet getEndedMarkables(String discourseElementId) {
        return currentDiscourse.getCurrentMarkableChart().getActiveEndedMarkables(discourseElementId);
    }

    public static final NodeSet getEndedMarkables(String discourseElementId, String levels) {
        return currentDiscourse.getCurrentMarkableChart().getActiveEndedMarkables(discourseElementId, levels);
    }
}

