/*
 * Decompiled with CFR 0.152.
 */
package org.eml.MMAX2.gui.display;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import org.eml.MMAX2.core.MMAX2;
import org.eml.MMAX2.gui.display.MMAX2Caret;
import org.eml.MMAX2.utils.MMAX2Constants;

public class MMAX2MouseListener
extends MouseAdapter {
    private MMAX2 mmax2 = null;

    @Override
    public void mousePressed(MouseEvent me) {
        if (this.mmax2 != null) {
            this.evaluateMouseClick(me, MMAX2Constants.MOUSE_PRESSED);
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        if (this.mmax2 != null) {
            this.evaluateMouseClick(me, MMAX2Constants.MOUSE_RELEASED);
        }
    }

    @Override
    public void mouseExited(MouseEvent me) {
        if (this.mmax2 != null) {
            this.mmax2.getCurrentTextPane().deactivateMarkableHandleHighlight(true);
            this.mmax2.getCurrentTextPane().setMouseInPane(false);
        }
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        if (this.mmax2 != null) {
            this.mmax2.getCurrentTextPane().setMouseInPane(true);
        }
    }

    public void evaluateMouseClick(MouseEvent me, int mode) {
        if (this.mmax2.getBlockAllInput()) {
            return;
        }
        if (this.mmax2.getCurrentTextPane().getIsDraggingGoingOn()) {
            this.mmax2.getCurrentTextPane().setIsDraggingGoingOn(false);
            return;
        }
        int currentModifier = me.getModifiers();
        if ((currentModifier & 4) == 4 || me.isPopupTrigger()) {
            this.mmax2.getCurrentTextPane().getCurrentCaretListener().setMouseButton(MMAX2Constants.RIGHTMOUSE);
        } else if ((currentModifier & 0x10) == 16) {
            this.mmax2.getCurrentTextPane().getCurrentCaretListener().setMouseButton(MMAX2Constants.LEFTMOUSE);
        }
        this.mmax2.getCurrentTextPane().getCurrentCaretListener().setUpdateMode(mode);
        ((MMAX2Caret)this.mmax2.getCurrentTextPane().getCaret()).positionCaret(me);
    }

    protected void setMMAX2(MMAX2 _mmax2) {
        this.mmax2 = _mmax2;
    }
}

