/*
 * Decompiled with CFR 0.152.
 */
package org.eml.MMAX2.gui.display;

import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JTextPane;
import javax.swing.Timer;
import org.eml.MMAX2.annotation.markables.Markable;
import org.eml.MMAX2.core.MMAX2;
import org.eml.MMAX2.gui.display.MMAX2Caret;
import org.eml.MMAX2.gui.display.MMAX2CaretListener;
import org.eml.MMAX2.gui.display.MMAX2MouseListener;
import org.eml.MMAX2.gui.display.MMAX2MouseMotionListener;
import org.eml.MMAX2.utils.MMAX2Constants;

public class MMAX2TextPane
extends JTextPane
implements AdjustmentListener {
    private static final long serialVersionUID = 2499213247009650661L;
    private boolean isDraggingGoingOn = false;
    private boolean mouseInPane = true;
    private Timer refreshControlTimer = null;
    private final int TIME_TO_REFRESH_AFTER_LAST_SCROLLING = 1000;
    private Timer refreshTimer = null;
    private final int TIME_BETWEEN_REFRESHES = 10;
    private Timer activateHoveringLatencyTimer = null;
    private final int HOVERING_LATENCY_TIME = 100;
    private MMAX2CaretListener currentCaretListener = null;
    private MMAX2MouseListener currentMouseListener = new MMAX2MouseListener();
    private MMAX2MouseMotionListener currentMouseMotionListener = null;
    private MMAX2 mmax2 = null;
    private MouseEvent currentMouseMoveEvent = null;
    private Markable currentHoveree = null;
    private boolean showHandlesOfCurrentFragmentOnly = false;
    private boolean showFloatingAttributeWindow = false;
    private int currentDot = 0;
    private JPopupMenu floatingAttributeWindow = null;
    private JPopupMenu markableSetPeerWindow = null;

    public MMAX2TextPane() {
        this.addMouseListener(this.currentMouseListener);
        this.currentMouseMotionListener = new MMAX2MouseMotionListener();
        this.addMouseMotionListener(this.currentMouseMotionListener);
        this.currentCaretListener = new MMAX2CaretListener();
        this.addCaretListener(this.currentCaretListener);
        this.setCaret(new MMAX2Caret());
        this.setEditable(false);
        this.setDoubleBuffered(true);
        this.refreshControlTimer = new Timer(0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MMAX2TextPane.this.stopAutoRefresh();
            }
        });
        this.refreshControlTimer.setCoalesce(true);
        this.refreshControlTimer.setRepeats(false);
        this.refreshControlTimer.setInitialDelay(1000);
        this.refreshTimer = new Timer(10, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    MMAX2TextPane.this.mmax2.redraw(null);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
        this.refreshTimer.setCoalesce(true);
        this.refreshTimer.setInitialDelay(0);
        this.refreshTimer.setRepeats(true);
        this.activateHoveringLatencyTimer = new Timer(0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MMAX2TextPane.this.startHovering();
            }
        });
        this.activateHoveringLatencyTimer.setInitialDelay(100);
    }

    public final void setIsDraggingGoingOn(boolean status) {
        this.isDraggingGoingOn = status;
    }

    public final boolean getIsDraggingGoingOn() {
        return this.isDraggingGoingOn;
    }

    public final void setMouseInPane(boolean in) {
        this.mouseInPane = in;
    }

    protected final MMAX2CaretListener getCurrentCaretListener() {
        return this.currentCaretListener;
    }

    protected final void setCurrentMouseMoveEvent(MouseEvent _me) {
        this.currentMouseMoveEvent = _me;
    }

    public final MouseEvent getCurrentMouseMoveEvent() {
        return this.currentMouseMoveEvent;
    }

    public final void setMMAX2(MMAX2 _mmax2) {
        this.mmax2 = _mmax2;
        this.currentCaretListener.setMMAX2(_mmax2);
        this.currentMouseListener.setMMAX2(_mmax2);
        this.currentMouseMotionListener.setMMAX2(_mmax2);
    }

    public final void deactivateFloatingAttributeWindow() {
        if (this.floatingAttributeWindow != null) {
            this.floatingAttributeWindow.setVisible(false);
            this.mmax2.redraw(null);
        }
        this.floatingAttributeWindow = null;
    }

    protected final void activateFloatingAttributeWindow() {
        this.floatingAttributeWindow = new JPopupMenu();
        this.floatingAttributeWindow.setEnabled(false);
        JMenuItem item = null;
        if (this.currentHoveree != null && this.showFloatingAttributeWindow) {
            Markable markable = this.getCurrentHoveree();
            item = new JMenuItem("ID : " + markable.getID());
            this.floatingAttributeWindow.add(item);
            item = null;
            this.floatingAttributeWindow.addSeparator();
            Map<String, String> atts = markable.getAttributes();
            for (Map.Entry<String, String> e : atts.entrySet()) {
                String att = e.getKey();
                String val = e.getValue();
                item = new JMenuItem(String.valueOf(att) + " : " + val);
                this.floatingAttributeWindow.add(item);
                item = null;
            }
            this.floatingAttributeWindow.show(this, this.currentMouseMoveEvent.getX(), this.currentMouseMoveEvent.getY());
        }
    }

    public final Markable getCurrentHoveree() {
        return this.currentHoveree;
    }

    public final int getCurrentDot() {
        return this.currentDot;
    }

    public final void setCurrentHoveree(Markable _hoveree, int _currentDot) {
        this.currentDot = _currentDot;
        if (_hoveree == null) {
            if (this.currentHoveree == null) {
                return;
            }
            this.deactivateMarkableHandleHighlight(false);
            this.deactivateMarkableSetPeerWindow();
            this.currentHoveree = null;
            this.deactivateMarkableSetPeerWindow();
        } else {
            this.currentHoveree = _hoveree;
            this.activateMarkableHandleHighlight();
            this.activateFloatingAttributeWindow();
        }
    }

    private final void deactivateMarkableSetPeerWindow() {
        if (this.markableSetPeerWindow != null) {
            this.markableSetPeerWindow.setVisible(false);
            this.markableSetPeerWindow = null;
        }
    }

    private final void activateMarkableHandleHighlight() {
        if (this.mmax2.isHighlightMatchingHandles() && this.mouseInPane && (!this.mmax2.getIsRendering() || !this.mmax2.getUserSettings().isSuppressHandlesWhenRendering())) {
            if (this.showHandlesOfCurrentFragmentOnly) {
                this.currentHoveree.renderMe(MMAX2Constants.RENDER_CURRENT_HANDLE);
            } else {
                this.currentHoveree.renderMe(MMAX2Constants.RENDER_ALL_HANDLES);
            }
        }
    }

    public final void deactivateMarkableHandleHighlight(boolean force) {
        if (this.mmax2.isHighlightMatchingHandles() && (!this.mmax2.getIsRendering() || force || !this.mmax2.getUserSettings().isSuppressHandlesWhenRendering()) && this.currentHoveree != null) {
            this.currentHoveree.renderMe(MMAX2Constants.RENDER_NO_HANDLES);
            this.mmax2.redraw(null);
        }
    }

    private final void startHovering() {
        this.currentCaretListener.setUpdateMode(MMAX2Constants.MOUSE_HOVERED);
        ((MMAX2Caret)this.getCaret()).positionCaret(this.currentMouseMoveEvent);
        this.activateHoveringLatencyTimer.stop();
    }

    protected final Timer getHoveringLatencyTimer() {
        return this.activateHoveringLatencyTimer;
    }

    public final void setShowFloatingAttributeWindow(boolean status) {
        this.showFloatingAttributeWindow = status;
    }

    public final void setShowHandlesOfCurrentFragmentOnly(boolean status) {
        this.showHandlesOfCurrentFragmentOnly = status;
    }

    public final void startAutoRefresh() {
        if (this.refreshTimer.isRunning()) {
            this.refreshTimer.restart();
        } else {
            this.refreshTimer.start();
        }
        if (this.refreshControlTimer.isRunning()) {
            this.refreshControlTimer.restart();
        } else {
            this.refreshControlTimer.start();
        }
    }

    public final void stopAutoRefresh() {
        this.refreshTimer.stop();
        this.refreshControlTimer.stop();
    }

    @Override
    public final void paintComponent(Graphics gr) {
        try {
            this.mmax2.redraw(null);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            super.paintComponent(gr);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.mmax2.redraw(null);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public final MMAX2MouseMotionListener getCurrentMouseMotionListener() {
        return this.currentMouseMotionListener;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent p1) {
        JScrollBar adjustable = (JScrollBar)p1.getAdjustable();
        if (adjustable.getOrientation() == 0) {
            try {
                this.mmax2.updateRenderingListObjects();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.startAutoRefresh();
        try {
            this.mmax2.getCurrentViewport().repaint();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    class ComponentPrintable
    implements Printable {
        private final MMAX2TextPane mComponent;

        public ComponentPrintable(MMAX2TextPane p) {
            this.mComponent = p;
        }

        @Override
        public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
            if (pageIndex > 0) {
                return 1;
            }
            g.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
            this.mComponent.paintComponent(g);
            return 0;
        }
    }
}

