/*
 * Decompiled with CFR 0.152.
 */
package org.eml.MMAX2.gui.windows;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.eml.MMAX2.Messages;
import org.eml.MMAX2.annotation.markables.Markable;
import org.eml.MMAX2.annotation.markables.MarkableLevel;
import org.eml.MMAX2.annotation.markables.MarkablePointer;
import org.eml.MMAX2.annotation.markables.MarkableRelation;
import org.eml.MMAX2.annotation.scheme.MMAX2Attribute;
import org.eml.MMAX2.core.MMAX2;
import org.eml.MMAX2.discourse.MMAX2Discourse;
import org.eml.MMAX2.gui.display.BoxIcon;

public class MMAX2MarkablePointerBrowser
extends JFrame
implements ActionListener,
WindowListener,
MouseListener {
    private static final long serialVersionUID = 6664631616154686092L;
    private static final Logger logger = Logger.getLogger(MMAX2MarkablePointerBrowser.class);
    MMAX2 mmax2 = null;
    MMAX2Discourse discourse = null;
    JLabel levelBoxLabel = null;
    JComboBox levelBox = null;
    JLabel attributeBoxLabel = null;
    JComboBox attributeBox = null;
    JScrollPane treeViewPane = null;
    JTree tree = null;
    DefaultMutableTreeNode root = null;

    public MMAX2MarkablePointerBrowser(MMAX2 _mmax2) {
        this.addWindowListener(this);
        this.mmax2 = _mmax2;
        this.discourse = this.mmax2.getCurrentDiscourse();
        this.root = new DefaultMutableTreeNode(Messages.getString("MMAX2MarkablePointerBrowser.Document"));
        this.tree = new JTree(this.root);
        this.tree.addMouseListener(this);
        this.treeViewPane = new JScrollPane(this.tree);
        this.getContentPane().add(this.treeViewPane);
        JMenuBar menu = new JMenuBar();
        menu.setLayout(new FlowLayout(0, 5, 5));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        Box tmp = Box.createHorizontalBox();
        this.levelBox = new JComboBox();
        this.levelBoxLabel = new JLabel("Level:");
        tmp.add(this.levelBoxLabel);
        tmp.add(Box.createHorizontalStrut(10));
        tmp.add(this.levelBox);
        panel.add(tmp);
        tmp = Box.createHorizontalBox();
        this.attributeBox = new JComboBox();
        this.attributeBox.addItem("<none>");
        this.attributeBox.addActionListener(this);
        this.attributeBoxLabel = new JLabel("Attribute:");
        tmp.add(this.attributeBoxLabel);
        tmp.add(Box.createHorizontalStrut(10));
        tmp.add(this.attributeBox);
        panel.add(tmp);
        MarkableLevel[] levels = this.discourse.getCurrentMarkableChart().getMarkableLevels();
        if (levels.length == 1) {
            this.levelBox.addItem(levels[0].getMarkableLevelName());
            this.levelBox.setSelectedIndex(0);
            this.updateAttributeList((String)this.levelBox.getSelectedItem());
            this.levelBox.getParent().getParent().remove(this.levelBox.getParent());
        } else {
            this.levelBox.addItem("<none>");
            this.levelBox.setSelectedIndex(0);
            int b = 0;
            while (b < levels.length) {
                this.levelBox.addItem(levels[b].getMarkableLevelName());
                ++b;
            }
        }
        this.levelBox.addActionListener(this);
        menu.add(panel);
        this.setJMenuBar(menu);
        this.setTitle(Messages.getString("MMAX2MarkablePointerBrowser.MMAX2_Markable_Pointer_Browser"));
        this.setVisible(true);
        this.tree.expandRow(0);
        this.pack();
    }

    public final void update() {
        this.updatePointerDisplay((String)this.levelBox.getSelectedItem(), (String)this.attributeBox.getSelectedItem());
    }

    public final String getCurrentlyDisplayedMarkableLevelName() {
        return (String)this.levelBox.getSelectedItem();
    }

    public final String getCurrentlyDisplayedAttributeName() {
        return (String)this.attributeBox.getSelectedItem();
    }

    public final void updatePointerDisplay(String levelName, String attributeName) {
        this.root.removeAllChildren();
        if (!attributeName.equals("<none>")) {
            MarkablePointer[] pointers;
            MarkableLevel level = this.discourse.getCurrentMarkableChart().getMarkableLevelByName(levelName, false);
            MMAX2Attribute attribute = level.getCurrentAnnotationScheme().getUniqueAttributeByName("^" + attributeName.toLowerCase() + "$");
            MarkableRelation relation = attribute.getMarkableRelation();
            MarkablePointer[] markablePointerArray = pointers = relation.getMarkablePointers(true);
            int n = pointers.length;
            int n2 = 0;
            while (n2 < n) {
                MarkablePointer currentPointer = markablePointerArray[n2];
                DefaultMutableTreeNode pointerNode = new DefaultMutableTreeNode(currentPointer);
                this.root.add(pointerNode);
                ++n2;
            }
        }
        this.tree.updateUI();
        this.repaint();
    }

    public final void updateAttributeList(String levelName) {
        this.attributeBox.removeActionListener(this);
        this.attributeBox.removeAllItems();
        if (!levelName.equals("<none>")) {
            MarkableLevel level = this.discourse.getCurrentMarkableChart().getMarkableLevelByName(levelName, false);
            MMAX2Attribute[] attribs = level.getCurrentAnnotationScheme().getAttributesByType(6);
            if (attribs.length == 1) {
                this.attributeBox.addItem(attribs[0].getDisplayAttributeName());
                this.attributeBox.setSelectedIndex(0);
                this.attributeBox.getParent().getParent().remove(this.attributeBox.getParent());
            } else {
                this.attributeBox.addItem("<none>");
                int z = 0;
                while (z < attribs.length) {
                    this.attributeBox.addItem(attribs[z].getDisplayAttributeName());
                    ++z;
                }
            }
        } else {
            this.attributeBox.addItem("<none>");
        }
        this.attributeBox.addActionListener(this);
        this.root.removeAllChildren();
        this.tree.updateUI();
        this.repaint();
        this.update();
        this.pack();
        this.setLocation(0, this.mmax2.getScreenHeight() - this.getHeight());
    }

    @Override
    public final void dispose() {
        this.mmax2.dismissMarkablePointerBrowser();
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComboBox source = (JComboBox)e.getSource();
        if (source == this.levelBox) {
            this.updateAttributeList((String)source.getSelectedItem());
        } else if (source == this.attributeBox) {
            this.updatePointerDisplay((String)this.levelBox.getSelectedItem(), (String)source.getSelectedItem());
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        TreePath selPath = this.tree.getPathForLocation(e.getX(), e.getY());
        if (selPath != null) {
            DefaultMutableTreeNode closestNode = (DefaultMutableTreeNode)selPath.getLastPathComponent();
            this.tree.setSelectionPath(selPath);
            if (!closestNode.isRoot() && closestNode.isLeaf()) {
                MarkablePointer selectedPointer = (MarkablePointer)closestNode.getUserObject();
                final Markable selectedMarkable = selectedPointer.getSourceMarkable();
                this.discourse.getCurrentMarkableChart().markableLeftClicked(selectedMarkable);
                this.mmax2.scrollToMarkable(selectedMarkable);
                this.mmax2.getCurrentTextPane().startAutoRefresh();
                if (e.getButton() == 3) {
                    final MarkableRelation markableRelation = selectedPointer.getMarkableRelation();
                    JPopupMenu menu = new JPopupMenu();
                    JMenuItem item = new JMenuItem(selectedPointer.toString());
                    menu.add(item);
                    menu.addSeparator();
                    item = new JMenuItem("    " + Messages.getString("MMAX2MarkablePointerBrowser.Delete_pointer"), new BoxIcon(markableRelation.getAttribute().getLineColor()));
                    menu.add(item);
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            MMAX2MarkablePointerBrowser.this.mmax2.saveStateForUndo();
                            MMAX2MarkablePointerBrowser.this.discourse.getCurrentMarkableChart().removeMarkablePointerWithSourceMarkable(selectedMarkable, markableRelation, true);
                        }
                    });
                    menu.show(this.tree, e.getX(), e.getY());
                }
            }
        } else {
            this.discourse.getCurrentMarkableChart().nothingClicked(e.getButton());
        }
    }

    public void selectMarkable(Markable markable) {
        if (markable != null) {
            int i = 0;
            while (i < this.root.getChildCount()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)this.root.getChildAt(i);
                MarkablePointer pointer = (MarkablePointer)child.getUserObject();
                Markable source = pointer.getSourceMarkable();
                if (source.equals(markable)) {
                    TreePath path = new TreePath(child.getPath());
                    this.tree.setSelectionPath(path);
                    this.tree.scrollPathToVisible(path);
                    logger.debug("Selected markable: " + markable);
                    return;
                }
                ++i;
            }
        }
        logger.debug("Selected markable: " + markable + " not found in pointer browser. Deselecting.");
        this.tree.clearSelection();
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.dispose();
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

