/*
 * Decompiled with CFR 0.152.
 */
package pl.waw.ipipan.zil.core.mmax4core.annotation.markables;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.Markable;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.MarkableRelation;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.Renderable;
import pl.waw.ipipan.zil.core.mmax4core.api.MarkablePointerAPI;
import pl.waw.ipipan.zil.core.mmax4core.gui.document.MMAX2Document;
import pl.waw.ipipan.zil.core.mmax4core.utils.MMAX2Constants;
import pl.waw.ipipan.zil.core.mmax4core.utils.MMAX2Utils;

public class MarkablePointer
implements Renderable,
MarkablePointerAPI {
    private Markable sourceMarkable;
    private List<Markable> targetMarkables;
    private int lineWidth;
    private int size = 0;
    private int leftMostPosition;
    private int rightMostPosition;
    private int X_origin = 0;
    private int Y_origin = 0;
    private int[] X_points = null;
    private int[] Y_points = null;
    private MarkableRelation markableRelation = null;
    private int maxSize = -1;
    private boolean opaque = false;
    private boolean dashed = false;
    private boolean permanent = false;
    private int flagDisplayLevel = 0;
    private float[] dash1 = new float[2];
    private float[] dash2;

    public MarkablePointer(Markable _sourceMarkable, int _lineWidth, Color _color, int _lineStyle, int _maxSize, MarkableRelation _relation, boolean _dashed) {
        this.dash1[0] = 10.0f;
        this.dash1[1] = 10.0f;
        this.dash2 = new float[2];
        this.dash2[0] = 4.0f;
        this.dash2[1] = 4.0f;
        this.markableRelation = _relation;
        this.sourceMarkable = _sourceMarkable;
        this.lineWidth = _lineWidth;
        this.dashed = _dashed;
        this.leftMostPosition = this.sourceMarkable.getLeftmostDisplayPosition();
        this.rightMostPosition = this.sourceMarkable.getRightmostDisplayPosition();
        this.targetMarkables = new ArrayList<Markable>();
        this.maxSize = _maxSize;
    }

    @Override
    public final void setIsPermanent(boolean _permanent) {
        this.permanent = _permanent;
    }

    @Override
    public final boolean getIsPermanent() {
        return this.permanent;
    }

    public final boolean hasMaxSize() {
        if (this.maxSize == -1) {
            return false;
        }
        return this.size == this.maxSize;
    }

    public final String getTargetSpan() {
        String span = "";
        Markable currentTarget = null;
        if (this.targetMarkables.size() == 1) {
            currentTarget = this.targetMarkables.get(0);
            span = currentTarget.getMarkableLevelName().equals(this.getSourceMarkable().getMarkableLevelName()) ? currentTarget.getID() : String.valueOf(currentTarget.getMarkableLevelName()) + ":" + currentTarget.getID();
        } else if (this.targetMarkables.size() > 1) {
            int z = 0;
            while (z < this.targetMarkables.size()) {
                currentTarget = this.targetMarkables.get(z);
                span = z == 0 ? (currentTarget.getMarkableLevelName().equals(this.getSourceMarkable().getMarkableLevelName()) ? currentTarget.getID() : String.valueOf(currentTarget.getMarkableLevelName()) + ":" + currentTarget.getID()) : (currentTarget.getMarkableLevelName().equals(this.getSourceMarkable().getMarkableLevelName()) ? String.valueOf(span) + ";" + currentTarget.getID() : String.valueOf(span) + ";" + currentTarget.getMarkableLevelName() + ":" + currentTarget.getID());
                ++z;
            }
        }
        return span;
    }

    public final void setOpaque(boolean status) {
        this.opaque = status;
    }

    @Override
    public final boolean isOpaque() {
        return this.opaque;
    }

    public final int getSize() {
        return this.size;
    }

    @Override
    public final MarkableRelation getMarkableRelation() {
        return this.markableRelation;
    }

    @Override
    public final Markable[] getTargetMarkables() {
        return this.targetMarkables.toArray(new Markable[0]);
    }

    @Override
    public final Markable getSourceMarkable() {
        return this.sourceMarkable;
    }

    @Override
    public final boolean isSourceMarkable(Markable potentialSourceMarkable) {
        return this.sourceMarkable == potentialSourceMarkable;
    }

    @Override
    public final boolean isTargetMarkable(Markable potentialTargetMarkable) {
        return this.targetMarkables.contains(potentialTargetMarkable);
    }

    @Override
    public boolean containsMarkable(Markable markable) {
        boolean result = false;
        if (markable == this.sourceMarkable) {
            result = true;
        } else if (this.targetMarkables.contains(markable)) {
            result = true;
        }
        return result;
    }

    public final void removeTargetMarkable(Markable removee) {
        this.targetMarkables.remove(removee);
        --this.size;
    }

    public final void removeMeFromMarkableRelation() {
        this.markableRelation.removeMarkablePointer(this);
        this.size = 0;
    }

    public final String toString() {
        if (this.getTargetMarkables().length < 1) {
            return this.getSourceMarkable().toString();
        }
        StringBuffer sb = new StringBuffer();
        Markable[] markableArray = this.getTargetMarkables();
        int n = markableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Markable m = markableArray[n2];
            sb.append("," + m);
            ++n2;
        }
        return String.valueOf(this.getSourceMarkable().toString()) + " -> " + sb.substring(1);
    }

    public void addTargetMarkable(Markable _markable) {
        if (_markable.getLeftmostDisplayPosition() < this.leftMostPosition) {
            this.leftMostPosition = _markable.getLeftmostDisplayPosition();
        }
        if (_markable.getRightmostDisplayPosition() > this.rightMostPosition) {
            this.rightMostPosition = _markable.getRightmostDisplayPosition();
        }
        if (!this.targetMarkables.contains(_markable)) {
            this.targetMarkables.add(_markable);
            ++this.size;
        }
    }

    @Override
    public void unselect(MMAX2Document doc) {
        doc.startChanges(this.leftMostPosition, this.rightMostPosition - this.leftMostPosition + 1);
        if (this.size > 0) {
            if (this.permanent) {
                this.getSourceMarkable().renderMe(MMAX2Constants.RENDER_UNSELECTED);
            }
            int z = 0;
            while (z < this.size) {
                this.targetMarkables.get(z).renderMe(MMAX2Constants.RENDER_UNSELECTED);
                ++z;
            }
        }
        this.X_points = null;
        this.Y_points = null;
        doc.commitChanges();
    }

    @Override
    public void refresh(Graphics2D graphics) {
        if (this.size > 0) {
            this.drawSet(graphics);
        }
    }

    @Override
    public final void select(Graphics2D graphics, MMAX2Document doc, Markable currentlySelectedMarkable) {
        Markable temp = null;
        this.updateLinePoints();
        doc.startChanges(this.leftMostPosition, this.rightMostPosition - this.leftMostPosition + 1);
        if (this.size > 0) {
            if (this.permanent && !(temp = this.getSourceMarkable()).equals(currentlySelectedMarkable)) {
                temp.renderMe(MMAX2Constants.RENDER_IN_SET);
            }
            int z = 0;
            while (z < this.size) {
                temp = this.targetMarkables.get(z);
                if (!temp.equals(currentlySelectedMarkable)) {
                    temp.renderMe(MMAX2Constants.RENDER_IN_SET);
                }
                ++z;
            }
            this.drawSet(graphics);
        }
        doc.commitChanges();
    }

    @Override
    public final void updateLinePoints() {
        Point currentPoint = this.sourceMarkable.getPoint();
        this.X_origin = (int)currentPoint.getX();
        this.Y_origin = (int)currentPoint.getY();
        currentPoint = null;
        this.X_points = new int[this.size];
        this.Y_points = new int[this.size];
        int z = 0;
        while (z < this.size) {
            currentPoint = this.targetMarkables.get(z).getPoint();
            this.X_points[z] = (int)currentPoint.getX();
            this.Y_points[z] = (int)currentPoint.getY();
            ++z;
        }
    }

    private final void drawSet(Graphics2D graphics) {
        QuadCurve2D.Double c = null;
        Point ctrlPoint = null;
        int z = this.size - 1;
        while (z >= 0) {
            graphics.setColor(this.markableRelation.getLineColor());
            if (!this.dashed) {
                graphics.setStroke(new BasicStroke(this.lineWidth));
            } else {
                graphics.setStroke(new BasicStroke(this.lineWidth, 2, 0, 10.0f, this.dash1, 0.0f));
            }
            if (this.markableRelation.getLineStyle() == MMAX2Constants.STRAIGHT) {
                graphics.drawLine(this.X_origin, this.Y_origin, this.X_points[z], this.Y_points[z]);
                this.drawArrow(graphics, new Point(this.X_points[z], this.Y_points[z]), new Point(this.X_origin, this.Y_origin));
            } else {
                boolean smart = false;
                if (this.markableRelation.getLineStyle() == MMAX2Constants.SMARTCURVE) {
                    smart = true;
                    if (this.X_origin < this.X_points[z]) {
                        this.markableRelation.setLineStyle(new Integer(MMAX2Constants.LCURVE));
                    } else {
                        this.markableRelation.setLineStyle(new Integer(MMAX2Constants.RCURVE));
                    }
                }
                c = new QuadCurve2D.Double();
                ctrlPoint = MMAX2Utils.calculateControlPoint(this.X_origin, this.Y_origin, this.X_points[z], this.Y_points[z], this.markableRelation.getLineStyle());
                c.setCurve(this.X_origin, this.Y_origin, ctrlPoint.getX(), ctrlPoint.getY(), this.X_points[z], this.Y_points[z]);
                if (smart) {
                    graphics.fillOval(this.X_origin - 4, this.Y_origin - 4, 8, 8);
                }
                graphics.draw(c);
                this.drawArrow(graphics, new Point(this.X_points[z], this.Y_points[z]), ctrlPoint);
                if (smart) {
                    boolean flagToRight = true;
                    FontMetrics m = graphics.getFontMetrics();
                    String toDisplay = this.getMarkableRelation().getAttributeName();
                    String attributeToDisplay = this.getMarkableRelation().getAttributeNameToShowInFlag();
                    if (!attributeToDisplay.equals("")) {
                        Markable currentTarget = this.targetMarkables.get(z);
                        toDisplay = String.valueOf(toDisplay) + " " + attributeToDisplay + "=" + currentTarget.getAttributeValue(attributeToDisplay, "");
                    }
                    Rectangle2D rect = m.getStringBounds(toDisplay, graphics);
                    int flagXLevel = (this.flagDisplayLevel + 1 + z) * 25;
                    if ((int)rect.getWidth() + flagXLevel + this.X_points[z] + 6 >= this.sourceMarkable.getMarkableLevel().getCurrentDiscourse().getMMAX2().getCurrentTextPane().getWidth()) {
                        flagToRight = false;
                    }
                    graphics.setColor(Color.black);
                    graphics.setStroke(new BasicStroke(1.0f, 2, 0));
                    if (flagToRight) {
                        graphics.drawLine(this.X_points[z], this.Y_points[z], this.X_points[z] + flagXLevel, this.Y_points[z] - flagXLevel);
                    } else {
                        graphics.drawLine(this.X_points[z], this.Y_points[z], this.X_points[z] - flagXLevel, this.Y_points[z] - flagXLevel);
                    }
                    graphics.setFont(graphics.getFont().deriveFont(1, 11.0f));
                    graphics.setColor(Color.white);
                    int flagXOrigin = 0;
                    int flagYOrigin = 0;
                    int flagWidth = (int)rect.getWidth() + 6;
                    int flagHeight = (int)rect.getHeight() + 6;
                    if (flagToRight) {
                        flagXOrigin = this.X_points[z] + flagXLevel;
                        flagYOrigin = this.Y_points[z] - flagXLevel - (int)rect.getHeight() - 6;
                    } else {
                        flagXOrigin = this.X_points[z] - flagWidth - flagXLevel;
                        flagYOrigin = this.Y_points[z] - flagXLevel - (int)rect.getHeight() - 6;
                    }
                    graphics.fillRect(flagXOrigin, flagYOrigin, flagWidth, flagHeight);
                    graphics.setColor(Color.black);
                    graphics.drawRect(flagXOrigin, flagYOrigin, flagWidth, flagHeight);
                    if (flagToRight) {
                        graphics.drawString(toDisplay, this.X_points[z] + flagXLevel + 3, this.Y_points[z] - (flagXLevel + 6));
                    } else {
                        graphics.drawString(toDisplay, this.X_points[z] - flagXLevel - flagWidth + 3, this.Y_points[z] - (flagXLevel + 6));
                    }
                    this.markableRelation.setLineStyle(new Integer(MMAX2Constants.SMARTCURVE));
                }
            }
            --z;
        }
    }

    private void drawArrow(Graphics2D g, Point head, Point away) {
        double arrow_angle = 1.0;
        double arrow_length = 10.0;
        double angle = Math.atan2(away.x - head.x, away.y - head.y);
        int endX = (int)(Math.sin(angle += arrow_angle) * arrow_length) + head.x;
        int endY = (int)(Math.cos(angle) * arrow_length) + head.y;
        g.drawLine(head.x, head.y, endX, endY);
        endX = (int)(Math.sin(angle -= 2.0 * arrow_angle) * arrow_length) + head.x;
        endY = (int)(Math.cos(angle) * arrow_length) + head.y;
        g.drawLine(head.x, head.y, endX, endY);
    }

    @Override
    public void setFlagLevel(int _level) {
        this.flagDisplayLevel = _level;
    }
}

