/*
 * Decompiled with CFR 0.152.
 */
package pl.waw.ipipan.zil.core.mmax4core.annotation.scheme;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import pl.waw.ipipan.zil.core.mmax4core.Messages;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.Markable;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.MarkableChart;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.MarkableHelper;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.MarkableRelation;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.MarkableSet;
import pl.waw.ipipan.zil.core.mmax4core.annotation.scheme.MMAX2Attribute;
import pl.waw.ipipan.zil.core.mmax4core.api.AnnotationSchemeAPI;
import pl.waw.ipipan.zil.core.mmax4core.core.MMAX2;
import pl.waw.ipipan.zil.core.mmax4core.gui.windows.MMAX2AttributePanel;
import pl.waw.ipipan.zil.core.mmax4core.gui.windows.MMAX2AttributePanelContainer;
import pl.waw.ipipan.zil.core.mmax4core.utils.MMAX2Constants;
import pl.waw.ipipan.zil.core.mmax4core.utils.MMAX2Utils;

public class MMAX2AnnotationScheme
implements AnnotationSchemeAPI {
    private static final Logger logger = Logger.getLogger(MMAX2AnnotationScheme.class);
    private Hashtable<String, MMAX2Attribute> attributesByID;
    private Hashtable<String, MMAX2Attribute> attributesByLowerCasedAttributeName;
    private List<MMAX2Attribute> attributes;
    private Hashtable<String, String> valueIDsToAttributeIDs;
    private MMAX2AttributePanel attributepanel;
    private int size = 0;
    MMAX2 mmax2 = null;
    boolean ignoreClick = false;
    boolean hintLocked = false;
    String currentAttributeHintedAt = "";
    private String schemeFileName = "";

    public MMAX2AnnotationScheme(String schemefilename) {
        this.schemeFileName = schemefilename;
        DOMParser parser = new DOMParser();
        try {
            parser.setFeature("http://xml.org/sax/features/validation", false);
        }
        catch (SAXNotRecognizedException ex) {
            ex.printStackTrace();
        }
        catch (SAXNotSupportedException ex) {
            ex.printStackTrace();
        }
        try {
            parser.parse(new InputSource(new File(schemefilename).toURI().toASCIIString()));
        }
        catch (SAXException exception) {
            exception.printStackTrace();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        this.attributesByID = new Hashtable();
        this.attributes = new ArrayList<MMAX2Attribute>();
        this.attributesByLowerCasedAttributeName = new Hashtable();
        this.valueIDsToAttributeIDs = new Hashtable();
        int labelLength = 0;
        Document schemeDOM = parser.getDocument();
        float fontSize = 11.0f;
        NodeList root = schemeDOM.getElementsByTagName("annotationscheme");
        try {
            fontSize = Float.parseFloat(root.item(0).getAttributes().getNamedItem("fontsize").getNodeValue());
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        NodeList allAttributes = schemeDOM.getElementsByTagName("attribute");
        MMAX2Attribute currentAttribute = null;
        Node currentNode = null;
        int z = 0;
        while (z < allAttributes.getLength()) {
            currentNode = allAttributes.item(z);
            String currentNodeName = currentNode.getAttributes().getNamedItem("name").getNodeValue();
            if (currentNodeName.length() >= labelLength) {
                labelLength = currentNodeName.length();
            }
            ++z;
        }
        z = 0;
        while (z < allAttributes.getLength()) {
            String toolTipText = "";
            currentNode = allAttributes.item(z);
            try {
                toolTipText = currentNode.getAttributes().getNamedItem("text").getNodeValue();
            }
            catch (NullPointerException ex) {
                toolTipText = "";
            }
            String localizedName = "";
            try {
                localizedName = currentNode.getAttributes().getNamedItem("localized_name").getNodeValue();
            }
            catch (NullPointerException ex) {
                localizedName = "";
            }
            String descriptionFileName = "";
            try {
                descriptionFileName = currentNode.getAttributes().getNamedItem("description").getNodeValue();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            String hintText = "";
            if (!descriptionFileName.equals("")) {
                hintText = MMAX2AnnotationScheme.readHTMLFromFile(String.valueOf(this.schemeFileName.substring(0, this.schemeFileName.lastIndexOf(File.separator) + 1)) + descriptionFileName);
            }
            String type = "";
            int typeInt = -1;
            try {
                type = currentNode.getAttributes().getNamedItem("type").getNodeValue().trim();
            }
            catch (NullPointerException ex) {
                type = "nominal_list";
            }
            type = type.toLowerCase();
            String attributeToShowInPointerFlag = "";
            if (type.equalsIgnoreCase("nominal_button")) {
                typeInt = 1;
            } else if (type.equalsIgnoreCase("nominal_list")) {
                typeInt = 2;
            } else if (type.equalsIgnoreCase("freetext")) {
                typeInt = 3;
            } else if (type.equalsIgnoreCase("head")) {
                typeInt = 4;
            } else if (type.equalsIgnoreCase("type")) {
                typeInt = 7;
            } else if (type.equalsIgnoreCase("markable_pointer_attr")) {
                typeInt = 8;
            } else if (type.equalsIgnoreCase("markable_set")) {
                typeInt = 5;
            } else if (type.equalsIgnoreCase("markable_pointer")) {
                typeInt = 6;
            } else if (type.startsWith("markable_pointer:")) {
                typeInt = 6;
                attributeToShowInPointerFlag = type.substring(type.indexOf(":") + 1);
            }
            int lineWidth = 2;
            try {
                lineWidth = Integer.parseInt(currentNode.getAttributes().getNamedItem("width").getNodeValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            Color color = Color.black;
            try {
                color = MMAX2Utils.getColorByName(currentNode.getAttributes().getNamedItem("color").getNodeValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            String lineStyle = "straight";
            int lineStyleInt = MMAX2Constants.STRAIGHT;
            try {
                lineStyle = currentNode.getAttributes().getNamedItem("style").getNodeValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (lineStyle.equalsIgnoreCase("straight")) {
                lineStyleInt = MMAX2Constants.STRAIGHT;
            } else if (lineStyle.equalsIgnoreCase("lcurve")) {
                lineStyleInt = MMAX2Constants.LCURVE;
            } else if (lineStyle.equalsIgnoreCase("rcurve")) {
                lineStyleInt = MMAX2Constants.RCURVE;
            } else if (lineStyle.equalsIgnoreCase("xcurve")) {
                lineStyleInt = MMAX2Constants.XCURVE;
            } else if (lineStyle.equalsIgnoreCase("smartcurve")) {
                lineStyleInt = MMAX2Constants.SMARTCURVE;
            }
            int maxSize = -1;
            try {
                maxSize = Integer.parseInt(currentNode.getAttributes().getNamedItem("max_size").getNodeValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            String targetDomain = "";
            try {
                targetDomain = currentNode.getAttributes().getNamedItem("target_domain").getNodeValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean dashed = false;
            String dashAttrib = "false";
            try {
                dashAttrib = currentNode.getAttributes().getNamedItem("dashed").getNodeValue();
            }
            catch (Exception ex) {
                dashAttrib = "false";
            }
            if (!dashAttrib.equals("false")) {
                dashed = true;
            }
            String add_to_markableset_instruction = "ADD TO MARKABLE SET";
            try {
                add_to_markableset_instruction = currentNode.getAttributes().getNamedItem("add_to_markableset_text").getNodeValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String remove_from_markableset_instruction = "REMOVE FROM MARKABLE SET";
            try {
                remove_from_markableset_instruction = currentNode.getAttributes().getNamedItem("remove_from_markableset_text").getNodeValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String adopt_into_markableset_instruction = "ADOPT INTO MARKABLE SET";
            try {
                adopt_into_markableset_instruction = currentNode.getAttributes().getNamedItem("adopt_into_markableset_text").getNodeValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String merge_into_markableset_instruction = "MERGE INTO MARKABLE SET";
            try {
                merge_into_markableset_instruction = currentNode.getAttributes().getNamedItem("merge_into_markableset_text").getNodeValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String point_to_markable_instruction = "POINT TO MARKABLE";
            try {
                point_to_markable_instruction = currentNode.getAttributes().getNamedItem("point_to_markable_text").getNodeValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String remove_pointer_to_markable_instruction = "REMOVE POINTER TO MARKABLE";
            try {
                remove_pointer_to_markable_instruction = currentNode.getAttributes().getNamedItem("remove_pointer_to_markable_text").getNodeValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            currentAttribute = new MMAX2Attribute(currentNode.getAttributes().getNamedItem("id").getNodeValue(), currentNode.getAttributes().getNamedItem("name").getNodeValue(), typeInt, currentNode.getChildNodes(), this, labelLength, toolTipText, hintText, lineWidth, color, lineStyleInt, maxSize, targetDomain, add_to_markableset_instruction, remove_from_markableset_instruction, adopt_into_markableset_instruction, merge_into_markableset_instruction, point_to_markable_instruction, remove_pointer_to_markable_instruction, fontSize, dashed, attributeToShowInPointerFlag, localizedName);
            this.attributesByID.put(currentAttribute.getID(), currentAttribute);
            this.attributesByLowerCasedAttributeName.put(currentNode.getAttributes().getNamedItem("name").getNodeValue().toLowerCase(), currentAttribute);
            this.attributes.add(currentAttribute);
            currentAttribute = null;
            ++this.size;
            ++z;
        }
        z = 0;
        while (z < this.attributes.size()) {
            currentAttribute = this.attributes.get(z);
            MMAX2Attribute[] allDependentAttributes = currentAttribute.getDirectlyDependentAttributes();
            int b = 0;
            while (b < allDependentAttributes.length) {
                allDependentAttributes[b].addDependsOn(currentAttribute);
                ++b;
            }
            ++z;
        }
        this.attributepanel = new MMAX2AttributePanel(this);
        this.attributepanel.create();
    }

    public static String readHTMLFromFile(String file) {
        String result = "";
        BufferedReader abbrevReader = null;
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(file);
            abbrevReader = new BufferedReader(new InputStreamReader(inStream));
        }
        catch (FileNotFoundException ex) {
            System.err.println("Error: Couldn't find file " + file);
            return "File " + file + " could not be found!";
        }
        String currentLine = "";
        try {
            while ((currentLine = abbrevReader.readLine()) != null) {
                result = String.valueOf(result) + "\n" + currentLine;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        try {
            abbrevReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public final void setAttributePanelContainer(MMAX2AttributePanelContainer _container) {
        this.attributepanel.setAttributePanelContainer(_container);
    }

    public String getSchemeFileName() {
        return this.schemeFileName;
    }

    @Override
    public MMAX2Attribute[] getAttributesByType(int type) {
        ArrayList<MMAX2Attribute> tempresult = new ArrayList<MMAX2Attribute>();
        int p = 0;
        while (p < this.attributes.size()) {
            MMAX2Attribute currentAttribute = this.attributes.get(p);
            if (currentAttribute.getType() == type) {
                tempresult.add(currentAttribute);
            }
            ++p;
        }
        MMAX2Attribute[] realresult = new MMAX2Attribute[tempresult.size()];
        int z = 0;
        while (z < tempresult.size()) {
            realresult[z] = (MMAX2Attribute)tempresult.get(z);
            ++z;
        }
        return realresult;
    }

    @Override
    public MMAX2Attribute getUniqueAttributeByType(int type) {
        int p = 0;
        while (p < this.attributes.size()) {
            MMAX2Attribute currentAttribute = this.attributes.get(p);
            if (currentAttribute.getType() == type) {
                return currentAttribute;
            }
            ++p;
        }
        return null;
    }

    @Override
    public MMAX2Attribute[] getAttributesByType(int type1, int type2) {
        ArrayList<MMAX2Attribute> tempresult = new ArrayList<MMAX2Attribute>();
        int p = 0;
        while (p < this.attributes.size()) {
            MMAX2Attribute currentAttribute = this.attributes.get(p);
            if (currentAttribute.getType() == type1 || currentAttribute.getType() == type2) {
                tempresult.add(currentAttribute);
            }
            ++p;
        }
        MMAX2Attribute[] realresult = new MMAX2Attribute[tempresult.size()];
        int z = 0;
        while (z < tempresult.size()) {
            realresult[z] = (MMAX2Attribute)tempresult.get(z);
            ++z;
        }
        return realresult;
    }

    @Override
    public MMAX2Attribute getUniqueAttributeByType(int type1, int type2) {
        int p = 0;
        while (p < this.attributes.size()) {
            MMAX2Attribute currentAttribute = this.attributes.get(p);
            if (currentAttribute.getType() == type1 || currentAttribute.getType() == type2) {
                return currentAttribute;
            }
            ++p;
        }
        return null;
    }

    @Override
    public MMAX2Attribute[] getAttributesByName(String nameRegExp) {
        ArrayList<MMAX2Attribute> tempResult = new ArrayList<MMAX2Attribute>();
        int p = 0;
        while (p < this.attributes.size()) {
            MMAX2Attribute currentAttribute = this.attributes.get(p);
            if (currentAttribute.getLowerCasedAttributeName().matches(nameRegExp)) {
                tempResult.add(currentAttribute);
            }
            ++p;
        }
        MMAX2Attribute[] realresult = new MMAX2Attribute[tempResult.size()];
        int z = 0;
        while (z < tempResult.size()) {
            realresult[z] = (MMAX2Attribute)tempResult.get(z);
            ++z;
        }
        return realresult;
    }

    @Override
    public MMAX2Attribute getUniqueAttributeByName(String nameRegExp) {
        int p = 0;
        while (p < this.attributes.size()) {
            MMAX2Attribute currentAttribute = this.attributes.get(p);
            if (currentAttribute.getLowerCasedAttributeName().matches(nameRegExp)) {
                return currentAttribute;
            }
            ++p;
        }
        return null;
    }

    @Override
    public MMAX2Attribute[] getAttributesByNameAndType(String name, int type) {
        ArrayList<MMAX2Attribute> tempResult = new ArrayList<MMAX2Attribute>();
        MMAX2Attribute[] temp = this.getAttributesByType(type);
        int b = 0;
        while (b < temp.length) {
            if (temp[b].getLowerCasedAttributeName().matches(name)) {
                tempResult.add(temp[b]);
            }
            ++b;
        }
        MMAX2Attribute[] realresult = new MMAX2Attribute[tempResult.size()];
        int z = 0;
        while (z < tempResult.size()) {
            realresult[z] = (MMAX2Attribute)tempResult.get(z);
            ++z;
        }
        return realresult;
    }

    @Override
    public MMAX2Attribute getUniqueAttributeByNameAndType(String name, int type) {
        MMAX2Attribute[] temp = this.getAttributesByType(type);
        int b = 0;
        while (b < temp.length) {
            if (temp[b].getLowerCasedAttributeName().matches(name)) {
                return temp[b];
            }
            ++b;
        }
        return null;
    }

    @Override
    public MMAX2Attribute[] getAttributesByNameAndType(String name, int type1, int type2) {
        ArrayList<MMAX2Attribute> tempResult = new ArrayList<MMAX2Attribute>();
        MMAX2Attribute[] temp = this.getAttributesByType(type1, type2);
        int b = 0;
        while (b < temp.length) {
            if (temp[b].getLowerCasedAttributeName().matches(name)) {
                tempResult.add(temp[b]);
            }
            ++b;
        }
        MMAX2Attribute[] realresult = new MMAX2Attribute[tempResult.size()];
        int z = 0;
        while (z < tempResult.size()) {
            realresult[z] = (MMAX2Attribute)tempResult.get(z);
            ++z;
        }
        return realresult;
    }

    @Override
    public MMAX2Attribute getUniqueAttributeByNameAndType(String name, int type1, int type2) {
        MMAX2Attribute[] temp = this.getAttributesByType(type1, type2);
        int b = 0;
        while (b < temp.length) {
            if (temp[b].getLowerCasedAttributeName().matches(name)) {
                return temp[b];
            }
            ++b;
        }
        return null;
    }

    public final void setMMAX2(MMAX2 _mmax2) {
        this.mmax2 = _mmax2;
    }

    public final List<MMAX2Attribute> getIndependentAttributes(boolean enable) {
        ArrayList<MMAX2Attribute> tempresult = new ArrayList<MMAX2Attribute>();
        MMAX2Attribute currentAttribute = null;
        int p = 0;
        while (p < this.attributes.size()) {
            currentAttribute = this.attributes.get(p);
            currentAttribute.toDefault();
            if (currentAttribute.isIndependent()) {
                if (enable) {
                    currentAttribute.setEnabled(!currentAttribute.getIsReadOnly());
                }
                tempresult.add(currentAttribute);
            }
            ++p;
        }
        return tempresult;
    }

    public MMAX2AttributePanel getAttributePanel() {
        return this.attributepanel;
    }

    public void valueChanged(MMAX2Attribute callingAttribute, MMAX2Attribute topCallingAttribute, MMAX2Attribute[] oldRemovedAttributes, int position, List<MMAX2Attribute> requestedAttributesAsList) {
        String currentMarkableValue;
        MMAX2Attribute currentSchemeLevel;
        int o;
        this.attributepanel.setHasUncommittedChanges(true);
        MMAX2Attribute[] removedAttributes = null;
        if (oldRemovedAttributes != null) {
            removedAttributes = oldRemovedAttributes;
        } else if (callingAttribute.getIsBranching()) {
            removedAttributes = this.attributepanel.removeTrailingDependentAttributes(callingAttribute);
        }
        MMAX2Attribute[] requestedAttributes = callingAttribute.getNextAttributes(false);
        if (removedAttributes != null && requestedAttributes.length != 0) {
            this.mapSelections(removedAttributes, requestedAttributes);
            o = 0;
            while (o < requestedAttributes.length) {
                currentSchemeLevel = requestedAttributes[o];
                currentMarkableValue = this.attributepanel.currentMarkable.getAttributeValue(currentSchemeLevel.getLowerCasedAttributeName());
                if (currentMarkableValue != null && !currentMarkableValue.equals("")) {
                    if (!currentSchemeLevel.isDefined(currentMarkableValue)) {
                        currentSchemeLevel.setIsFrozen(false, "");
                    } else if (!currentSchemeLevel.oldValue.equals("")) {
                        currentSchemeLevel.setSelectedValue(currentSchemeLevel.oldValue, true);
                        currentSchemeLevel.oldValue = "";
                    } else {
                        currentSchemeLevel.setSelectedValue(currentMarkableValue, true);
                    }
                }
                ++o;
            }
        } else if (removedAttributes != null) {
            requestedAttributes = new MMAX2Attribute[]{};
            int p = 0;
            while (p < removedAttributes.length) {
                if (removedAttributes[p].getIsFrozen()) {
                    System.err.println("Frozen: " + removedAttributes[p].getDisplayAttributeName());
                    if (!this.attributepanel.keepables.contains(removedAttributes[p].getLowerCasedAttributeName())) {
                        this.attributepanel.keepables.add(removedAttributes[p].getLowerCasedAttributeName());
                    }
                    System.err.println("Keeping in keepables. Size:" + this.attributepanel.keepables.size());
                }
                ++p;
            }
        } else if (requestedAttributes != null) {
            o = 0;
            while (o < requestedAttributes.length) {
                currentSchemeLevel = requestedAttributes[o];
                currentMarkableValue = this.attributepanel.currentMarkable.getAttributeValue(currentSchemeLevel.getLowerCasedAttributeName());
                if (currentMarkableValue != null && !currentMarkableValue.equals("")) {
                    if (!currentSchemeLevel.isDefined(currentMarkableValue)) {
                        currentSchemeLevel.setIsFrozen(false, "");
                    } else {
                        currentSchemeLevel.setSelectedValue(currentMarkableValue, true);
                    }
                }
                ++o;
            }
        } else {
            callingAttribute.setSelectedIndex(position);
        }
        if (requestedAttributesAsList.size() == 0) {
            requestedAttributesAsList.addAll(Arrays.asList(requestedAttributes));
        } else {
            int movingIndex = 0;
            int o2 = 0;
            while (o2 < requestedAttributes.length) {
                if (!requestedAttributesAsList.contains(requestedAttributes[o2])) {
                    requestedAttributesAsList.add(requestedAttributesAsList.indexOf(callingAttribute) + movingIndex + 1, requestedAttributes[o2]);
                    ++movingIndex;
                }
                ++o2;
            }
        }
        int n = 0;
        while (n < requestedAttributes.length) {
            MMAX2Attribute current = requestedAttributes[n];
            if (current.getIsBranching() && current.getNextAttributes(false).length != 0) {
                this.valueChanged(current, topCallingAttribute, removedAttributes, current.getSelectedIndex(), requestedAttributesAsList);
            }
            ++n;
        }
        this.attributepanel.addAttributesAfter(requestedAttributesAsList.toArray(new MMAX2Attribute[0]), topCallingAttribute);
        try {
            if (this.attributepanel.getContainer().isAutoApply()) {
                logger.debug("Auto applying changes in attribute " + callingAttribute.getID());
                this.attributepanel.keepables.clear();
                this.attributepanel.setMarkableAttributes(this.attributepanel.currentMarkable, true);
                this.attributepanel.currentMarkable.getMarkableLevel().setIsDirty(true, true);
            } else {
                this.attributepanel.getContainer().setApplyEnabled(true);
                this.attributepanel.getContainer().setUndoEnabled(true);
            }
            this.attributepanel.rebuild();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.attributepanel.getScrollPane().scrollRectToVisible(this.attributepanel.getLastAttribute().getVisibleRect());
        this.attributepanel.invalidate();
        this.attributepanel.repaint();
        this.attributepanel.getContainer().invalidate();
        this.attributepanel.getContainer().repaint();
    }

    public void mapSelections(MMAX2Attribute[] removedLevels, MMAX2Attribute[] requestedLevels) {
        int remLen = removedLevels.length;
        int reqLen = requestedLevels.length;
        MMAX2Attribute currentRequestedLevel = null;
        String currentRequestedAttribute = "";
        MMAX2Attribute currentRemovedLevel = null;
        String currentRemovedAttribute = "";
        String currentRemovedValue = "";
        boolean found = false;
        int z = 0;
        while (z < reqLen) {
            currentRequestedLevel = requestedLevels[z];
            int u = 0;
            while (u < remLen) {
                currentRemovedLevel = removedLevels[u];
                if (currentRemovedLevel.getID().equals(currentRequestedLevel.getID())) {
                    currentRemovedLevel.oldValue = currentRemovedLevel.getSelectedValue();
                    found = true;
                }
                if (currentRemovedLevel.getIsFrozen()) {
                    System.err.println("Frozen: " + currentRemovedLevel.getDisplayAttributeName());
                    if (!this.attributepanel.keepables.contains(currentRemovedLevel.getLowerCasedAttributeName())) {
                        this.attributepanel.keepables.add(currentRemovedLevel.getLowerCasedAttributeName());
                        System.err.println("Keeping in keepables. Size:" + this.attributepanel.keepables.size());
                    }
                }
                ++u;
            }
            if (!found) {
                u = 0;
                while (u < remLen) {
                    currentRemovedLevel = removedLevels[u];
                    currentRequestedAttribute = currentRequestedLevel.getLowerCasedAttributeName();
                    if (currentRequestedAttribute.equals(currentRemovedAttribute = currentRemovedLevel.getLowerCasedAttributeName())) {
                        currentRemovedValue = currentRemovedLevel.getSelectedValue();
                        if (!currentRequestedLevel.oldValue.equals("")) {
                            currentRequestedLevel.setSelectedValue(currentRequestedLevel.oldValue, true);
                        } else {
                            currentRemovedLevel.oldValue = !currentRequestedLevel.setSelectedValue(currentRemovedValue, true) ? currentRemovedValue : "";
                        }
                    }
                    ++u;
                }
            }
            ++z;
        }
    }

    public void addValueIDToAttributeIDMapping(String valueID, String attributeID) {
        this.valueIDsToAttributeIDs.put(valueID, attributeID);
    }

    public void resetAllAttributes() {
        int z = 0;
        while (z < this.size) {
            this.attributes.get(z).toDefault();
            this.attributes.get(z).setIsFrozen(false, "");
            ++z;
        }
    }

    public void reset() {
        this.attributepanel.removeAllAttributes();
        this.resetAllAttributes();
        MMAX2Attribute[] attributes = this.getInitialAttributes().toArray(new MMAX2Attribute[0]);
        this.attributepanel.addAttributes(attributes);
    }

    public void setEnabled(boolean status) {
        int p = 0;
        while (p < this.attributes.size()) {
            MMAX2Attribute currentAttribute = this.attributes.get(p);
            currentAttribute.setEnabled(status);
            ++p;
        }
    }

    public List<MMAX2Attribute> getInitialAttributes() {
        List<MMAX2Attribute> independentAttributes = this.getIndependentAttributes(false);
        int z = 0;
        while (z < independentAttributes.size()) {
            MMAX2Attribute currentAttribute = independentAttributes.get(z);
            MMAX2Attribute[] dependentAttributes = currentAttribute.getNextAttributes(true);
            if (dependentAttributes.length > 0) {
                int b = 0;
                while (b < dependentAttributes.length) {
                    if (!independentAttributes.contains(dependentAttributes[b])) {
                        independentAttributes.add(z + 1 + b, dependentAttributes[b]);
                    }
                    ++b;
                }
            }
            ++z;
        }
        return independentAttributes;
    }

    public MMAX2Attribute[] getAttributes(Markable markable) {
        HashMap<String, String> tempattribs = new HashMap<String, String>(markable.getAttributes());
        MMAX2Attribute currentAttribute = null;
        String currentAttributeString = "";
        String currentAttributeValue = "";
        List<MMAX2Attribute> independentAttributesAsList = this.getIndependentAttributes(true);
        int z = 0;
        while (z < independentAttributesAsList.size()) {
            currentAttribute = independentAttributesAsList.get(z);
            currentAttributeString = currentAttribute.getLowerCasedAttributeName();
            if (currentAttribute.getType() == 4) {
                currentAttribute.removeAllItems();
                currentAttribute.buttonIndicesToLowerCasedValueStrings.clear();
                currentAttribute.lowerCasedValueStringsToButtonIndices.clear();
                currentAttribute.size = 0;
                int i = -1;
                currentAttribute.addItem("");
                currentAttribute.buttonIndicesToLowerCasedValueStrings.add("");
                currentAttribute.lowerCasedValueStringsToButtonIndices.put("", new Integer(currentAttribute.size));
                ++currentAttribute.size;
                String val = markable.getAttributeValue(currentAttributeString, "");
                String[] stringArray = markable.getDiscourseElements();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String de = stringArray[n2];
                    currentAttribute.addItem(de);
                    currentAttribute.buttonIndicesToLowerCasedValueStrings.add(new String(de));
                    currentAttribute.lowerCasedValueStringsToButtonIndices.put(new String(de), new Integer(currentAttribute.size));
                    if (val.equalsIgnoreCase(de)) {
                        i = currentAttribute.size;
                    }
                    ++currentAttribute.size;
                    ++n2;
                }
                if (i == -1) {
                    currentAttribute.setSelectedIndex(0);
                } else {
                    currentAttribute.setSelectedIndex(i);
                }
                markable.setAttributeValue(currentAttributeString, val, true);
            }
            if ((currentAttributeValue = markable.getAttributeValue(currentAttributeString)) == null) {
                currentAttributeValue = currentAttribute.getType() == 5 || currentAttribute.getType() == 6 ? MMAX2.defaultRelationValue : "";
            }
            if (!currentAttribute.setSelectedValue(currentAttributeValue, true)) {
                String message = "";
                if (!currentAttribute.getIsReadOnly()) {
                    message = String.valueOf(Messages.getString("MMAX2AnnotationScheme.Warning")) + "\n" + Messages.getString("MMAX2AnnotationScheme.Value") + ": '" + currentAttributeValue + "' \n" + Messages.getString("MMAX2AnnotationScheme.undefined_for_attribute") + ": '" + currentAttribute.getLocalizedAttributeName() + "' \n" + Messages.getString("MMAX2AnnotationScheme.for_markable") + ": " + markable + ".";
                    message = String.valueOf(message) + "\n\n" + Messages.getString("MMAX2AnnotationScheme.It_is_going_To_be_overwritten_with_default_value") + ".";
                    JOptionPane.showMessageDialog(null, message, Messages.getString("MMAX2AnnotationScheme.Undefined_attribute_value"), 2);
                    currentAttribute.setIsFrozen(false, "");
                    markable.setAttributeValue(currentAttributeString, currentAttribute.getDefaultValue());
                } else {
                    message = "Error on read-only level '" + markable.getMarkableLevelName() + "': Value '" + currentAttributeValue + "' is undefined for attribute '" + currentAttribute.getDisplayAttributeName() + "'!";
                    message = String.valueOf(message) + "\nDetails:\nString: " + markable.toString() + "\nSpan: " + MarkableHelper.getSpan(markable) + "\nFile: " + markable.getMarkableLevel().getMarkableFileName();
                    message = String.valueOf(message) + "\nIt is recommended that you check your annotation!";
                    Object[] options = new Object[]{"Keep invalid value"};
                    JOptionPane.showOptionDialog(null, message, "MMAX2: Annotation inconsistency (initial attributes)!", -1, 2, null, options, options[0]);
                    currentAttribute.setIsFrozen(true, currentAttributeValue);
                }
            }
            tempattribs.remove(currentAttributeString);
            if (currentAttribute.getIsBranching() && currentAttribute.getNextAttributes(false).length != 0) {
                ArrayList<MMAX2Attribute> addees = new ArrayList<MMAX2Attribute>(Arrays.asList(currentAttribute.getNextAttributes(false)));
                int t = 0;
                while (t < addees.size()) {
                    MMAX2Attribute currentDependentAttribute = (MMAX2Attribute)addees.get(t);
                    if (!independentAttributesAsList.contains(currentDependentAttribute)) {
                        independentAttributesAsList.add(z + 1 + t, currentDependentAttribute);
                    }
                    ++t;
                }
            }
            ++z;
        }
        MMAX2Attribute[] result = independentAttributesAsList.toArray(new MMAX2Attribute[independentAttributesAsList.size()]);
        Iterator allAttributes = tempattribs.keySet().iterator();
        String extraAttributesMessage = "";
        while (allAttributes.hasNext()) {
            currentAttributeString = (String)allAttributes.next();
            MMAX2Attribute currentMMAX2Attribute = this.attributesByLowerCasedAttributeName.get(currentAttributeString);
            int currentAttributeType = -1;
            if (currentMMAX2Attribute != null) {
                currentAttributeType = currentMMAX2Attribute.getType();
            }
            if (tempattribs.get(currentAttributeString) == null) {
                markable.getAttributes().remove(currentAttributeString);
                continue;
            }
            if (((String)tempattribs.get(currentAttributeString)).equals("empty") && (currentAttributeType == 6 || currentAttributeType == 5)) {
                markable.getAttributes().remove(currentAttributeString);
                continue;
            }
            if (currentMMAX2Attribute != null) {
                if (!this.attributepanel.suppressCheck.isSelected()) {
                    String tempval = "";
                    tempval = markable.isDefined(currentAttributeString) ? " (" + markable.getAttributeValue(currentAttributeString) + ")" : " ()";
                    String message = "Attribute " + currentAttributeString + tempval + " on level " + markable.getMarkableLevelName() + " is not defined for \nthe current annotation status of this markable!";
                    message = String.valueOf(message) + "\nDetails:\nString: " + markable.toString() + "\nSpan: " + MarkableHelper.getSpan(markable) + "\nFile: " + markable.getMarkableLevel().getMarkableFileName();
                    message = String.valueOf(message) + "\n\nPress 'Remove' to remove the attribute permanently!";
                    message = String.valueOf(message) + "\nPress 'Keep' to leave markable unaltered!";
                    message = String.valueOf(message) + "\n\nUse 'suppress check' to suppress messages of this type in the future!";
                    int resultval = 0;
                    if (resultval != 1 && resultval != -1) {
                        MarkableRelation relation;
                        MarkableChart chart;
                        if (currentAttributeType == 5) {
                            chart = this.attributepanel.getContainer().getMMAX2().getCurrentDiscourse().getCurrentMarkableChart();
                            relation = currentMMAX2Attribute.getMarkableRelation();
                            MarkableSet setToLeave = relation.getMarkableSetWithAttributeValue(markable.getAttributeValue(currentAttributeString));
                            chart.removeMarkableFromMarkableSet(markable, setToLeave, false);
                            this.attributepanel.getContainer().getMMAX2().requestRefreshDisplay();
                            continue;
                        }
                        if (currentAttributeType == 6) {
                            chart = this.attributepanel.getContainer().getMMAX2().getCurrentDiscourse().getCurrentMarkableChart();
                            relation = currentMMAX2Attribute.getMarkableRelation();
                            chart.removeMarkablePointerWithSourceMarkable(markable, relation, false);
                            this.attributepanel.getContainer().getMMAX2().requestRefreshDisplay();
                            continue;
                        }
                        markable.getAttributes().remove(currentAttributeString);
                        continue;
                    }
                    this.attributepanel.keepables.add(currentAttributeString);
                    System.err.println("Preserving " + currentAttributeString + " in keepables. Size:" + this.attributepanel.keepables.size());
                    continue;
                }
                this.attributepanel.keepables.add(currentAttributeString);
                System.err.println("Preserving " + currentAttributeString + " in keepables. Size:" + this.attributepanel.keepables.size());
                continue;
            }
            if (currentAttributeString.equalsIgnoreCase("mmax_level") || currentAttributeString.equalsIgnoreCase("is_dominant")) continue;
            extraAttributesMessage = String.valueOf(extraAttributesMessage) + "\n" + currentAttributeString + " (" + (String)tempattribs.get(currentAttributeString) + ")";
        }
        if (!extraAttributesMessage.equals("") && this.attributepanel.warnOnExtraAttributes.isSelected()) {
            extraAttributesMessage = "The following undefined attributes were\nfound on the current Markable:\n" + extraAttributesMessage;
            JOptionPane.showMessageDialog(null, extraAttributesMessage, "MMAX2: Potential annotation inconsistency!", 2);
        }
        return result;
    }

    public boolean isDefined(String attributename) {
        return this.attributesByLowerCasedAttributeName.containsKey(attributename);
    }

    public int getAttributeTypeByAttributeName(String attribute) {
        int type = 0;
        if (attribute.equals("Markable")) {
            type = 3;
        } else if (attribute.equalsIgnoreCase("markable_text")) {
            type = MMAX2Constants.MARKABLE_TEXT;
        } else if (attribute.equalsIgnoreCase("base_level")) {
            type = MMAX2Constants.BASE_LEVEL;
        } else if (attribute.equalsIgnoreCase("level_name")) {
            type = MMAX2Constants.LEVEL_NAME;
        } else {
            MMAX2Attribute currentAttribute = this.attributesByLowerCasedAttributeName.get(attribute.toLowerCase());
            if (currentAttribute != null) {
                type = currentAttribute.getType();
            }
        }
        return type;
    }

    public List<String> getAllAttributeNames() {
        ArrayList<String> resultlist = new ArrayList<String>();
        Enumeration<String> allAttribs = this.attributesByLowerCasedAttributeName.keys();
        while (allAttribs.hasMoreElements()) {
            resultlist.add(allAttribs.nextElement());
        }
        return resultlist;
    }

    public final MMAX2AttributePanel getCurrentAttributePanel() {
        return this.attributepanel;
    }

    public final int getSize() {
        return this.size;
    }

    public final List<MMAX2Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public final MMAX2Attribute getAttributeByID(String id) {
        return this.attributesByID.get(id);
    }

    public final List<String> getAttributeNamesForValues(String valueList, String optionalAttributeName) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> allValues = new ArrayList<String>();
        valueList = valueList.substring(1, valueList.length() - 1);
        StringTokenizer toki = new StringTokenizer(valueList, ",");
        while (toki.hasMoreTokens()) {
            allValues.add(toki.nextToken());
        }
        String currentValue = "";
        int z = 0;
        while (z < this.attributes.size()) {
            MMAX2Attribute currentAttribute = this.attributes.get(z);
            if (currentAttribute.getType() != 3 || currentAttribute.getLowerCasedAttributeName().equalsIgnoreCase(optionalAttributeName)) {
                boolean currentDefined = true;
                int n = 0;
                while (n < allValues.size()) {
                    currentValue = (String)allValues.get(n);
                    if (!currentAttribute.isDefined(currentValue)) {
                        currentDefined = false;
                        break;
                    }
                    ++n;
                }
                if (currentDefined) {
                    if (currentAttribute.getType() != 3) {
                        if (!result.contains(currentAttribute.getLowerCasedAttributeName())) {
                            result.add(currentAttribute.getLowerCasedAttributeName());
                        }
                    } else if (!result.contains("*" + currentAttribute.getLowerCasedAttributeName())) {
                        result.add("*" + currentAttribute.getLowerCasedAttributeName());
                    }
                }
            }
            ++z;
        }
        return result;
    }

    public final void destroyDependentComponents() {
        this.attributesByID.clear();
        this.attributesByID = null;
        this.attributesByLowerCasedAttributeName.clear();
        this.attributesByLowerCasedAttributeName = null;
        int z = 0;
        while (z < this.attributes.size()) {
            this.attributes.get(z).destroy();
            ++z;
        }
        this.attributes.clear();
        this.attributes = null;
    }
}

