/*
 * Decompiled with CFR 0.152.
 */
package pl.waw.ipipan.zil.core.mmax4core.discourse;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.Markable;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.MarkableChart;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.MarkableLevel;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.comparator.AlphabeticMarkableComparator;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.comparator.DiscourseOrderMarkableComparator;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.comparator.EndingMarkableComparator;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.comparator.MarkableIDComparator;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.comparator.MarkableLevelPositionComparator;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.comparator.StartingMarkableComparator;
import pl.waw.ipipan.zil.core.mmax4core.api.DiscourseAPI;
import pl.waw.ipipan.zil.core.mmax4core.core.MMAX2;
import pl.waw.ipipan.zil.core.mmax4core.discourse.MMAX2DiscourseElement;
import pl.waw.ipipan.zil.core.mmax4core.gui.document.MMAX2Document;
import pl.waw.ipipan.zil.core.mmax4core.utils.MMAX2Constants;
import pl.waw.ipipan.zil.core.mmax4core.utils.MMAX2Utils;

public class MMAX2Discourse
implements DiscourseAPI {
    private static final Logger logger = Logger.getLogger(MMAX2Discourse.class);
    private String nameSpace = null;
    private HashMap<String, String> hash = null;
    private List<String> recentTextEntries = new ArrayList<String>();
    private List<String> recentAttributeEntries = new ArrayList<String>();
    private String commonBasedataPath = "";
    protected DocumentImpl wordDOM = null;
    protected String wordFileName = "";
    protected String[] styleSheetFileNames;
    protected String currentStyleSheet;
    protected String[] discourseElementAtPosition = null;
    protected List<String> temporaryDiscourseElementAtPosition = null;
    protected Map<String, Integer> discoursePositionOfDiscourseElement = new HashMap<String, Integer>();
    protected Integer[] displayStartPosition = null;
    protected List<Integer> temporaryDisplayStartPosition = null;
    protected Integer[] displayEndPosition = null;
    protected List<Integer> temporaryDisplayEndPosition = null;
    protected StringWriter incrementalTransformationResult = null;
    protected int lastStart = 0;
    protected MarkableChart chart = new MarkableChart(this);
    protected Map<Integer, Markable> markableDisplayAssociation = null;
    protected Map<Integer, String> hotSpotDisplayAssociation = null;
    public static StartingMarkableComparator STARTCOMP = null;
    public static EndingMarkableComparator ENDCOMP = null;
    public static AlphabeticMarkableComparator ALPHACOMP = null;
    public static DiscourseOrderMarkableComparator DISCOURSEORDERCOMP = null;
    public static MarkableLevelPositionComparator LEVELCOMP = null;
    public static MarkableIDComparator IDCOMP = null;
    protected MMAX2 mmax2 = null;

    public MMAX2Discourse() {
        this.temporaryDisplayStartPosition = new ArrayList<Integer>();
        this.temporaryDisplayEndPosition = new ArrayList<Integer>();
        this.temporaryDiscourseElementAtPosition = new ArrayList<String>();
        this.markableDisplayAssociation = new HashMap<Integer, Markable>();
        this.hotSpotDisplayAssociation = new HashMap<Integer, String>();
        STARTCOMP = new StartingMarkableComparator();
        ENDCOMP = new EndingMarkableComparator();
        ALPHACOMP = new AlphabeticMarkableComparator();
        DISCOURSEORDERCOMP = new DiscourseOrderMarkableComparator();
        LEVELCOMP = new MarkableLevelPositionComparator();
        IDCOMP = new MarkableIDComparator();
    }

    @Override
    public MMAX2Discourse _buildDiscourse(String infile, String commonPathsFile) {
        logger.warn("Warning: This is a dummy implementation only. Use the *static* method\n\tMMAX2Discourse buildDiscourse(String infile,String commonPathsFile)!");
        return null;
    }

    public final void setNameSpace(String _nameSpace) {
        this.nameSpace = _nameSpace;
    }

    public final String getNameSpace() {
        return this.nameSpace;
    }

    public final void setWordFileName(String name) {
        this.wordFileName = name;
    }

    public final String getWordFileName() {
        return this.wordFileName;
    }

    public final void addWithID(String id, Element node) {
        this.wordDOM.putIdentifier(id, node);
    }

    public final void destroyDependentComponents() {
        this.discoursePositionOfDiscourseElement.clear();
        this.discoursePositionOfDiscourseElement = null;
        this.discoursePositionOfDiscourseElement = new HashMap<String, Integer>();
        this.chart = null;
        this.temporaryDisplayStartPosition = null;
        this.temporaryDisplayEndPosition = null;
        this.temporaryDiscourseElementAtPosition = null;
        this.markableDisplayAssociation.clear();
        this.markableDisplayAssociation = null;
        this.hotSpotDisplayAssociation.clear();
        this.hotSpotDisplayAssociation = null;
        STARTCOMP = null;
        ENDCOMP = null;
        DISCOURSEORDERCOMP = null;
        LEVELCOMP = null;
        this.wordDOM = null;
        this.hash = null;
        System.gc();
    }

    public final MMAX2Document getDisplayDocument() {
        return this.mmax2.getCurrentDocument();
    }

    public final void setMMAX2(MMAX2 _mmax2) {
        this.mmax2 = _mmax2;
    }

    public final MMAX2 getMMAX2() {
        return this.mmax2;
    }

    public final Integer[] getAllDisplayAssociations() {
        if (this.markableDisplayAssociation.size() != 0) {
            return this.markableDisplayAssociation.keySet().toArray(new Integer[1]);
        }
        return null;
    }

    public final Markable getMarkableAtDisplayAssociation(int displayPosition) {
        Markable result = this.markableDisplayAssociation.get(new Integer(displayPosition));
        return result;
    }

    public final String getHotSpotAtDisplayAssociation(int displayPosition) {
        String result = this.hotSpotDisplayAssociation.get(displayPosition);
        return result;
    }

    public final Integer[] removeDisplayAssociationsForMarkable(Markable removee) {
        Set<Map.Entry<Integer, Markable>> all = this.markableDisplayAssociation.entrySet();
        Iterator<Map.Entry<Integer, Markable>> it = all.iterator();
        ArrayList<Integer> positions = new ArrayList<Integer>();
        Integer currentPos = null;
        boolean added = false;
        while (it.hasNext()) {
            Map.Entry<Integer, Markable> current = it.next();
            if (!current.getValue().equals(removee)) continue;
            it.remove();
            currentPos = current.getKey();
            if (positions.size() == 0) {
                positions.add(currentPos);
            } else {
                int p = 0;
                while (p < positions.size()) {
                    if ((Integer)positions.get(p) > currentPos) {
                        positions.add(p, currentPos);
                        added = true;
                        break;
                    }
                    ++p;
                }
            }
            if (added) continue;
            positions.add(currentPos);
        }
        return positions.toArray(new Integer[0]);
    }

    public final DocumentImpl getWordDOM() {
        return this.wordDOM;
    }

    @Override
    public final int getDisplayStartPositionFromDiscoursePosition(int discoursePosition) {
        int result = -1;
        try {
            result = this.displayStartPosition[discoursePosition];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @Override
    public final int getDisplayEndPositionFromDiscoursePosition(int discoursePosition) {
        int result = -1;
        try {
            result = this.displayEndPosition[discoursePosition];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @Override
    public final int getDiscoursePositionAtDisplayPosition(int _displayPosition) {
        int DiscPos = -1;
        int startPos = 0;
        int endPos = 0;
        Integer displayPosition = new Integer(_displayPosition);
        startPos = Arrays.binarySearch((Object[])this.displayStartPosition, displayPosition);
        if (startPos >= 0 && startPos < this.displayStartPosition.length) {
            try {
                if (this.displayStartPosition[startPos].equals(displayPosition)) {
                    return startPos;
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                ex.printStackTrace();
            }
        }
        if ((endPos = Arrays.binarySearch((Object[])this.displayEndPosition, displayPosition)) >= 0 && endPos < this.displayEndPosition.length) {
            try {
                if (this.displayEndPosition[endPos].equals(displayPosition)) {
                    return endPos;
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                ex.printStackTrace();
            }
        }
        if (startPos == endPos) {
            return DiscPos;
        }
        return endPos * -1 - 1;
    }

    @Override
    public final MMAX2DiscourseElement getDiscourseElementByID(String id) {
        MMAX2DiscourseElement result = null;
        Node temp = this.getDiscourseElementNode(id);
        if (temp != null) {
            result = new MMAX2DiscourseElement(temp.getFirstChild().getNodeValue(), temp.getAttributes().getNamedItem("id").getNodeValue(), this.getDiscoursePositionFromDiscourseElementID(temp.getAttributes().getNamedItem("id").getNodeValue()), MMAX2Utils.convertNodeMapToHashMap(temp.getAttributes()));
        }
        return result;
    }

    public final String getDEStringById(String id) {
        Node temp = this.getDiscourseElementNode(id);
        if (temp != null) {
            return temp.getFirstChild().getNodeValue();
        }
        return null;
    }

    public final int getDiscoursePositionFromDiscourseElementID(String id) {
        int result = -1;
        try {
            return this.discoursePositionOfDiscourseElement.get(id);
        }
        catch (NullPointerException ex) {
            System.err.println("No disc pos for " + id);
            return result;
        }
    }

    public final String getDiscourseElementIDAtDiscoursePosition(int pos) {
        String result = "";
        if (pos != -1) {
            try {
                result = this.discourseElementAtPosition[pos];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return result;
    }

    public final void registerAllDiscourseElements() {
        NodeList allWords = this.wordDOM.getElementsByTagName("word");
        int z = 0;
        while (z < allWords.getLength()) {
            this.registerDiscourseElement(allWords.item(z).getAttributes().getNamedItem("id").getNodeValue());
            ++z;
        }
    }

    public final void registerDiscourseElement(String id) {
        if (this.discoursePositionOfDiscourseElement == null) {
            this.discoursePositionOfDiscourseElement = new HashMap<String, Integer>();
        }
        if (this.temporaryDiscourseElementAtPosition == null) {
            this.temporaryDiscourseElementAtPosition = new ArrayList<String>();
        }
        this.discoursePositionOfDiscourseElement.put(id, new Integer(this.temporaryDiscourseElementAtPosition.size()));
        this.temporaryDiscourseElementAtPosition.add(id);
    }

    @Override
    public final MMAX2DiscourseElement[] getDiscourseElements() {
        ArrayList<MMAX2DiscourseElement> result = new ArrayList<MMAX2DiscourseElement>();
        int pos = 0;
        MMAX2DiscourseElement currentElement = null;
        while ((currentElement = this.getDiscourseElementAtDiscoursePosition(pos)) != null) {
            result.add(currentElement);
            currentElement = null;
            ++pos;
        }
        return result.toArray(new MMAX2DiscourseElement[0]);
    }

    @Override
    public final MMAX2DiscourseElement[] getDiscourseElements(Markable _markable) {
        ArrayList<MMAX2DiscourseElement> tempList = new ArrayList<MMAX2DiscourseElement>();
        String[] markablesDEIDs = _markable.getDiscourseElementIDs();
        int z = 0;
        while (z < markablesDEIDs.length) {
            Node temp = this.getDiscourseElementNode(markablesDEIDs[z]);
            tempList.add(new MMAX2DiscourseElement(temp.getFirstChild().getNodeValue(), temp.getAttributes().getNamedItem("id").getNodeValue(), this.getDiscoursePositionFromDiscourseElementID(temp.getAttributes().getNamedItem("id").getNodeValue()), MMAX2Utils.convertNodeMapToHashMap(temp.getAttributes())));
            ++z;
        }
        return tempList.toArray(new MMAX2DiscourseElement[0]);
    }

    @Override
    public final MMAX2DiscourseElement getDiscourseElementAtDiscoursePosition(int discPos) {
        MMAX2DiscourseElement result = null;
        String id = this.getDiscourseElementIDAtDiscoursePosition(discPos);
        Node temp = this.getDiscourseElementNode(id);
        if (temp != null) {
            result = new MMAX2DiscourseElement(temp.getFirstChild().getNodeValue(), temp.getAttributes().getNamedItem("id").getNodeValue(), this.getDiscoursePositionFromDiscourseElementID(temp.getAttributes().getNamedItem("id").getNodeValue()), MMAX2Utils.convertNodeMapToHashMap(temp.getAttributes()));
        }
        return result;
    }

    @Override
    public final MMAX2DiscourseElement getNextDiscourseElement(MMAX2DiscourseElement element) {
        MMAX2DiscourseElement currentElement = null;
        int currentDiscPos = 0;
        if (element != null) {
            currentDiscPos = element.getDiscoursePosition() + 1;
        }
        currentElement = this.getDiscourseElementAtDiscoursePosition(currentDiscPos);
        return currentElement;
    }

    @Override
    public final MMAX2DiscourseElement getPreviousDiscourseElement(MMAX2DiscourseElement element) {
        MMAX2DiscourseElement currentElement = null;
        int currentDiscPos = this.getDiscourseElementCount();
        if (element != null) {
            currentDiscPos = element.getDiscoursePosition() - 1;
        }
        currentElement = this.getDiscourseElementAtDiscoursePosition(currentDiscPos);
        return currentElement;
    }

    public final Node getDiscourseElementNode(String ID) {
        Element result = null;
        try {
            result = this.wordDOM.getElementById(ID);
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    protected final void setWordDOM(DocumentImpl dom) {
        this.wordDOM = dom;
    }

    public final void resetForStyleSheetReapplication() {
        this.temporaryDiscourseElementAtPosition = new ArrayList<String>();
        this.temporaryDisplayEndPosition = new ArrayList<Integer>();
        this.temporaryDisplayStartPosition = new ArrayList<Integer>();
        this.lastStart = 0;
        this.markableDisplayAssociation.clear();
        this.markableDisplayAssociation = new HashMap<Integer, Markable>();
        this.hotSpotDisplayAssociation.clear();
        this.hotSpotDisplayAssociation = new HashMap<Integer, String>();
        this.hash = null;
        this.chart.resetMarkablesForStyleSheetReapplication();
        this.chart.resetHasHandles();
        System.gc();
    }

    public final void reapplyStyleSheet() {
        final Point scrollPosition = this.mmax2.getCurrentViewport().getViewPosition();
        this.mmax2.setCurrentDocument(new MMAX2Document(this.mmax2.getCurrentDocument(), this.mmax2));
        this.resetForStyleSheetReapplication();
        this.applyStyleSheet("");
        this.mmax2.getCurrentDocument().flush();
        this.chart.createDiscoursePositionToMarkableMappings();
        this.chart.setMarkableLevelDisplayPositions();
        this.chart.updateLabels();
        this.mmax2.getCurrentViewport().setVisible(false);
        this.mmax2.getCurrentTextPane().setStyledDocument(this.mmax2.getCurrentDocument());
        this.chart.initMarkableRelations();
        this.mmax2.requestRefreshDisplay();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MMAX2Discourse.this.mmax2.getCurrentViewport().setViewPosition(scrollPosition);
                if (MMAX2Discourse.this.mmax2.getCurrentPrimaryMarkable() != null) {
                    MMAX2Discourse.this.chart.markableLeftClicked(MMAX2Discourse.this.mmax2.getCurrentPrimaryMarkable());
                }
                MMAX2Discourse.this.mmax2.getCurrentViewport().setVisible(true);
            }
        });
    }

    public final void applyStyleSheet(String overrideStyleFileName) {
        String error;
        if (overrideStyleFileName.equals("")) {
            overrideStyleFileName = this.currentStyleSheet;
        }
        this.incrementalTransformationResult = new StringWriter();
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = tFactory.newTransformer(new StreamSource(new File(overrideStyleFileName).toURI().toASCIIString()));
        }
        catch (TransformerConfigurationException ex) {
            error = ex.toString();
            System.err.println(error);
            JOptionPane.showMessageDialog(null, error, "Discourse: " + overrideStyleFileName, 0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            transformer.transform(new DOMSource(this.wordDOM), new StreamResult(this.incrementalTransformationResult));
        }
        catch (TransformerException ex) {
            error = ex.toString();
            System.err.println(error);
            System.err.println(ex.getMessageAndLocation());
            JOptionPane.showMessageDialog(null, error, "Discourse: " + overrideStyleFileName, 0);
            ex.printStackTrace();
        }
        this.discourseElementAtPosition = this.temporaryDiscourseElementAtPosition.toArray(new String[1]);
        this.displayStartPosition = this.temporaryDisplayStartPosition.toArray(new Integer[1]);
        this.displayEndPosition = this.temporaryDisplayEndPosition.toArray(new Integer[1]);
        this.temporaryDiscourseElementAtPosition.clear();
        this.temporaryDisplayEndPosition.clear();
        this.temporaryDisplayStartPosition.clear();
        try {
            this.incrementalTransformationResult.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.gc();
    }

    public final void setCurrentStyleSheet(String name) {
        this.currentStyleSheet = name;
        try {
            this.mmax2.setReapplyBarToolTip(name);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public final String getCurrentStyleSheet() {
        return this.currentStyleSheet;
    }

    public final void setStyleSheetFileNames(String[] names) {
        this.styleSheetFileNames = names;
    }

    public final String[] getStyleSheetFileNames() {
        return this.styleSheetFileNames;
    }

    public final int getCurrentDocumentPosition() {
        this.incrementalTransformationResult.flush();
        return this.incrementalTransformationResult.getBuffer().length();
    }

    public final String getNextDocumentChunk() {
        this.incrementalTransformationResult.flush();
        String temp = this.incrementalTransformationResult.toString();
        String result = temp.substring(this.lastStart);
        this.lastStart = temp.length();
        return result;
    }

    public final MarkableLevel getMarkableLevelFromAbsoluteFileName(String absFileName) {
        MarkableLevel result = null;
        MarkableLevel[] levels = this.getCurrentMarkableChart().getMarkableLevels();
        int z = 0;
        while (z < levels.length) {
            if (levels[z].getAbsoluteMarkableFileName().equals(absFileName)) {
                result = levels[z];
                break;
            }
            ++z;
        }
        return result;
    }

    public final String getStyleSheetOutput() {
        this.incrementalTransformationResult.flush();
        return this.incrementalTransformationResult.toString();
    }

    public final void putInHash(String key, String value) {
        if (this.hash == null) {
            this.hash = new HashMap();
        }
        this.hash.put(key, value);
    }

    public final String getFromHash(String key) {
        String value = "";
        if (this.hash != null && (value = this.hash.get(key)) == null) {
            value = "";
        }
        return value;
    }

    @Override
    public final MarkableLevel getMarkableLevelByName(String name, boolean interactive) {
        return this.getCurrentMarkableChart().getMarkableLevelByName(name, interactive);
    }

    public final MarkableChart getCurrentMarkableChart() {
        return this.chart;
    }

    public final String[] getAllDiscourseElementIDs() {
        return this.discourseElementAtPosition;
    }

    @Override
    public final int getDiscourseElementCount() {
        return this.discourseElementAtPosition.length;
    }

    public final void performNonGUIInitializations() {
        this.getCurrentMarkableChart().createDiscoursePositionToMarkableMappings();
        this.getCurrentMarkableChart().setMarkableLevelDisplayPositions();
        this.getCurrentMarkableChart().initMarkableRelations();
        this.getCurrentMarkableChart().updateLabels();
    }

    public final void setCommonBasedataPath(String path) {
        this.commonBasedataPath = path;
    }

    public final String getCommonBasedataPath() {
        return this.commonBasedataPath;
    }

    public final void requestDeleteBasedataElement(Node deletee) {
        String deleteesID = deletee.getAttributes().getNamedItem("id").getNodeValue();
        List<Markable> startedMarkables = this.getCurrentMarkableChart().getAllStartedMarkables(deleteesID);
        List<Markable> endedMarkables = this.getCurrentMarkableChart().getAllEndedMarkables(deleteesID);
        ArrayList<Markable> entireMarkables = new ArrayList<Markable>();
        int b = startedMarkables.size() - 1;
        while (b >= 0) {
            if (endedMarkables.contains(startedMarkables.get(b))) {
                entireMarkables.add(startedMarkables.get(b));
                endedMarkables.remove(startedMarkables.get(b));
                startedMarkables.remove(b);
            }
            --b;
        }
        if (startedMarkables.size() > 0 || endedMarkables.size() > 0 || entireMarkables.size() > 0) {
            String message = "The base data element to be deleted is contained in the following markable(s):\n";
            if (entireMarkables.size() > 0) {
                message = String.valueOf(message) + "Completely:\n";
            }
            int z = 0;
            while (z < entireMarkables.size()) {
                message = String.valueOf(message) + ((Markable)entireMarkables.get(z)).toString() + "\n";
                ++z;
            }
            if (startedMarkables.size() > 0) {
                message = String.valueOf(message) + "As first element:\n";
            }
            z = 0;
            while (z < startedMarkables.size()) {
                message = String.valueOf(message) + startedMarkables.get(z).toString() + "\n";
                ++z;
            }
            if (endedMarkables.size() > 0) {
                message = String.valueOf(message) + "As last element:\n";
            }
            z = 0;
            while (z < endedMarkables.size()) {
                message = String.valueOf(message) + endedMarkables.get(z).toString() + "\n";
                ++z;
            }
            message = String.valueOf(message) + "\nPress 'OK' to delete anyway and adapt/delete these markables, or 'Cancel' to cancel deletion!";
            int choice = JOptionPane.showConfirmDialog(this.getMMAX2(), message, "Confirm base data deletion", 2, 1);
            if (choice != 0) {
                return;
            }
            int z2 = 0;
            while (z2 < entireMarkables.size()) {
                ((Markable)entireMarkables.get(z2)).getMarkableLevel().setIsDirty(true, false);
                this.getCurrentMarkableChart().deleteMarkable((Markable)entireMarkables.get(z2));
                ++z2;
            }
            String[] deleteeArray = new String[]{deleteesID};
            int z3 = 0;
            while (z3 < startedMarkables.size()) {
                startedMarkables.get(z3).getMarkableLevel().setIsDirty(true, false);
                startedMarkables.get(z3).getMarkableLevel().unregisterMarkable(startedMarkables.get(z3));
                startedMarkables.get(z3).removeDiscourseElements(deleteeArray);
                ++z3;
            }
            z3 = 0;
            while (z3 < endedMarkables.size()) {
                endedMarkables.get(z3).getMarkableLevel().setIsDirty(true, false);
                endedMarkables.get(z3).getMarkableLevel().unregisterMarkable(endedMarkables.get(z3));
                endedMarkables.get(z3).removeDiscourseElements(deleteeArray);
                ++z3;
            }
        }
        deletee.getParentNode().removeChild(deletee);
        this.getCurrentMarkableChart().updateAllMarkableLevels();
        this.mmax2.requestReapplyDisplay();
        this.getCurrentMarkableChart().createDiscoursePositionToMarkableMappings();
        this.mmax2.requestRefreshDisplay();
        this.mmax2.setIsBasedataModified(true, true);
    }

    public final void showEditBasedataElementWindow(List<String> recentTextEntries2, List<String> recentAttributeEntries2, final Node referenceNode, final int mode) {
        if (this.mmax2.editBasedataWindow != null) {
            this.mmax2.editBasedataWindow.setVisible(false);
            this.mmax2.editBasedataWindow = null;
        }
        this.mmax2.editBasedataWindow = new JFrame("Edit base data");
        this.mmax2.editBasedataWindow.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public final void windowGainedFocus(WindowEvent we) {
            }

            @Override
            public final void windowLostFocus(WindowEvent we) {
                if (MMAX2Discourse.this.mmax2.editBasedataWindow != null) {
                    MMAX2Discourse.this.mmax2.editBasedataWindow.toFront();
                }
            }
        });
        this.mmax2.editBasedataWindow.setResizable(false);
        this.mmax2.editBasedataWindow.setDefaultCloseOperation(0);
        Box outerBox = Box.createVerticalBox();
        Box upperBox = Box.createVerticalBox();
        final JComboBox<String> recentTextsBox = new JComboBox<String>(recentTextEntries2.toArray(new String[0]));
        upperBox.add(recentTextsBox);
        upperBox.add(Box.createVerticalStrut(10));
        final JTextField textField = new JTextField("", 20);
        if (mode == MMAX2Constants.EDIT_DE) {
            textField.setText(referenceNode.getChildNodes().item(0).getNodeValue());
        }
        upperBox.add(textField);
        Box middleBox = Box.createVerticalBox();
        final JComboBox<String> recentAttributesBox = new JComboBox<String>(recentAttributeEntries2.toArray(new String[0]));
        middleBox.add(recentAttributesBox);
        middleBox.add(Box.createVerticalStrut(10));
        final JTextField attributeField = new JTextField("", 20);
        if (mode == MMAX2Constants.EDIT_DE) {
            attributeField.setText(MMAX2Utils.toAttributeString(referenceNode.getAttributes(), true));
        }
        middleBox.add(attributeField);
        recentTextsBox.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent ae) {
                textField.setText((String)recentTextsBox.getSelectedItem());
            }
        });
        recentAttributesBox.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent ae) {
                attributeField.setText((String)recentAttributesBox.getSelectedItem());
            }
        });
        Box bottomBox = Box.createHorizontalBox();
        JButton okButton = new JButton("OK");
        okButton.setFont(okButton.getFont().deriveFont(12.0f));
        okButton.setBorder(new EmptyBorder(0, 0, 1, 1));
        bottomBox.add(okButton);
        bottomBox.add(Box.createHorizontalStrut(10));
        okButton.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent ae) {
                MMAX2Discourse.this.mmax2.editBasedataWindow.setVisible(false);
                MMAX2Discourse.this.mmax2.editBasedataWindow = null;
                MMAX2Discourse.this.mmax2.setBlockAllInput(false);
                MMAX2Discourse.this.basedataTextAndAttributeSelected(referenceNode, mode, textField.getText().trim(), attributeField.getText().trim());
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setFont(cancelButton.getFont().deriveFont(12.0f));
        cancelButton.setBorder(new EmptyBorder(0, 0, 1, 1));
        bottomBox.add(cancelButton);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent ae) {
                MMAX2Discourse.this.mmax2.editBasedataWindow.setVisible(false);
                MMAX2Discourse.this.mmax2.editBasedataWindow = null;
                MMAX2Discourse.this.mmax2.setBlockAllInput(false);
                MMAX2Discourse.this.basedataTextAndAttributeSelected(referenceNode, MMAX2Constants.BASEDATA_EDIT_CANCEL, "", "");
            }
        });
        JPanel wordPanel = new JPanel();
        wordPanel.setBorder(new TitledBorder("Enter element text (required)"));
        wordPanel.add(upperBox);
        outerBox.add(wordPanel);
        JPanel attributePanel = new JPanel();
        attributePanel.setBorder(new TitledBorder("Enter element attributes (optional)"));
        attributePanel.add(middleBox);
        outerBox.add(attributePanel);
        JPanel controlPanel = new JPanel();
        controlPanel.add(bottomBox);
        outerBox.add(controlPanel);
        this.mmax2.editBasedataWindow.getContentPane().add(outerBox);
        this.mmax2.editBasedataWindow.pack();
        this.mmax2.editBasedataWindow.setLocationRelativeTo(this.getMMAX2());
        this.mmax2.setBlockAllInput(true);
        this.mmax2.editBasedataWindow.setVisible(true);
    }

    public final void basedataTextAndAttributeSelected(Node referenceNode, int mode, String text, String attribute) {
        block14: {
            List<String> attributesAsList;
            block12: {
                String newID;
                Element newWord;
                block13: {
                    if (mode == MMAX2Constants.BASEDATA_EDIT_CANCEL) {
                        return;
                    }
                    if (!this.recentTextEntries.contains(text) && !text.equals("")) {
                        this.recentTextEntries.add(text);
                    }
                    if (!this.recentAttributeEntries.contains(attribute) && !attribute.equals("")) {
                        this.recentAttributeEntries.add(attribute);
                    }
                    attributesAsList = MMAX2Utils.toAttributeList(attribute);
                    if (mode != MMAX2Constants.INSERT_DE_BEFORE && mode != MMAX2Constants.INSERT_DE_AFTER) break block12;
                    newWord = referenceNode.getParentNode().getOwnerDocument().createElement("word");
                    newWord.appendChild(referenceNode.getParentNode().getOwnerDocument().createTextNode(text));
                    int z = 0;
                    while (z < attributesAsList.size()) {
                        String currentEntry = attributesAsList.get(z);
                        newWord.setAttribute(currentEntry.substring(0, currentEntry.indexOf("=")), currentEntry.substring(currentEntry.indexOf("=") + 1));
                        ++z;
                    }
                    newID = "";
                    if (mode != MMAX2Constants.INSERT_DE_BEFORE) break block13;
                    Node leftReferenceNode = referenceNode.getPreviousSibling();
                    while (leftReferenceNode != null && leftReferenceNode.getNodeType() != 1) {
                        leftReferenceNode = leftReferenceNode.getPreviousSibling();
                    }
                    newID = this.createBasedataID(leftReferenceNode, referenceNode);
                    if (!newID.equals("")) {
                        newWord.setAttribute("id", newID);
                        referenceNode.getParentNode().insertBefore(newWord, referenceNode);
                        this.mmax2.getCurrentDiscourse().addWithID(newID, newWord);
                    }
                    break block14;
                }
                if (mode != MMAX2Constants.INSERT_DE_AFTER) break block14;
                Node rightReferenceNode = referenceNode.getNextSibling();
                while (rightReferenceNode != null && rightReferenceNode.getNodeType() != 1) {
                    rightReferenceNode = rightReferenceNode.getNextSibling();
                }
                newID = this.createBasedataID(referenceNode, rightReferenceNode);
                if (newID.equals("")) break block14;
                newWord.setAttribute("id", newID);
                referenceNode.getParentNode().insertBefore(newWord, rightReferenceNode);
                this.mmax2.getCurrentDiscourse().addWithID(newID, newWord);
                break block14;
            }
            if (mode == MMAX2Constants.EDIT_DE) {
                referenceNode.removeChild(referenceNode.getFirstChild());
                referenceNode.appendChild(referenceNode.getParentNode().getOwnerDocument().createTextNode(text));
                NamedNodeMap attribs = referenceNode.getAttributes();
                int z = attribs.getLength() - 1;
                while (z >= 0) {
                    if (!attribs.item(z).getNodeName().equalsIgnoreCase("id")) {
                        attribs.removeNamedItem(attribs.item(z).getNodeName());
                    }
                    --z;
                }
                z = 0;
                while (z < attributesAsList.size()) {
                    String currentEntry = attributesAsList.get(z);
                    ((Element)referenceNode).setAttribute(currentEntry.substring(0, currentEntry.indexOf("=")), currentEntry.substring(currentEntry.indexOf("=") + 1));
                    ++z;
                }
            }
        }
        if (this.mmax2.getIsAutoReapplyEnabled()) {
            System.err.println("Auto-reapplying ...");
            this.mmax2.requestReapplyDisplay();
        }
        this.getCurrentMarkableChart().updateAllMarkableLevels();
        this.mmax2.requestReapplyDisplay();
        this.getCurrentMarkableChart().createDiscoursePositionToMarkableMappings();
        this.mmax2.requestRefreshDisplay();
        this.mmax2.setIsBasedataModified(true, true);
    }

    private final String createBasedataID(Node leftNeighbour, Node rightNeighbour) {
        String leftID = "";
        String rightID = "";
        String commonElementNameSpace = "";
        String newID = "";
        BigDecimal leftNumber = new BigDecimal("0.00000000000000000000");
        BigDecimal rightNumber = new BigDecimal("0.00000000000000000000");
        BigDecimal difference = new BigDecimal("0.00000000000000000000");
        if (leftNeighbour != null && rightNeighbour != null) {
            leftID = leftNeighbour.getAttributes().getNamedItem("id").getNodeValue();
            rightID = rightNeighbour.getAttributes().getNamedItem("id").getNodeValue();
            commonElementNameSpace = leftID.substring(0, leftID.indexOf("_"));
            if (!commonElementNameSpace.equalsIgnoreCase(rightID.substring(0, rightID.indexOf("_")))) {
                System.err.println("Error: Different base data element name spaces!");
                return null;
            }
            leftNumber = new BigDecimal(leftID.substring(leftID.indexOf("_") + 1));
            rightNumber = new BigDecimal(rightID.substring(rightID.indexOf("_") + 1));
            difference = rightNumber.subtract(leftNumber);
            difference = difference.divide(new BigDecimal("2.00000000000000000000"));
            newID = String.valueOf(commonElementNameSpace) + "_" + leftNumber.add(difference);
        } else if (leftNeighbour == null) {
            rightID = rightNeighbour.getAttributes().getNamedItem("id").getNodeValue();
            rightNumber = new BigDecimal(rightID.substring(rightID.indexOf("_") + 1));
            difference = rightNumber.divide(new BigDecimal("2.00000000000000000000"));
            commonElementNameSpace = rightID.substring(0, rightID.indexOf("_"));
            newID = String.valueOf(commonElementNameSpace) + "_" + difference;
        } else {
            leftID = leftNeighbour.getAttributes().getNamedItem("id").getNodeValue();
            leftNumber = new BigDecimal(leftID.substring(leftID.indexOf("_") + 1));
            difference = leftNumber.add(new BigDecimal("1.00000000000000000000"));
            commonElementNameSpace = leftID.substring(0, leftID.indexOf("_"));
            newID = String.valueOf(commonElementNameSpace) + "_" + difference;
        }
        if (newID.endsWith(".0")) {
            newID = newID.substring(0, newID.length() - 2);
        }
        System.err.println("newId " + newID);
        return newID;
    }

    public final void requestAddBasedataElement(Node referenceNode, int mode) {
        this.showEditBasedataElementWindow(this.recentTextEntries, this.recentAttributeEntries, referenceNode, mode);
    }

    public final void saveBasedata(String newFileName) {
        File destinationFile;
        if (this.mmax2 != null && !this.mmax2.getIsBasedataModified()) {
            logger.debug("Basedata is clean, not saving!");
            return;
        }
        System.err.println("Saving basedata ... ");
        if (!newFileName.equals("")) {
            this.wordFileName = newFileName;
        }
        if ((destinationFile = new File(this.wordFileName)).exists()) {
            System.err.println("Filename " + destinationFile.getAbsolutePath() + " exists, creating backup (.bak) file!");
            File oldDestinationFile = new File(String.valueOf(this.wordFileName) + ".bak");
            if (oldDestinationFile.exists()) {
                System.err.println("Removing old .bak file!");
                oldDestinationFile.delete();
                oldDestinationFile = new File(String.valueOf(this.wordFileName) + ".bak");
            }
            destinationFile.renameTo(oldDestinationFile);
        }
        System.out.println("Writing to file " + this.wordFileName);
        BufferedWriter fw = null;
        try {
            fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.wordFileName), "UTF-8"));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        String dtdReference = "";
        if (this.wordDOM.getDoctype().getPublicId() != null) {
            dtdReference = "<!DOCTYPE words PUBLIC \"" + this.wordDOM.getDoctype().getPublicId() + "\">";
        } else if (this.wordDOM.getDoctype().getSystemId() != null) {
            dtdReference = "<!DOCTYPE words SYSTEM \"" + this.wordDOM.getDoctype().getSystemId() + "\">";
        }
        String encoding = this.wordDOM.getEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        String wordFileHeader = "<?xml version='1.0' encoding='" + encoding + "'?>";
        try {
            fw.write(String.valueOf(wordFileHeader) + "\n" + dtdReference + "\n<words>\n");
            fw.flush();
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
        Node currentWordNode = this.wordDOM.getChildNodes().item(1).getFirstChild();
        String currentAttributes = "";
        while (currentWordNode != null) {
            String id = currentWordNode.getAttributes().getNamedItem("id").getNodeValue();
            currentAttributes = MMAX2Utils.toAttributeString(this.getDiscourseElementByID(id).getAttributes(), false);
            try {
                fw.write("<word " + currentAttributes.trim() + ">");
                Node childNode = currentWordNode.getFirstChild();
                String childText = childNode.getNodeValue();
                if (childText.equals("&")) {
                    childText = "&amp;";
                } else if (childText.equals(">")) {
                    childText = "&gt;";
                } else if (childText.equals("<")) {
                    childText = "&lt;";
                } else if (childText.equals("\"")) {
                    childText = "&quot;";
                } else if (childText.equals("'")) {
                    childText = "&apos;";
                }
                fw.write(childText);
                fw.write("</word>\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            currentWordNode = currentWordNode.getNextSibling();
        }
        try {
            fw.write("</words>");
            fw.flush();
            fw.close();
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
        if (this.mmax2 != null) {
            this.getMMAX2().setIsBasedataModified(false, false);
        }
    }
}

