/*
 * Decompiled with CFR 0.152.
 */
package pl.waw.ipipan.zil.core.mmax4core.gui.display;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.Markable;
import pl.waw.ipipan.zil.core.mmax4core.discourse.MMAX2Discourse;
import pl.waw.ipipan.zil.core.mmax4core.utils.MMAX2Constants;

public class MMAX2MarkableSelector
extends JPopupMenu {
    private static final long serialVersionUID = 5214833190454729468L;
    private final int maxStringWidth = 80;
    private int size = 0;
    private Markable onlyMarkable = null;
    private Markable bestMarkable;

    public MMAX2MarkableSelector(Markable[][] markables, MMAX2Discourse _discourse, boolean groupByLevel, final int button) {
        JMenuItem item = null;
        Markable[] tempResult = null;
        final MMAX2Discourse currentDiscourse = _discourse;
        if (!groupByLevel) {
            int p = 0;
            while (p < markables.length) {
                tempResult = markables[p];
                this.size += tempResult.length;
                int q = 0;
                while (q < tempResult.length) {
                    final Markable current = tempResult[q];
                    this.onlyMarkable = tempResult[q];
                    String entry = tempResult[q].toTrimmedString(80);
                    String prefix = this.getMarkableSelectorPrefix(current, currentDiscourse);
                    String levelName = _discourse.getCurrentMarkableChart().getLevelNameByOrderPosition(p).trim();
                    entry = prefix.equals("") ? String.valueOf(levelName) + " : " + entry : String.valueOf(levelName) + " : " + prefix + " " + entry;
                    item = new JMenuItem(entry);
                    item.addActionListener(new ActionListener(){

                        @Override
                        public final void actionPerformed(ActionEvent ae) {
                            if (button == MMAX2Constants.LEFTMOUSE) {
                                currentDiscourse.getCurrentMarkableChart().markableLeftClicked(current);
                            } else if (button == MMAX2Constants.RIGHTMOUSE) {
                                currentDiscourse.getCurrentMarkableChart().markableRightClicked(current);
                            }
                        }
                    });
                    this.add(item);
                    item = null;
                    ++q;
                }
                ++p;
            }
        } else {
            JMenu levelMenu = null;
            int p = 0;
            while (p < markables.length) {
                tempResult = markables[p];
                this.size += tempResult.length;
                levelMenu = new JMenu(_discourse.getCurrentMarkableChart().getLevelNameByOrderPosition(p));
                this.add(levelMenu);
                if (tempResult.length == 0) {
                    levelMenu.setEnabled(false);
                }
                int q = 0;
                while (q < tempResult.length) {
                    final Markable current = tempResult[q];
                    this.onlyMarkable = tempResult[q];
                    String entry = tempResult[q].toTrimmedString(80);
                    String prefix = this.getMarkableSelectorPrefix(current, currentDiscourse);
                    if (!prefix.equals("")) {
                        entry = String.valueOf(prefix) + " " + entry;
                    }
                    item = new JMenuItem(entry);
                    item.addActionListener(new ActionListener(){

                        @Override
                        public final void actionPerformed(ActionEvent ae) {
                            if (button == MMAX2Constants.LEFTMOUSE) {
                                currentDiscourse.getCurrentMarkableChart().markableLeftClicked(current);
                            } else if (button == MMAX2Constants.RIGHTMOUSE) {
                                currentDiscourse.getCurrentMarkableChart().markableRightClicked(current);
                            }
                        }
                    });
                    levelMenu.add(item);
                    item = null;
                    ++q;
                }
                levelMenu = null;
                ++p;
            }
        }
        this.setVisible(true);
        this.setVisible(false);
        if (markables.length == 1) {
            this.bestMarkable = MMAX2MarkableSelector.getBestMarkable(markables[0]);
        }
    }

    public static Markable getBestMarkable(Markable[] marks) {
        Markable best = null;
        int min = Integer.MAX_VALUE;
        int q = 0;
        while (q < marks.length) {
            Markable current = marks[q];
            int len = current.getDiscourseElements().length;
            if (len < min) {
                best = current;
                min = len;
            }
            ++q;
        }
        return best;
    }

    private final String getMarkableSelectorPrefix(Markable _current, MMAX2Discourse _discourse) {
        String prefix = "";
        String attributeToShow = _discourse.getMMAX2().getShowInMarkableSelectorAttribute(_current.getMarkableLevelName());
        if (!attributeToShow.equals("")) {
            prefix = String.valueOf(attributeToShow) + "=" + _current.getAttributeValue(attributeToShow, "");
        }
        return prefix;
    }

    public final Markable getOnlyMarkable() {
        return this.onlyMarkable;
    }

    public final int getItemCount() {
        return this.size;
    }

    public Markable getBestMarkable() {
        return this.bestMarkable;
    }
}

