/*
 * Decompiled with CFR 0.152.
 */
package pl.waw.ipipan.zil.core.mmax4core.plugin;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;
import pl.waw.ipipan.zil.core.mmax4core.Messages;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.Markable;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.MarkableFileLoader;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.MarkableHelper;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.MarkableLevel;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.MarkablePointer;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.MarkableRelation;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.MarkableSet;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.comparator.other.MarkableSpanComparator;
import pl.waw.ipipan.zil.core.mmax4core.annotation.scheme.MMAX2Attribute;
import pl.waw.ipipan.zil.core.mmax4core.core.MMAX2;
import pl.waw.ipipan.zil.core.mmax4core.discourse.MMAX2Discourse;
import pl.waw.ipipan.zil.core.mmax4core.plugin.MMAX2Plugin;
import pl.waw.ipipan.zil.core.mmax4core.plugin.SimpleMultiLineCellRenderer;
import pl.waw.ipipan.zil.core.mmax4core.plugin.SuperannotationListener;
import pl.waw.ipipan.zil.core.mmax4core.plugin.SuperannotationMenu;
import pl.waw.ipipan.zil.core.mmax4core.utils.MMAX2Constants;

public class SuperannotationPluginWindow
extends MMAX2Plugin {
    private static final String STRING_COLUMN_HEADER = Messages.getString("SuperannotationPluginWindow.mention");
    public static final String NO_MARKABLE = Messages.getString("SuperannotationPluginWindow.no_mention");
    public static final String NO_VALUE = Messages.getString("SuperannotationPluginWindow.empty");
    private static final long serialVersionUID = 3574674289514519098L;
    private static Logger logger = Logger.getLogger(SuperannotationPluginWindow.class);
    private MMAX2 mmax2 = null;
    private MMAX2Discourse discourse = null;
    private MarkableLevel majorLevel = null;
    private MarkableLevel minorLevel = null;
    private String majorLevelName = "";
    private String majorLevelLocalizedName = "";
    private String majorLevelSchemeFileName = "";
    private String majorLevelCustomizationFileName = "";
    private String currentAttributeName = "no_attribute";
    private String currentAttributeType = "no_attribute";
    private JTable table = null;
    private String[][] tableData = null;
    private JScrollPane tablePane = null;
    private int[] columnWidths = new int[]{300, 100, 100};
    private List<Map<String, String>> spanToIDMappingsForAllLevels = null;
    public static int IDENTITY = 0;
    public static int A_SUBSUMES_B = 1;
    public static int B_SUBSUMES_A = 2;
    public static int INTERSECTION = 3;
    public static int DISJUNCTION = 4;
    public static int STRING_COLUMN = 1;
    public static int MAJOR_COLUMN = 2;
    public static int MINOR_COLUMN = 3;
    private SuperannotationListener listener;
    private SuperannotationMenu menu;

    public SuperannotationPluginWindow() {
    }

    public SuperannotationPluginWindow(MMAX2Discourse _discourse) {
        logger.info("Starting " + SuperannotationPluginWindow.class.getSimpleName() + ".");
        this.setTitle(Messages.getString("SuperannotationPluginWindow.Supeannotation_Window"));
        this.discourse = _discourse;
        this.mmax2 = this.discourse.getMMAX2();
        this.listener = new SuperannotationListener(this);
        this.menu = new SuperannotationMenu(this.listener);
        this.setJMenuBar(this.menu);
        this.tableData = new String[1][1];
        this.tableData[0][0] = "";
        Object[] header = new String[]{"SPAN", STRING_COLUMN_HEADER};
        DefaultTableModel dm = new DefaultTableModel();
        dm.setDataVector(this.tableData, header);
        this.table = new JTable(dm){
            private static final long serialVersionUID = 480808351088028798L;

            @Override
            public boolean isCellEditable(int x, int y) {
                return false;
            }
        };
        this.table.setCellSelectionEnabled(true);
        this.table.setSelectionMode(0);
        this.addWindowListener(this.listener);
        this.table.addMouseListener(this.listener);
        this.table.addKeyListener(this.listener);
        this.table.getTableHeader().addMouseListener(this.listener);
        this.table.getSelectionModel().addListSelectionListener(this.listener);
        this.tablePane = new JScrollPane(this.table);
        Box upperPanelBox = Box.createVerticalBox();
        upperPanelBox.add(this.tablePane);
        upperPanelBox.add(Box.createVerticalStrut(5));
        Box lowerBox = Box.createHorizontalBox();
        JButton refreshButton = new JButton(Messages.getString("SuperannotationPluginWindow.Refresh"));
        refreshButton.setActionCommand("refresh");
        refreshButton.addActionListener(this.listener);
        lowerBox.add(refreshButton);
        JButton copyChanges = new JButton(Messages.getString("SuperannotationPluginWindow.Accept_visible_version"));
        copyChanges.setActionCommand("sync");
        copyChanges.addActionListener(this.listener);
        lowerBox.add(copyChanges);
        upperPanelBox.add(lowerBox);
        upperPanelBox.add(Box.createVerticalStrut(5));
        this.getContentPane().add(upperPanelBox);
        this.loadLevels();
        this.pack();
        this.setVisible(true);
        _discourse.getMMAX2().addRunningPlugin(this);
    }

    private void loadLevels() {
        MarkableLevel[] baseLevels = this.mmax2.getCurrentDiscourse().getCurrentMarkableChart().getMarkableLevels();
        this.majorLevel = baseLevels[0];
        this.majorLevelName = this.majorLevel.getMarkableLevelName();
        this.majorLevelSchemeFileName = this.majorLevel.getCurrentAnnotationScheme().getSchemeFileName();
        this.majorLevelCustomizationFileName = this.majorLevel.getCustomizationFileName();
        this.majorLevelLocalizedName = this.majorLevel.getMarkableLevelLocalizedName();
        boolean baseA = this.mmax2.currentMmaxFilename.startsWith("A");
        String requestedFileName = baseA ? "B_mentions.xml" : "A_mentions.xml";
        requestedFileName = new File(this.mmax2.currentWorkingDirectory) + File.separator + requestedFileName;
        if (new File(requestedFileName).exists()) {
            MarkableFileLoader mfl = new MarkableFileLoader();
            mfl.load(requestedFileName, this.majorLevelName, this.majorLevelSchemeFileName, this.majorLevelCustomizationFileName, this.majorLevelLocalizedName);
            this.minorLevel = mfl.getMarkableLevel();
            this.minorLevel.setCurrentDiscourse(this.mmax2.getCurrentDiscourse());
            this.minorLevel.createMarkables();
            this.minorLevel.initMarkableRelations();
            this.minorLevel.setMarkableDisplayPositions();
            this.minorLevel.createDiscoursePositionToMarkableMapping();
            this.minorLevel.getRenderer().updateSimpleMarkableCustomizations(true);
            this.menu.updateAttributeMenu(this.majorLevel.getCurrentAnnotationScheme());
            this.updateMarkableDisplay();
        }
    }

    public static void show(MMAX2Discourse discourse) {
        try {
            SuperannotationPluginWindow diffWindow = new SuperannotationPluginWindow(discourse);
            diffWindow.setVisible(true);
        }
        catch (Exception e) {
            logger.error("Error loading plugin. ", e);
        }
    }

    private MarkableSet getMarkableSet(String attributeName, String markableID, MarkableLevel level) {
        if (markableID == null) {
            return null;
        }
        MMAX2Attribute currentSetAttribute = level.getCurrentAnnotationScheme().getUniqueAttributeByNameAndType("^" + attributeName + "$", 5);
        if (currentSetAttribute == null) {
            System.err.println("Warning: No set attribute '" + attributeName + "' on level '" + level.getMarkableLevelName() + "'!");
            return null;
        }
        MarkableRelation currentSetRelation = currentSetAttribute.getMarkableRelation();
        if (currentSetRelation == null) {
            System.err.println("Warning: No set relation '" + attributeName + "' on level '" + level.getMarkableLevelName() + "'!");
            return null;
        }
        return currentSetRelation.getMarkableSetWithAttributeValue(level.getMarkableByID(markableID).getAttributeValue(attributeName, ""));
    }

    public Map<String, Set<String>> getAllDistinctPartitionSets(String attributeName, int attributeType, MarkableLevel level, List<Set<String>> allDistinctPartitionSets, Set<String> allSpans) {
        HashMap<String, Set<String>> mapping = new HashMap<String, Set<String>>();
        MMAX2Attribute currentSetAttribute = level.getCurrentAnnotationScheme().getUniqueAttributeByNameAndType("^" + attributeName + "$", 5);
        if (currentSetAttribute == null) {
            System.err.println("Warning: No set attribute '" + attributeName + "' on level '" + level.getMarkableLevelName() + "'!");
            return null;
        }
        MarkableRelation currentSetRelation = currentSetAttribute.getMarkableRelation();
        if (currentSetRelation == null) {
            System.err.println("Warning: No set relation '" + attributeName + "' on level '" + level.getMarkableLevelName() + "'!");
            return null;
        }
        MarkableSet[] allSets = currentSetRelation.getMarkableSets(false);
        int z = 0;
        while (z < allSets.length) {
            MarkableSet currentSet = allSets[z];
            Set<String> temp = currentSet.getSetOfStrings();
            if (!allDistinctPartitionSets.contains(temp)) {
                allDistinctPartitionSets.add(temp);
            }
            mapping.put(currentSet.getAttributeValue(), temp);
            ++z;
        }
        return mapping;
    }

    public void updateMarkableDisplay() {
        String tempSpan;
        DefaultTableModel dm = new DefaultTableModel();
        if (this.majorLevel == null || this.minorLevel == null) {
            this.tableData = new String[1][1];
            this.tableData[0][0] = "";
            Object[] header = new String[]{"SPAN", STRING_COLUMN_HEADER};
            dm.setDataVector(this.tableData, header);
            this.table.setModel(dm);
            this.table.updateUI();
            return;
        }
        ArrayList<String> tempHeader = new ArrayList<String>();
        tempHeader.add("SPAN");
        tempHeader.add(STRING_COLUMN_HEADER);
        tempHeader.add(new File(this.majorLevel.getAbsoluteMarkableFileName()).getName());
        tempHeader.add(new File(this.minorLevel.getAbsoluteMarkableFileName()).getName());
        HashMap<String, String> spansToStrings = new HashMap<String, String>();
        this.spanToIDMappingsForAllLevels = new ArrayList<Map<String, String>>();
        HashMap<String, String> currentLevelsSpanToIDMappings = new HashMap<String, String>();
        HashSet<String> allSpans = new HashSet<String>();
        HashSet<String> majorSpans = new HashSet<String>();
        HashSet<String> minorSpans = new HashSet<String>();
        for (Markable temp : this.majorLevel.getMarkables()) {
            tempSpan = MarkableHelper.getSpan(temp);
            allSpans.add(tempSpan);
            if (majorSpans.contains(tempSpan)) {
                logger.error("Duplicate span: " + tempSpan + " in base mention file");
                this.majorLevel.getCurrentDiscourse().getCurrentMarkableChart().deleteMarkable(temp);
                continue;
            }
            majorSpans.add(tempSpan);
            spansToStrings.put(tempSpan, temp.toString());
            currentLevelsSpanToIDMappings.put(tempSpan, temp.getID());
        }
        this.spanToIDMappingsForAllLevels.add(currentLevelsSpanToIDMappings);
        currentLevelsSpanToIDMappings = new HashMap();
        for (Markable temp : this.minorLevel.getMarkables()) {
            tempSpan = MarkableHelper.getSpan(temp);
            if (minorSpans.contains(tempSpan)) {
                logger.error("Duplicate span: " + tempSpan + " in second mention file");
                this.minorLevel.getCurrentDiscourse().getCurrentMarkableChart().deleteMarkable(temp);
                continue;
            }
            minorSpans.add(tempSpan);
            allSpans.add(tempSpan);
            spansToStrings.put(tempSpan, temp.toString());
            currentLevelsSpanToIDMappings.put(tempSpan, temp.getID());
        }
        this.spanToIDMappingsForAllLevels.add(currentLevelsSpanToIDMappings);
        ArrayList<Set<String>> allDistinctPartitionSets = new ArrayList<Set<String>>();
        ArrayList<Map<String, Set<String>>> partitionToSetIDMappingsForAllLevels = new ArrayList<Map<String, Set<String>>>();
        if (this.getCurrentAttributeType().equals("set")) {
            partitionToSetIDMappingsForAllLevels.add(this.getAllDistinctPartitionSets(this.currentAttributeName, 5, this.majorLevel, allDistinctPartitionSets, allSpans));
            partitionToSetIDMappingsForAllLevels.add(this.getAllDistinctPartitionSets(this.currentAttributeName, 5, this.minorLevel, allDistinctPartitionSets, allSpans));
        }
        ArrayList<String> allSpansSorted = new ArrayList<String>(allSpans);
        Collections.sort(allSpansSorted, new MarkableSpanComparator());
        ArrayList<String[]> rowsToDisplay = new ArrayList<String[]>();
        this.iterateSpans(majorSpans, minorSpans, allSpansSorted, spansToStrings, allDistinctPartitionSets, partitionToSetIDMappingsForAllLevels, rowsToDisplay);
        this.tableData = new String[rowsToDisplay.size()][4];
        int b = 0;
        while (b < rowsToDisplay.size()) {
            this.tableData[b] = (String[])rowsToDisplay.get(b);
            ++b;
        }
        Object[] header = tempHeader.toArray(new String[1]);
        dm.setDataVector(this.tableData, header);
        int i = 0;
        while (i < this.table.getColumnModel().getColumnCount()) {
            this.columnWidths[i] = this.table.getColumnModel().getColumn(i).getWidth();
            ++i;
        }
        this.table.setModel(dm);
        this.table.setDefaultRenderer(Object.class, new SimpleMultiLineCellRenderer(this, allDistinctPartitionSets, spansToStrings));
        this.table.removeColumn(this.table.getColumnModel().getColumn(0));
        i = 0;
        while (i < this.table.getColumnModel().getColumnCount()) {
            this.table.getColumnModel().getColumn(i).setPreferredWidth(this.columnWidths[i]);
            ++i;
        }
        this.table.updateUI();
    }

    private void iterateSpans(Set<String> majorSpans, Set<String> minorSpans, List<String> allSpans, Map<String, String> spansToStrings, List<Set<String>> allDistinctPartitionSets, List<Map<String, Set<String>>> partitionToSetIDMappingsForAllLevels, List<String[]> rowsToDisplay) {
        int line = 0;
        while (line < allSpans.size()) {
            String val2;
            String val;
            String currentSpan;
            String[] currentTableLine = new String[4];
            currentTableLine[0] = currentSpan = allSpans.get(line);
            currentTableLine[1] = spansToStrings.get(currentSpan);
            if (this.currentAttributeName.equals("no_attribute")) {
                currentTableLine[2] = majorSpans.contains(currentSpan) ? "+" : "-";
                currentTableLine[3] = minorSpans.contains(currentSpan) ? "+" : "-";
            } else if (this.getCurrentAttributeType().equals("head")) {
                val = this.getAttributeValue(this.currentAttributeName, currentSpan, 0, this.spanToIDMappingsForAllLevels);
                if (val.equals("")) {
                    val = NO_VALUE;
                }
                currentTableLine[2] = val;
                val2 = this.getAttributeValue(this.currentAttributeName, currentSpan, 1, this.spanToIDMappingsForAllLevels);
                if (val2.equals("")) {
                    val2 = NO_VALUE;
                }
                currentTableLine[3] = val2;
            } else if (this.getCurrentAttributeType().equals("type")) {
                val = this.getAttributeValue(this.currentAttributeName, currentSpan, 0, this.spanToIDMappingsForAllLevels);
                if (val.equals("")) {
                    val = NO_VALUE;
                }
                currentTableLine[2] = val;
                val2 = this.getAttributeValue(this.currentAttributeName, currentSpan, 1, this.spanToIDMappingsForAllLevels);
                if (val2.equals("")) {
                    val2 = NO_VALUE;
                }
                currentTableLine[3] = val2;
            } else if (this.getCurrentAttributeType().equals("freetext")) {
                val = this.getAttributeValue(this.currentAttributeName, currentSpan, 0, this.spanToIDMappingsForAllLevels);
                if (val.equalsIgnoreCase("")) {
                    val = NO_VALUE;
                }
                currentTableLine[2] = val;
                val2 = this.getAttributeValue(this.currentAttributeName, currentSpan, 1, this.spanToIDMappingsForAllLevels);
                if (val2.equalsIgnoreCase("")) {
                    val2 = NO_VALUE;
                }
                currentTableLine[3] = val2;
            } else if (this.getCurrentAttributeType().equals("set")) {
                String val22;
                String val3;
                String setID = this.getAttributeValue(this.currentAttributeName, currentSpan, 0, this.spanToIDMappingsForAllLevels);
                if (setID.equalsIgnoreCase("empty")) {
                    setID = NO_VALUE;
                }
                currentTableLine[2] = val3 = this.getDisplayValueForSetID(setID, 0, partitionToSetIDMappingsForAllLevels, allDistinctPartitionSets, currentSpan);
                String setID2 = this.getAttributeValue(this.currentAttributeName, currentSpan, 1, this.spanToIDMappingsForAllLevels);
                if (setID2.equalsIgnoreCase("empty")) {
                    setID2 = NO_VALUE;
                }
                currentTableLine[3] = val22 = this.getDisplayValueForSetID(setID2, 1, partitionToSetIDMappingsForAllLevels, allDistinctPartitionSets, currentSpan);
            } else if (this.getCurrentAttributeType().equals("pointer")) {
                Markable m;
                Markable m2;
                String pointerVal = this.getAttributeValue(this.currentAttributeName, currentSpan, 0, this.spanToIDMappingsForAllLevels);
                if (pointerVal.equalsIgnoreCase("empty") || pointerVal.equals("")) {
                    pointerVal = NO_VALUE;
                } else if (!pointerVal.equalsIgnoreCase(NO_MARKABLE) && (m2 = this.majorLevel.getMarkableByID(pointerVal)) != null) {
                    pointerVal = MarkableHelper.getSpan(m2);
                }
                currentTableLine[2] = pointerVal;
                String pointerVal2 = this.getAttributeValue(this.currentAttributeName, currentSpan, 1, this.spanToIDMappingsForAllLevels);
                if (pointerVal2.equalsIgnoreCase("empty") || pointerVal2.equals("")) {
                    pointerVal2 = NO_VALUE;
                } else if (!pointerVal2.equalsIgnoreCase(NO_MARKABLE) && (m = this.minorLevel.getMarkableByID(pointerVal2)) != null) {
                    pointerVal2 = MarkableHelper.getSpan(m);
                }
                currentTableLine[3] = pointerVal2;
            } else if (this.getCurrentAttributeType().equals("dominant")) {
                String dom;
                Markable m = this.getMarkableFromSpan(currentSpan, 0, this.majorLevel);
                currentTableLine[2] = m == null || m.getAttributeValue("mention_group").equals("empty") ? NO_MARKABLE : ((dom = m.getDominant()) != null ? dom : Messages.getString("SuperannotationPluginWindow.No_dom_expr"));
                m = this.getMarkableFromSpan(currentSpan, 1, this.minorLevel);
                currentTableLine[3] = m == null || m.getAttributeValue("mention_group").equals("empty") ? NO_MARKABLE : ((dom = m.getDominant()) != null ? dom : Messages.getString("SuperannotationPluginWindow.No_dom_expr"));
            }
            if (!currentTableLine[2].equals(currentTableLine[3])) {
                rowsToDisplay.add(currentTableLine);
            }
            ++line;
        }
    }

    private final String getDisplayValueForSetID(String setID, int level, List<Map<String, Set<String>>> partitionToSetIDMappingsForAllLevels, List<Set<String>> allDistinctPartitionSets, String currentSpan) {
        Map<String, Set<String>> map = partitionToSetIDMappingsForAllLevels.get(level);
        Set<String> set = map.get(setID);
        int val = allDistinctPartitionSets.indexOf(set);
        if (val == -1) {
            return setID;
        }
        return String.valueOf(val + 1);
    }

    public final Markable getMarkableFromSpan(String span, int levelPos, MarkableLevel level) {
        Markable result = null;
        String ID = "";
        Map<String, String> map = this.spanToIDMappingsForAllLevels.get(levelPos);
        ID = map.get(span);
        if (ID != null) {
            result = level.getMarkableByID(ID);
        }
        return result;
    }

    public final String getAttributeValue(String attributeName, String span, int levelPos, List<Map<String, String>> spanToIDMappingsForAllLevels2) {
        MarkableLevel level = null;
        String ID = "";
        level = levelPos == 0 ? this.majorLevel : this.minorLevel;
        Map<String, String> map = spanToIDMappingsForAllLevels2.get(levelPos);
        ID = map.get(span);
        if (ID == null) {
            return NO_MARKABLE;
        }
        return level.getMarkableByID(ID).getAttributeValue(attributeName, NO_VALUE);
    }

    public int determineIntersectionSize(Set<String> set, Set<String> set2, String refElement) {
        HashSet<String> temp1 = new HashSet<String>(set);
        temp1.remove(refElement);
        HashSet<String> temp2 = new HashSet<String>(set2);
        temp2.remove(refElement);
        temp1.retainAll(temp2);
        return temp1.size();
    }

    public void mouseClicked(boolean withShift) {
        int clickedRow = this.table.getSelectedRow();
        int clickedCol = this.table.getSelectedColumn() + 1;
        if (clickedRow < 0) {
            return;
        }
        if (withShift) {
            logger.debug("MOUSE shift Clicked row:" + clickedRow + ", col:" + clickedCol);
            if (clickedCol == MAJOR_COLUMN || clickedCol == MINOR_COLUMN) {
                this.chooseLevel(clickedRow, clickedCol == MAJOR_COLUMN);
            }
        } else {
            logger.debug("MOUSE Clicked row:" + clickedRow + ", col:" + clickedCol);
            if (clickedCol == MAJOR_COLUMN || clickedCol == MINOR_COLUMN) {
                this.clickLevel(clickedRow, clickedCol == MAJOR_COLUMN);
            } else {
                this.clickSpan(clickedRow);
            }
        }
    }

    private void chooseLevel(int clickedRow, boolean major) {
        MarkableLevel ml;
        block27: {
            Markable markableOther;
            Markable markableClicked;
            MarkableLevel otherMl;
            String clickedVal;
            block25: {
                String otherVal;
                block26: {
                    String spanInTable = (String)this.table.getModel().getValueAt(clickedRow, 0);
                    clickedVal = (String)this.table.getModel().getValueAt(clickedRow, major ? MAJOR_COLUMN : MINOR_COLUMN);
                    otherVal = (String)this.table.getModel().getValueAt(clickedRow, major ? MINOR_COLUMN : MAJOR_COLUMN);
                    ml = major ? this.majorLevel : this.minorLevel;
                    otherMl = major ? this.minorLevel : this.majorLevel;
                    int mlIndex = major ? 0 : 1;
                    int otherMlIndex = major ? 1 : 0;
                    markableClicked = this.getMarkableFromSpan(spanInTable, mlIndex, ml);
                    markableOther = this.getMarkableFromSpan(spanInTable, otherMlIndex, otherMl);
                    if (!this.currentAttributeName.equals("no_attribute")) break block25;
                    if (!clickedVal.equals("-")) break block26;
                    logger.info("Deleting markable " + markableOther + " from level " + (major ? "minor" : "major"));
                    markableOther.deleteMe();
                    if (!major) {
                        this.discourse.reapplyStyleSheet();
                    }
                    break block27;
                }
                if (!clickedVal.equals("+") || !otherVal.equals("-")) break block27;
                logger.info("Adding markable " + markableClicked + " to level " + (major ? "minor" : "major"));
                Markable addedMarkable = otherMl.addMarkable(MarkableHelper.getSpan(markableClicked));
                addedMarkable.setAttributeValue("mention_head", markableClicked.getAttributeValue("mention_head"));
                if (major) break block27;
                this.discourse.reapplyStyleSheet();
                break block27;
            }
            if (markableClicked == null || markableOther == null) {
                logger.warn("One of markables is null!");
                return;
            }
            if (this.currentAttributeName.equals("comment")) {
                logger.info("Setting comment for " + markableOther);
                markableOther.setAttributeValue("comment", markableClicked.getAttributeValue("comment"));
            } else if (this.currentAttributeName.equals("mention_head")) {
                logger.info("Setting mention_head for " + markableOther);
                markableOther.setAttributeValue("mention_head", markableClicked.getAttributeValue("mention_head"));
            } else if (this.currentAttributeName.equals("mention_type")) {
                logger.info("Setting mention_type for " + markableOther);
                markableOther.setAttributeValue("mention_type", markableClicked.getAttributeValue("mention_type"));
            } else if (this.currentAttributeName.equals("dominant")) {
                logger.info("Setting dominant for " + markableOther);
                markableOther.setDominant(markableClicked.getDominant());
                MarkableRelation relationOther = otherMl.getCurrentAnnotationScheme().getAttributeByID("level_mention_group").getMarkableRelation();
                MarkableSet setOther = relationOther.getMarkableSetContainingMarkable(markableOther);
                if (setOther != null) {
                    setOther.setDominant(markableClicked.getDominant(), false);
                }
            } else if (this.currentAttributeName.equals("near_identity")) {
                logger.info("Setting near identity for " + markableOther);
                MarkableRelation relationClicked = ml.getCurrentAnnotationScheme().getAttributeByID("level_near_identity").getMarkableRelation();
                MarkableRelation relationOther = otherMl.getCurrentAnnotationScheme().getAttributeByID("level_near_identity").getMarkableRelation();
                MarkablePointer pointerClicked = relationClicked.getMarkablePointerForSourceMarkable(markableClicked);
                if (pointerClicked == null) {
                    otherMl.getCurrentDiscourse().getCurrentMarkableChart().removeMarkablePointerWithSourceMarkable(markableOther, relationOther, true);
                } else {
                    String targetSpan = MarkableHelper.getSpan(pointerClicked.getTargetMarkables()[0]);
                    Markable target = otherMl.getMarkableAtSpan(targetSpan);
                    if (target != null) {
                        otherMl.getCurrentDiscourse().getCurrentMarkableChart().addTargetMarkableToNewMarkablePointer(markableOther, target, relationOther);
                    } else {
                        logger.warn("No markable to point to!");
                    }
                }
            } else if (this.currentAttributeName.equals("mention_group")) {
                MarkableRelation relationOther = otherMl.getCurrentAnnotationScheme().getAttributeByID("level_mention_group").getMarkableRelation();
                MarkableSet setOther = relationOther.getMarkableSetContainingMarkable(markableOther);
                if (setOther != null) {
                    logger.info("Removing mention " + markableOther + " from its cluster.");
                    otherMl.getCurrentDiscourse().getCurrentMarkableChart().removeMarkableFromMarkableSet(markableOther, setOther, true);
                }
                if (!clickedVal.equals(NO_VALUE)) {
                    MarkableRelation relationClicked = ml.getCurrentAnnotationScheme().getAttributeByID("level_mention_group").getMarkableRelation();
                    MarkableSet setClicked = relationClicked.getMarkableSetContainingMarkable(markableClicked);
                    MarkableSet newSet = null;
                    Markable[] markableArray = setClicked.getOrderedMarkables();
                    int n = markableArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Markable correspMarkable;
                        Markable m = markableArray[n2];
                        if (!m.equals(markableClicked) && (correspMarkable = otherMl.getMarkableAtSpan(MarkableHelper.getSpan(m))) != null) {
                            MarkableSet set = relationOther.getMarkableSetContainingMarkable(correspMarkable);
                            if (set != null) {
                                logger.info("Removing mention " + correspMarkable + " from its cluster.");
                                otherMl.getCurrentDiscourse().getCurrentMarkableChart().removeMarkableFromMarkableSet(correspMarkable, set, true);
                            }
                            logger.info("Adding mention " + correspMarkable + " to new cluster with " + markableOther);
                            if (newSet == null) {
                                newSet = otherMl.getCurrentDiscourse().getCurrentMarkableChart().addMarkableToNewMarkableSet(markableOther, correspMarkable, relationOther, true);
                            } else {
                                otherMl.getCurrentDiscourse().getCurrentMarkableChart().addMarkableToExistingMarkableSet(correspMarkable, newSet, false);
                            }
                        }
                        ++n2;
                    }
                }
            }
        }
        ml.setIsDirty(true, false);
        this.updateMarkableDisplay();
    }

    private void clickLevel(int clickedRow, boolean major) {
        MarkableLevel clickedLevel = major ? this.majorLevel : this.minorLevel;
        String spanInTable = (String)this.table.getModel().getValueAt(clickedRow, 0);
        Markable markable = this.getMarkableFromSpan(spanInTable, major ? 0 : 1, clickedLevel);
        this.mmax2.getCurrentDiscourse().reapplyStyleSheet();
        if (markable == null) {
            logger.debug("No markable to display");
        } else if (this.currentAttributeType.equals("set")) {
            MarkableSet set = this.getMarkableSet(this.currentAttributeName, markable.getID(), clickedLevel);
            if (set != null) {
                Markable[] markableArray = set.getOrderedMarkables();
                int n = markableArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Markable m = markableArray[n2];
                    Markable mCopy = this.getMarkableFromSpan(MarkableHelper.getSpan(m), major ? 0 : 1, clickedLevel);
                    MarkableHelper.setDisplayPositions(mCopy);
                    this.majorLevel.getRenderer().render(mCopy.getDisplayStartPositions(), mCopy.getDisplayEndPositions(), Color.ORANGE);
                    ++n2;
                }
            } else {
                this.majorLevel.getRenderer().render(markable.getDisplayStartPositions(), markable.getDisplayEndPositions(), Color.ORANGE);
            }
            this.mmax2.scrollToMarkable(markable);
            this.mmax2.getCurrentTextPane().startAutoRefresh();
        } else if (this.currentAttributeType.equals("pointer")) {
            String targetSpan = (String)this.table.getModel().getValueAt(clickedRow, major ? 2 : 3);
            Markable m = this.getMarkableFromSpan(targetSpan, 0, this.majorLevel);
            if (m != null) {
                this.majorLevel.getRenderer().render(m.getDisplayStartPositions(), m.getDisplayEndPositions(), Color.BLUE);
            }
            this.majorLevel.getRenderer().render(markable.getDisplayStartPositions(), markable.getDisplayEndPositions(), Color.ORANGE);
            this.mmax2.scrollToMarkable(markable);
            this.mmax2.getCurrentTextPane().startAutoRefresh();
        } else {
            this.majorLevel.getRenderer().render(markable.getDisplayStartPositions(), markable.getDisplayEndPositions(), Color.ORANGE);
            this.mmax2.scrollToMarkable(markable);
            this.mmax2.getCurrentTextPane().startAutoRefresh();
        }
    }

    private void clickSpan(int clickedRow) {
        String spanInTable = (String)this.table.getModel().getValueAt(clickedRow, 0);
        Markable markable = this.getMarkableFromSpan(spanInTable, 0, this.majorLevel);
        MarkableLevel clickedLevel = this.majorLevel;
        if (markable == null) {
            markable = this.getMarkableFromSpan(spanInTable, 1, this.minorLevel);
            clickedLevel = this.minorLevel;
        }
        this.mmax2.getCurrentDiscourse().reapplyStyleSheet();
        if (markable == null) {
            logger.debug("No markable to display");
        } else if (this.currentAttributeType.equals("set")) {
            MarkableSet set = this.getMarkableSet(this.currentAttributeName, markable.getID(), clickedLevel);
            if (set != null) {
                Markable[] markableArray = set.getOrderedMarkables();
                int n = markableArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Markable m = markableArray[n2];
                    Markable mCopy = this.majorLevel.getMarkableAtSpan(MarkableHelper.getSpan(m));
                    this.majorLevel.getRenderer().render(mCopy.getDisplayStartPositions(), mCopy.getDisplayEndPositions(), Color.ORANGE);
                    ++n2;
                }
            }
            this.mmax2.scrollToMarkable(markable);
            this.mmax2.getCurrentTextPane().startAutoRefresh();
        } else if (this.currentAttributeType.equals("pointer")) {
            String targetSpan = (String)this.table.getModel().getValueAt(clickedRow, clickedLevel == this.majorLevel ? 2 : 3);
            Markable m = this.getMarkableFromSpan(targetSpan, 0, this.majorLevel);
            if (m != null) {
                this.majorLevel.getRenderer().render(m.getDisplayStartPositions(), m.getDisplayEndPositions(), Color.BLUE);
            }
            this.majorLevel.getRenderer().render(markable.getDisplayStartPositions(), markable.getDisplayEndPositions(), Color.ORANGE);
            this.mmax2.scrollToMarkable(markable);
            this.mmax2.getCurrentTextPane().startAutoRefresh();
        } else {
            this.majorLevel.getRenderer().render(markable.getDisplayStartPositions(), markable.getDisplayEndPositions(), Color.ORANGE);
            this.mmax2.scrollToMarkable(markable);
            this.mmax2.getCurrentTextPane().startAutoRefresh();
        }
    }

    public String getCurrentAttributeType() {
        return this.currentAttributeType;
    }

    public void close() {
        this.mmax2.emptyRenderingList(true);
        this.discourse.getCurrentMarkableChart().nothingClicked(MMAX2Constants.LEFTMOUSE);
        this.discourse.reapplyStyleSheet();
        this.dispose();
    }

    public void updateAttribute(String name, String type) {
        this.currentAttributeName = name;
        this.currentAttributeType = type;
    }

    public void saveText() {
        logger.info("Saving second annotation level");
        this.minorLevel.saveMarkables("");
    }

    @Override
    public final void dispose() {
        this.mmax2.dismissSuperanno();
        super.dispose();
    }

    public void syncAnnotations() {
        int showConfirmDialog = JOptionPane.showConfirmDialog(this, String.valueOf(Messages.getString("SuperannotationPluginWindow.do_you_want_to_copy_main_annotation")) + " (" + new File(this.majorLevel.getAbsoluteMarkableFileName()).getName() + ")\n" + Messages.getString("SuperannotationPluginWindow.to_second_version") + "(" + new File(this.minorLevel.getAbsoluteMarkableFileName()).getName() + ")?", String.valueOf(Messages.getString("SuperannotationPluginWindow.are_u_sure")) + "?", 0);
        if (showConfirmDialog == 0) {
            block25: {
                logger.info("Copying all changes from base level to second one...");
                this.majorLevel.saveMarkables("");
                String secondFileName = "B_mentions.xml";
                String baseFileName = "A_mentions.xml";
                if (this.mmax2.currentMmaxFilename.startsWith("B")) {
                    baseFileName = secondFileName;
                    secondFileName = "A_mentions.xml";
                }
                secondFileName = new File(this.mmax2.currentWorkingDirectory) + File.separator + secondFileName;
                baseFileName = new File(this.mmax2.currentWorkingDirectory) + File.separator + baseFileName;
                FileChannel baseChannel = null;
                AbstractInterruptibleChannel secondChannel = null;
                try {
                    try {
                        baseChannel = new FileInputStream(baseFileName).getChannel();
                        secondChannel = new FileOutputStream(secondFileName).getChannel();
                        baseChannel.transferTo(0L, baseChannel.size(), (WritableByteChannel)((Object)secondChannel));
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(this, Messages.getString("SuperannotationPluginWindow.Couldnt_copy"), Messages.getString("SuperannotationPluginWindow.Error"), 0);
                        logger.error(e.getMessage());
                        if (baseChannel != null) {
                            try {
                                baseChannel.close();
                            }
                            catch (IOException e2) {
                                logger.error(e2.getMessage());
                            }
                        }
                        if (secondChannel != null) {
                            try {
                                secondChannel.close();
                            }
                            catch (IOException e3) {
                                logger.error(e3.getMessage());
                            }
                        }
                        break block25;
                    }
                }
                catch (Throwable throwable) {
                    if (baseChannel != null) {
                        try {
                            baseChannel.close();
                        }
                        catch (IOException e) {
                            logger.error(e.getMessage());
                        }
                    }
                    if (secondChannel != null) {
                        try {
                            secondChannel.close();
                        }
                        catch (IOException e) {
                            logger.error(e.getMessage());
                        }
                    }
                    throw throwable;
                }
                if (baseChannel != null) {
                    try {
                        baseChannel.close();
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage());
                    }
                }
                if (secondChannel != null) {
                    try {
                        secondChannel.close();
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage());
                    }
                }
            }
            this.loadLevels();
        }
    }
}

