/*
 * Decompiled with CFR 0.152.
 */
package pl.waw.ipipan.zil.core.mmax4core.discourse;

import java.io.File;
import java.net.URL;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import pl.waw.ipipan.zil.core.mmax4core.Messages;

public class LocalResolver
implements EntityResolver {
    private static final Logger logger = Logger.getLogger(LocalResolver.class);
    private static final String words = "words.dtd";
    private static final String markables = "markables.dtd";
    private static InputSource wordsIs;
    private static InputSource markablesIs;
    private static File cp;
    private static File dir;

    static {
        cp = null;
        dir = null;
        cp = LocalResolver.findCommonPaths();
        if (cp != null) {
            wordsIs = new InputSource(new File(String.valueOf(cp.getParent()) + File.separator + words).toURI().toASCIIString());
            markablesIs = new InputSource(new File(String.valueOf(cp.getParent()) + File.separator + markables).toURI().toASCIIString());
            dir = cp.getParentFile().getParentFile();
        } else {
            logger.error("No common paths found!");
        }
    }

    @Override
    public InputSource resolveEntity(String publicID, String systemID) throws SAXException {
        if (systemID.endsWith(words)) {
            return wordsIs;
        }
        if (systemID.endsWith(markables)) {
            return markablesIs;
        }
        return null;
    }

    public static File findCommonPaths() {
        File cand2;
        File cand1;
        if (cp != null) {
            return cp;
        }
        File loc = null;
        try {
            URL resource = LocalResolver.class.getClassLoader().getResource("");
            loc = resource == null ? new File(".") : new File(resource.toURI());
        }
        catch (Exception e) {
            System.out.println("Error searching jar location " + e);
            return null;
        }
        String cp_filename = "common_paths.xml";
        if (Messages.RESOURCE_BUNDLE.getLocale().equals(Locale.ENGLISH)) {
            cp_filename = "common_paths_en.xml";
        }
        if ((cand1 = new File(String.valueOf(loc.getAbsolutePath()) + File.separator + "core_schema" + File.separator + cp_filename)).exists()) {
            logger.debug("Found common paths in: " + cand1);
            return cand1;
        }
        if (loc.getParentFile() != null && (cand2 = new File(String.valueOf(loc.getParentFile().getAbsolutePath()) + File.separator + "core_schema" + File.separator + cp_filename)).exists()) {
            logger.debug("Found common paths in: " + cand2);
            return cand2;
        }
        logger.debug("No common paths found in: " + cand1 + ", nor in its parent");
        return null;
    }

    public static File findPlugins() {
        File cand1 = new File(dir + File.separator + "plugins.xml");
        if (cand1.exists()) {
            return cand1;
        }
        return null;
    }

    public static File findUserSettings() {
        File cand1 = LocalResolver.getDisplaySettingsFile();
        if (cand1.exists()) {
            return cand1;
        }
        return null;
    }

    public static File getDisplaySettingsFile() {
        return new File(dir + File.separator + ".usersettings");
    }
}

