/*
 * Decompiled with CFR 0.152.
 */
package pl.waw.ipipan.zil.core.mmax4core.gui.display;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.log4j.Logger;
import pl.waw.ipipan.zil.core.mmax4core.Messages;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.Markable;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.MarkableChart;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.MarkablePointer;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.MarkableRelation;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.MarkableSet;
import pl.waw.ipipan.zil.core.mmax4core.annotation.scheme.MMAX2Attribute;
import pl.waw.ipipan.zil.core.mmax4core.core.MMAX2;
import pl.waw.ipipan.zil.core.mmax4core.gui.display.BoxIcon;
import pl.waw.ipipan.zil.core.mmax4core.utils.MMAX2Constants;

public class MMAX2ActionSelector
extends JPopupMenu {
    private static final long serialVersionUID = 156635427064920560L;
    private static final Logger logger = Logger.getLogger(MMAX2ActionSelector.class);
    private boolean empty = true;
    private boolean initial = true;

    public MMAX2ActionSelector(final Markable currentPrimaryMarkable, final String[] DEs, final MarkableChart currentMarkableChart, final int mode) {
        JMenuItem item = null;
        this.empty = false;
        if (mode == MMAX2Constants.REMOVE_DES) {
            item = new JMenuItem(Messages.getString("MMAX2ActionSelector.Remove_from_this_Markable"));
            item.addActionListener(new ActionListener(){

                @Override
                public final void actionPerformed(ActionEvent ae) {
                    currentMarkableChart.getCurrentDiscourse().getMMAX2().saveStateForUndo();
                    currentMarkableChart.requestModifyMarkablesDEs(currentPrimaryMarkable, DEs, mode);
                }
            });
            this.add(item);
        } else {
            item = new JMenuItem(Messages.getString("MMAX2ActionSelector.Add_to_this_Markable"));
            item.addActionListener(new ActionListener(){

                @Override
                public final void actionPerformed(ActionEvent ae) {
                    currentMarkableChart.getCurrentDiscourse().getMMAX2().saveStateForUndo();
                    currentMarkableChart.requestModifyMarkablesDEs(currentPrimaryMarkable, DEs, mode);
                }
            });
            this.add(item);
        }
        if (!this.empty) {
            this.setVisible(true);
            this.setVisible(false);
        }
        this.addPopupMenuListener(new CancellationListener(currentMarkableChart));
    }

    public MMAX2ActionSelector(final Markable currentSecondaryMarkable, Markable currentPrimaryMarkable, final MarkableChart currentMarkableChart, boolean allowDelete) {
        JMenuItem item = null;
        if (currentSecondaryMarkable != null) {
            this.empty = false;
            item = new JMenuItem(currentSecondaryMarkable.toTrimmedString(80));
            this.add(item);
            this.addSeparator();
            item = null;
            if (allowDelete) {
                item = new JMenuItem(Messages.getString("MMAX2ActionSelector.Delete_this_Markable"));
                item.addActionListener(new ActionListener(){

                    @Override
                    public final void actionPerformed(ActionEvent ae) {
                        currentMarkableChart.getCurrentDiscourse().getMMAX2().saveStateForUndo();
                        currentMarkableChart.deleteMarkable(currentSecondaryMarkable);
                    }
                });
                this.add(item);
            }
        }
        if (currentSecondaryMarkable != null) {
            MMAX2Attribute[] validatedAttributes;
            boolean addedSep = false;
            MMAX2Attribute[] mMAX2AttributeArray = validatedAttributes = currentSecondaryMarkable.getValidatedAttributes();
            int n = validatedAttributes.length;
            int n2 = 0;
            while (n2 < n) {
                MarkableSet currentMarkablesSet;
                MMAX2Attribute currentAttribute = mMAX2AttributeArray[n2];
                if (currentAttribute.getType() == 5 && (currentMarkablesSet = currentAttribute.getMarkableRelation().getMarkableSetWithAttributeValue(currentSecondaryMarkable.getAttributeValue(currentAttribute.getLowerCasedAttributeName()))) != null) {
                    this.empty = false;
                    item = null;
                    item = new JMenuItem("    " + currentAttribute.getRemoveFromMarkablesetInstruction(), new BoxIcon(currentAttribute.getLineColor()));
                    item.setHorizontalTextPosition(4);
                    item.addActionListener(new ActionListener(){

                        @Override
                        public final void actionPerformed(ActionEvent ae) {
                            currentMarkableChart.getCurrentDiscourse().getMMAX2().saveStateForUndo();
                            currentMarkableChart.removeMarkableFromMarkableSet(currentSecondaryMarkable, currentMarkablesSet, true);
                        }
                    });
                    if (!addedSep) {
                        this.addSeparator();
                        addedSep = true;
                    }
                    this.add(item);
                }
                ++n2;
            }
        }
        if (!this.empty) {
            this.setVisible(true);
            this.setVisible(false);
        }
        this.addPopupMenuListener(new CancellationListener(currentMarkableChart));
    }

    public MMAX2ActionSelector(final Markable currentPrimaryMarkable, final Markable currentSecondaryMarkable, final MarkableChart currentMarkableChart) {
        this.addPopupMenuListener(new CancellationListener(currentMarkableChart));
        JMenuItem item = new JMenuItem(currentSecondaryMarkable.toTrimmedString(80));
        this.add(item);
        this.addSeparator();
        item = new JMenuItem(Messages.getString("MMAX2ActionSelector.Merge_markables"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                currentMarkableChart.getCurrentDiscourse().getMMAX2().saveStateForUndo();
                MMAX2ActionSelector.this.mergeTwoMarkables(currentPrimaryMarkable, currentSecondaryMarkable, currentMarkableChart);
            }
        });
        this.add(item);
        this.addSeparator();
        MMAX2Attribute[] mMAX2AttributeArray = currentPrimaryMarkable.getValidatedAttributes();
        int n = mMAX2AttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MMAX2Attribute currentAttribute = mMAX2AttributeArray[n2];
            if (currentAttribute.getType() == 5) {
                this.addSetRelationItems(currentPrimaryMarkable, currentSecondaryMarkable, currentMarkableChart, currentAttribute);
            } else if (currentAttribute.getType() == 6) {
                this.addPointerRelationItems(currentPrimaryMarkable, currentSecondaryMarkable, currentMarkableChart, currentAttribute);
            }
            ++n2;
        }
        if (!this.empty) {
            this.setVisible(true);
            this.setVisible(false);
        }
        this.addPopupMenuListener(new CancellationListener(currentMarkableChart));
    }

    protected void mergeTwoMarkables(Markable currentPrimaryMarkable, Markable currentSecondaryMarkable, MarkableChart currentMarkableChart) {
        logger.debug("Merging two markables");
        MMAX2Attribute[] primaryMarkableAttributes = currentPrimaryMarkable.getValidatedAttributes();
        MMAX2Attribute[] secondaryMarkableAttributes = currentSecondaryMarkable.getValidatedAttributes();
        MMAX2Attribute[] mMAX2AttributeArray = primaryMarkableAttributes;
        int n = primaryMarkableAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            MMAX2Attribute currentAttribute = mMAX2AttributeArray[n2];
            if (currentAttribute.getType() == 5) {
                String temp;
                MarkableRelation currentRelation = currentAttribute.getMarkableRelation();
                MarkableSet currentPrimaryMarkablesSet = currentRelation.getMarkableSetWithAttributeValue(currentPrimaryMarkable.getAttributeValue(currentAttribute.getLowerCasedAttributeName()));
                if (currentPrimaryMarkablesSet != null) {
                    if (!currentPrimaryMarkablesSet.containsMarkable(currentSecondaryMarkable) && this.containsAttribute(secondaryMarkableAttributes, currentAttribute) && (temp = currentSecondaryMarkable.getAttributeValue(currentAttribute.getLowerCasedAttributeName())) != null && !temp.equals("") && !temp.equals(MMAX2.defaultRelationValue)) {
                        this.empty = false;
                        MarkableSet adoptingSet2 = currentPrimaryMarkablesSet;
                        MarkableSet leftSet2 = currentRelation.getMarkableSetWithAttributeValue(temp);
                        currentMarkableChart.mergeMarkableSets(adoptingSet2, leftSet2);
                    }
                } else if (this.containsAttribute(secondaryMarkableAttributes, currentAttribute) && (temp = currentSecondaryMarkable.getAttributeValue(currentAttribute.getLowerCasedAttributeName())) != null && !temp.equals("") && !temp.equals(MMAX2.defaultRelationValue)) {
                    this.empty = false;
                    MarkableSet leftSet2 = currentRelation.getMarkableSetWithAttributeValue(temp);
                    currentMarkableChart.mergeMarkableSetsIntoNewSet(leftSet2);
                }
            }
            ++n2;
        }
        currentMarkableChart.requestModifyMarkablesDEs(currentPrimaryMarkable, currentSecondaryMarkable.getDiscourseElementIDs(), MMAX2Constants.ADD_DES);
        currentMarkableChart.deleteMarkable(currentSecondaryMarkable);
    }

    private void addPointerRelationItems(final Markable currentPrimaryMarkable, final Markable currentSecondaryMarkable, final MarkableChart currentMarkableChart, MMAX2Attribute currentAttribute) {
        MarkablePointer currentPrimaryMarkablePointer = null;
        MarkableRelation currentRelation = currentAttribute.getMarkableRelation();
        currentPrimaryMarkablePointer = currentRelation.getMarkablePointerForSourceMarkable(currentPrimaryMarkable);
        if (currentPrimaryMarkablePointer != null) {
            if (currentPrimaryMarkablePointer.isTargetMarkable(currentSecondaryMarkable)) {
                this.empty = false;
                JMenuItem item = null;
                item = new JMenuItem("    " + currentAttribute.getRemovePointerToMarkableInstruction(), new BoxIcon(currentAttribute.getLineColor()));
                item.setHorizontalTextPosition(4);
                final MarkablePointer pointer = currentPrimaryMarkablePointer;
                item.addActionListener(new ActionListener(){

                    @Override
                    public final void actionPerformed(ActionEvent ae) {
                        currentMarkableChart.getCurrentDiscourse().getMMAX2().saveStateForUndo();
                        currentMarkableChart.removeTargetMarkableFromMarkablePointer(currentSecondaryMarkable, pointer, true);
                    }
                });
                this.add(item);
            } else if (!currentPrimaryMarkablePointer.hasMaxSize() && currentAttribute.inDomain(currentSecondaryMarkable.getMarkableLevelName())) {
                this.empty = false;
                JMenuItem item = null;
                item = new JMenuItem("    " + currentAttribute.getPointToMarkableInstruction(), new BoxIcon(currentAttribute.getLineColor()));
                item.setHorizontalTextPosition(4);
                final MarkablePointer pointer = currentPrimaryMarkablePointer;
                item.addActionListener(new ActionListener(){

                    @Override
                    public final void actionPerformed(ActionEvent ae) {
                        currentMarkableChart.getCurrentDiscourse().getMMAX2().saveStateForUndo();
                        currentMarkableChart.addTargetMarkableToExistingMarkablePointer(currentPrimaryMarkable, currentSecondaryMarkable, pointer);
                    }
                });
                this.add(item);
            } else {
                System.err.println("MaxSize reached or illegal domain!");
            }
        } else if (currentAttribute.inDomain(currentSecondaryMarkable.getMarkableLevelName())) {
            this.empty = false;
            JMenuItem item = null;
            item = new JMenuItem("    " + currentAttribute.getPointToMarkableInstruction(), new BoxIcon(currentAttribute.getLineColor()));
            item.setHorizontalTextPosition(4);
            final MarkableRelation tempRelation = currentRelation;
            item.addActionListener(new ActionListener(){

                @Override
                public final void actionPerformed(ActionEvent ae) {
                    currentMarkableChart.getCurrentDiscourse().getMMAX2().saveStateForUndo();
                    currentMarkableChart.addTargetMarkableToNewMarkablePointer(currentPrimaryMarkable, currentSecondaryMarkable, tempRelation);
                }
            });
            this.add(item);
        }
    }

    private void addSetRelationItems(Markable currentPrimaryMarkable, final Markable currentSecondaryMarkable, final MarkableChart currentMarkableChart, MMAX2Attribute currentAttribute) {
        MMAX2Attribute[] secondaryMarkablesAttributes = currentSecondaryMarkable.getValidatedAttributes();
        MarkableSet currentPrimaryMarkablesSet = null;
        MarkableRelation currentRelation = currentAttribute.getMarkableRelation();
        currentPrimaryMarkablesSet = currentRelation.getMarkableSetWithAttributeValue(currentPrimaryMarkable.getAttributeValue(currentAttribute.getLowerCasedAttributeName()));
        if (currentPrimaryMarkablesSet != null) {
            if (currentPrimaryMarkablesSet.containsMarkable(currentSecondaryMarkable)) {
                this.empty = false;
                JMenuItem item = null;
                item = new JMenuItem("    " + currentAttribute.getRemoveFromMarkablesetInstruction(), new BoxIcon(currentAttribute.getLineColor()));
                item.setHorizontalTextPosition(4);
                final MarkableSet tempSet = currentPrimaryMarkablesSet;
                item.addActionListener(new ActionListener(){

                    @Override
                    public final void actionPerformed(ActionEvent ae) {
                        currentMarkableChart.getCurrentDiscourse().getMMAX2().saveStateForUndo();
                        currentMarkableChart.removeMarkableFromMarkableSet(currentSecondaryMarkable, tempSet, true);
                    }
                });
                this.add(item);
            } else if (this.containsAttribute(secondaryMarkablesAttributes, currentAttribute)) {
                String temp = currentSecondaryMarkable.getAttributeValue(currentAttribute.getLowerCasedAttributeName());
                if (temp != null && !temp.equals("") && !temp.equals(MMAX2.defaultRelationValue)) {
                    this.empty = false;
                    JMenuItem item = null;
                    item = new JMenuItem("    " + currentAttribute.getAdoptIntoMarkablesetInstruction(), new BoxIcon(currentAttribute.getLineColor()));
                    item.setHorizontalTextPosition(4);
                    final MarkableSet adoptingSet = currentPrimaryMarkablesSet;
                    final MarkableSet leftSet = currentRelation.getMarkableSetWithAttributeValue(temp);
                    leftSet.setOpaque(true);
                    currentMarkableChart.getCurrentDiscourse().getMMAX2().putOnRenderingList(leftSet);
                    currentMarkableChart.getCurrentDiscourse().getMMAX2().getCurrentViewport().repaint();
                    currentMarkableChart.getCurrentDiscourse().getMMAX2().getCurrentTextPane().startAutoRefresh();
                    item.addActionListener(new ActionListener(){

                        @Override
                        public final void actionPerformed(ActionEvent ae) {
                            currentMarkableChart.getCurrentDiscourse().getMMAX2().saveStateForUndo();
                            currentMarkableChart.adoptMarkableToExistingMarkableSet(currentSecondaryMarkable, leftSet, adoptingSet);
                        }
                    });
                    this.add(item);
                    this.empty = false;
                    item = null;
                    item = new JMenuItem("    " + currentAttribute.getMergeIntoMarkablesetInstruction(), new BoxIcon(currentAttribute.getLineColor()));
                    item.setHorizontalTextPosition(4);
                    final MarkableSet adoptingSet2 = currentPrimaryMarkablesSet;
                    final MarkableSet leftSet2 = currentRelation.getMarkableSetWithAttributeValue(temp);
                    leftSet2.setOpaque(true);
                    currentMarkableChart.getCurrentDiscourse().getMMAX2().putOnRenderingList(leftSet2);
                    currentMarkableChart.getCurrentDiscourse().getMMAX2().getCurrentViewport().repaint();
                    currentMarkableChart.getCurrentDiscourse().getMMAX2().getCurrentTextPane().startAutoRefresh();
                    item.addActionListener(new ActionListener(){

                        @Override
                        public final void actionPerformed(ActionEvent ae) {
                            currentMarkableChart.getCurrentDiscourse().getMMAX2().saveStateForUndo();
                            currentMarkableChart.mergeMarkableSets(adoptingSet2, leftSet2);
                        }
                    });
                    this.add(item);
                } else {
                    this.empty = false;
                    JMenuItem item = null;
                    item = new JMenuItem("    " + currentAttribute.getAddToMarkablesetInstruction(), new BoxIcon(currentAttribute.getLineColor()));
                    item.setHorizontalTextPosition(4);
                    final MarkableSet tempSet = currentPrimaryMarkablesSet;
                    item.addActionListener(new ActionListener(){

                        @Override
                        public final void actionPerformed(ActionEvent ae) {
                            currentMarkableChart.getCurrentDiscourse().getMMAX2().saveStateForUndo();
                            currentMarkableChart.addMarkableToExistingMarkableSet(currentSecondaryMarkable, tempSet, true);
                        }
                    });
                    this.add(item);
                }
            }
        } else if (this.containsAttribute(secondaryMarkablesAttributes, currentAttribute)) {
            String temp = currentSecondaryMarkable.getAttributeValue(currentAttribute.getLowerCasedAttributeName());
            if (temp != null && !temp.equals("") && !temp.equals(MMAX2.defaultRelationValue)) {
                this.empty = false;
                JMenuItem item = null;
                item = new JMenuItem("    " + currentAttribute.getAdoptIntoMarkablesetInstruction(), new BoxIcon(currentAttribute.getLineColor()));
                item.setHorizontalTextPosition(4);
                final MarkableSet leftSet = currentRelation.getMarkableSetWithAttributeValue(temp);
                leftSet.setOpaque(true);
                currentMarkableChart.getCurrentDiscourse().getMMAX2().putOnRenderingList(leftSet);
                currentMarkableChart.getCurrentDiscourse().getMMAX2().getCurrentViewport().repaint();
                currentMarkableChart.getCurrentDiscourse().getMMAX2().getCurrentTextPane().startAutoRefresh();
                item.addActionListener(new ActionListener(){

                    @Override
                    public final void actionPerformed(ActionEvent ae) {
                        currentMarkableChart.getCurrentDiscourse().getMMAX2().saveStateForUndo();
                        currentMarkableChart.adoptMarkableToNewMarkableSet(currentSecondaryMarkable, leftSet);
                    }
                });
                this.add(item);
                this.empty = false;
                item = null;
                item = new JMenuItem("    " + currentAttribute.getMergeIntoMarkablesetInstruction(), new BoxIcon(currentAttribute.getLineColor()));
                item.setHorizontalTextPosition(4);
                final MarkableSet leftSet2 = currentRelation.getMarkableSetWithAttributeValue(temp);
                leftSet2.setOpaque(true);
                currentMarkableChart.getCurrentDiscourse().getMMAX2().putOnRenderingList(leftSet2);
                currentMarkableChart.getCurrentDiscourse().getMMAX2().getCurrentViewport().repaint();
                currentMarkableChart.getCurrentDiscourse().getMMAX2().getCurrentTextPane().startAutoRefresh();
                item.addActionListener(new ActionListener(){

                    @Override
                    public final void actionPerformed(ActionEvent ae) {
                        currentMarkableChart.getCurrentDiscourse().getMMAX2().saveStateForUndo();
                        currentMarkableChart.mergeMarkableSetsIntoNewSet(leftSet2);
                    }
                });
                this.add(item);
            } else {
                this.empty = false;
                JMenuItem item = null;
                item = new JMenuItem("    " + currentAttribute.getAddToMarkablesetInstruction(), new BoxIcon(currentAttribute.getLineColor()));
                item.setHorizontalTextPosition(4);
                final MarkableRelation relation = currentAttribute.getMarkableRelation();
                item.addActionListener(new ActionListener(){

                    @Override
                    public final void actionPerformed(ActionEvent ae) {
                        currentMarkableChart.getCurrentDiscourse().getMMAX2().saveStateForUndo();
                        currentMarkableChart.addMarkableToNewMarkableSet(currentSecondaryMarkable, relation);
                    }
                });
                this.add(item);
            }
        }
    }

    public final boolean isEmpty() {
        return this.empty;
    }

    private final boolean containsAttribute(MMAX2Attribute[] attribs, MMAX2Attribute attrib) {
        boolean result = false;
        int o = 0;
        while (o < attribs.length) {
            if (attribs[o].equals(attrib)) {
                result = true;
                break;
            }
            ++o;
        }
        return result;
    }

    public class CancellationListener
    implements PopupMenuListener {
        MarkableChart chart = null;

        public CancellationListener(MarkableChart _chart) {
            this.chart = _chart;
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            this.chart.removeTemporarySelection();
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            if (!((MMAX2ActionSelector)popupMenuEvent.getSource()).initial) {
                this.chart.getCurrentDiscourse().getMMAX2().removeOpaqueRenderablesFromRenderingList();
                this.chart.getCurrentDiscourse().getMMAX2().getCurrentViewport().repaint();
                this.chart.getCurrentDiscourse().getMMAX2().getCurrentTextPane().startAutoRefresh();
                ((MMAX2ActionSelector)popupMenuEvent.getSource()).initial = true;
            } else {
                ((MMAX2ActionSelector)popupMenuEvent.getSource()).initial = false;
            }
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }
    }
}

