/*
 * Decompiled with CFR 0.152.
 */
package pl.waw.ipipan.zil.core.mmax4core.gui.display;

import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.Markable;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.MarkableChart;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.MarkableLevel;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.MarkablePointer;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.MarkableRelation;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.SimpleMarkableCustomization;
import pl.waw.ipipan.zil.core.mmax4core.gui.display.MMAX2TextPane;
import pl.waw.ipipan.zil.core.mmax4core.gui.document.MMAX2Document;
import pl.waw.ipipan.zil.core.mmax4core.utils.MMAX2Constants;
import pl.waw.ipipan.zil.core.mmax4core.utils.MMAX2Utils;

public class MarkableLevelRenderer {
    private MarkableLevel level = null;
    private Color backgroundColor = null;
    private Color foregroundColor = null;
    private Color handleColor = null;
    private SimpleAttributeSet defaultActiveHandleStyle = new SimpleAttributeSet();
    private boolean foregroundIsTransparent = true;
    private boolean backgroundIsTransparent = true;
    private boolean bold = false;
    private boolean italic = false;
    private boolean underline = false;
    private boolean strikethrough = false;
    private boolean subscript = false;
    private boolean superscript = false;
    private String customizationFileName = "";
    private SimpleMarkableCustomization[] customizations = new SimpleMarkableCustomization[0];
    private int customizationCount = 0;

    public MarkableLevelRenderer(MarkableLevel _level, String _customizationFileName) {
        this.level = _level;
        if (this.handleColor != null) {
            StyleConstants.setBackground(this.defaultActiveHandleStyle, this.handleColor);
        } else if (!this.foregroundIsTransparent) {
            StyleConstants.setBackground(this.defaultActiveHandleStyle, this.foregroundColor);
        } else {
            StyleConstants.setBackground(this.defaultActiveHandleStyle, Color.black);
        }
        this.customizationFileName = _customizationFileName;
    }

    public final void destroyDependentComponents() {
        this.level = null;
        this.customizations = null;
    }

    public final int getCustomizationCount() {
        return this.customizationCount;
    }

    public final void updateSimpleMarkableCustomizations(boolean status) {
        if (!status) {
            this.customizationCount = 0;
        } else {
            if (!this.customizationFileName.equals("")) {
                String error;
                this.customizations = null;
                this.customizations = new SimpleMarkableCustomization[0];
                DOMParser parser = new DOMParser();
                Document customizationDOM = null;
                try {
                    parser.setFeature("http://xml.org/sax/features/validation", false);
                }
                catch (SAXNotRecognizedException ex) {
                    ex.printStackTrace();
                    return;
                }
                catch (SAXNotSupportedException ex) {
                    ex.printStackTrace();
                    return;
                }
                try {
                    parser.parse(new InputSource(new File(this.customizationFileName).toURI().toASCIIString()));
                }
                catch (SAXParseException exception) {
                    error = "Line: " + exception.getLineNumber() + " Column: " + exception.getColumnNumber() + "\n" + exception.toString();
                    JOptionPane.showMessageDialog(null, error, "MarkableFileLoader: " + this.customizationFileName, 0);
                }
                catch (SAXException exception) {
                    error = exception.toString();
                    JOptionPane.showMessageDialog(null, error, "MarkableFileLoader: " + this.customizationFileName, 0);
                }
                catch (IOException exception) {
                    error = exception.toString();
                    JOptionPane.showMessageDialog(null, error, "MarkableFileLoader: " + this.customizationFileName, 0);
                }
                customizationDOM = parser.getDocument();
                NodeList allRules = customizationDOM.getElementsByTagName("rule");
                int custNum = allRules.getLength();
                this.customizations = new SimpleMarkableCustomization[custNum];
                int p = 0;
                while (p < custNum) {
                    String pattern = "";
                    String style = "";
                    String connector = "";
                    try {
                        pattern = allRules.item(p).getAttributes().getNamedItem("pattern").getNodeValue();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    try {
                        style = allRules.item(p).getAttributes().getNamedItem("style").getNodeValue();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    try {
                        connector = allRules.item(p).getAttributes().getNamedItem("connector").getNodeValue();
                    }
                    catch (NullPointerException ex) {
                        connector = "and";
                    }
                    int numConnector = MMAX2Constants.AND;
                    if (connector.equalsIgnoreCase("or")) {
                        numConnector = MMAX2Constants.OR;
                    }
                    this.customizations[p] = new SimpleMarkableCustomization(this.level, pattern, numConnector, MMAX2Utils.createSimpleAttributeSet(style, false));
                    ++p;
                }
            }
            this.customizationCount = this.customizations.length;
        }
    }

    public final Color getHandleColor() {
        return StyleConstants.getBackground(this.defaultActiveHandleStyle);
    }

    public final void render(int[] displayStartPositions, int[] displayEndPositions, Color color) {
        SimpleAttributeSet styleToUse = new SimpleAttributeSet();
        MMAX2Document doc = this.level.getCurrentDiscourse().getDisplayDocument();
        int start = displayStartPositions[0];
        int end = displayEndPositions[displayEndPositions.length - 1];
        doc.startChanges(start, end - start + 1);
        if (!styleToUse.isDefined(StyleConstants.FontSize)) {
            StyleConstants.setFontSize(styleToUse, doc.getDisplayFontSize());
        }
        if (!styleToUse.isDefined(StyleConstants.FontFamily)) {
            StyleConstants.setFontFamily(styleToUse, doc.getDisplayFontFamily());
        }
        StyleConstants.setBackground(styleToUse, color);
        int b = 0;
        while (b < displayStartPositions.length) {
            doc.bulkApplyStyleToDisplaySpanBackground(displayStartPositions[b], displayEndPositions[b] - displayStartPositions[b] + 1, styleToUse);
            ++b;
        }
        doc.commitChanges();
    }

    public final void render(Markable markable, int mode) {
        SimpleAttributeSet styleToUse = null;
        MMAX2Document doc = this.level.getCurrentDiscourse().getDisplayDocument();
        MMAX2TextPane pane = this.level.getCurrentDiscourse().getMMAX2().getCurrentTextPane();
        MarkableChart chart = this.level.getCurrentDiscourse().getCurrentMarkableChart();
        int[] displayStartPositions = null;
        int[] displayEndPositions = null;
        String[][] fragments = null;
        if (markable != null) {
            displayStartPositions = markable.getDisplayStartPositions();
            displayEndPositions = markable.getDisplayEndPositions();
            fragments = markable.getFragments();
        }
        if (mode == MMAX2Constants.RENDER_REMOVED) {
            String[] currentFrag = null;
            doc.startChanges(markable);
            fragments = markable.getFragments();
            int z = 0;
            while (z < fragments.length) {
                currentFrag = fragments[z];
                int discPos = 0;
                int r = 0;
                while (r < currentFrag.length) {
                    styleToUse = chart.getTopAttributesAtDiscourseElement(currentFrag[r]);
                    discPos = this.level.getCurrentDiscourse().getDiscoursePositionFromDiscourseElementID(currentFrag[r]);
                    doc.bulkApplyStyleToDiscourseElement(this.level.getCurrentDiscourse().getDisplayStartPositionFromDiscoursePosition(discPos), styleToUse, true);
                    ++r;
                }
                ++z;
            }
            doc.commitChanges();
        } else if (mode == MMAX2Constants.RENDER_IN_SET) {
            markable.renderMe(MMAX2Constants.RERENDER_THIS);
            styleToUse = this.getAttributesForMarkable(markable);
            if (!styleToUse.isDefined(StyleConstants.FontSize)) {
                StyleConstants.setFontSize(styleToUse, doc.getDisplayFontSize());
            }
            if (!styleToUse.isDefined(StyleConstants.FontFamily)) {
                StyleConstants.setFontFamily(styleToUse, doc.getDisplayFontFamily());
            }
            StyleConstants.setBackground(styleToUse, Color.lightGray);
            int b = 0;
            while (b < displayStartPositions.length) {
                doc.bulkApplyStyleToDisplaySpanBackground(displayStartPositions[b], displayEndPositions[b] - displayStartPositions[b] + 1, styleToUse);
                ++b;
            }
        } else if (mode == MMAX2Constants.RENDER_IN_SEARCHRESULT) {
            doc.startChanges(markable);
            styleToUse = this.getAttributesForMarkable(markable);
            if (!styleToUse.isDefined(StyleConstants.FontSize)) {
                StyleConstants.setFontSize(styleToUse, doc.getDisplayFontSize());
            }
            if (!styleToUse.isDefined(StyleConstants.FontFamily)) {
                StyleConstants.setFontFamily(styleToUse, doc.getDisplayFontFamily());
            }
            StyleConstants.setBackground(styleToUse, Color.orange);
            int b = 0;
            while (b < displayStartPositions.length) {
                doc.bulkApplyStyleToDisplaySpanBackground(displayStartPositions[b], displayEndPositions[b] - displayStartPositions[b] + 1, styleToUse);
                ++b;
            }
            doc.commitChanges();
        } else if (mode == MMAX2Constants.RERENDER_THIS) {
            String[] currentFragment = null;
            String currentDE = "";
            int currentStart = 0;
            int z = 0;
            while (z < fragments.length) {
                currentFragment = fragments[z];
                int p = 0;
                while (p < currentFragment.length) {
                    currentDE = currentFragment[p];
                    styleToUse = chart.getTopAttributesAtDiscourseElement(currentDE);
                    currentStart = this.level.getCurrentDiscourse().getDisplayStartPositionFromDiscoursePosition(this.level.getCurrentDiscourse().getDiscoursePositionFromDiscourseElementID(currentDE));
                    doc.bulkApplyStyleToDiscourseElement(currentStart, styleToUse, true);
                    ++p;
                }
                ++z;
            }
        } else if (mode == MMAX2Constants.RERENDER_EVERYTHING) {
            String[] allDiscourseElements = this.level.getCurrentDiscourse().getAllDiscourseElementIDs();
            doc.startChanges(0, doc.getLength());
            int z = 0;
            while (z < allDiscourseElements.length) {
                int currentStart = this.level.getCurrentDiscourse().getDisplayStartPositionFromDiscoursePosition(z);
                SimpleAttributeSet attribs = chart.getTopAttributesAtDiscourseElement(allDiscourseElements[z]);
                doc.bulkApplyStyleToDiscourseElement(currentStart, attribs, true);
                ++z;
            }
            Integer[] allHandlePositions = this.level.getCurrentDiscourse().getAllDisplayAssociations();
            Markable tempM = null;
            SimpleAttributeSet handleStyle = null;
            SimpleAttributeSet markableAttributes = null;
            if (allHandlePositions != null) {
                int q = 0;
                while (q < allHandlePositions.length) {
                    int u;
                    handleStyle = new SimpleAttributeSet();
                    tempM = this.level.getCurrentDiscourse().getMarkableAtDisplayAssociation(allHandlePositions[q]);
                    markableAttributes = tempM.getAttributedependentStyle();
                    if (markableAttributes.isDefined("handles")) {
                        StyleConstants.setForeground(handleStyle, (Color)markableAttributes.getAttribute("handles"));
                    } else {
                        StyleConstants.setForeground(handleStyle, Color.BLACK);
                    }
                    if (markableAttributes.isDefined(StyleConstants.FontSize)) {
                        StyleConstants.setFontSize(handleStyle, StyleConstants.getFontSize(markableAttributes));
                    } else {
                        StyleConstants.setFontSize(handleStyle, doc.getDisplayFontSize());
                    }
                    if (markableAttributes.isDefined(StyleConstants.FontFamily)) {
                        StyleConstants.setFontFamily(handleStyle, StyleConstants.getFontFamily(markableAttributes));
                    } else {
                        StyleConstants.setFontFamily(handleStyle, doc.getDisplayFontFamily());
                    }
                    int[] currentHandles = tempM.getRightHandlePositions();
                    if (currentHandles != null) {
                        u = 0;
                        while (u < currentHandles.length) {
                            doc.bulkApplyStyleToMarkableHandle(currentHandles[u], handleStyle, false);
                            ++u;
                        }
                    }
                    if ((currentHandles = tempM.getLeftHandlePositions()) != null) {
                        u = 0;
                        while (u < currentHandles.length) {
                            doc.bulkApplyStyleToMarkableHandle(currentHandles[u], handleStyle, false);
                            ++u;
                        }
                    }
                    ++q;
                }
            }
            doc.commitChanges();
        } else if (mode == MMAX2Constants.RENDER_SELECTED) {
            MarkableRelation[] thisMarkablesMarkablePointerRelations;
            doc.startChanges(markable);
            markable.renderMe(MMAX2Constants.RERENDER_THIS);
            styleToUse = new SimpleAttributeSet(this.level.getCurrentDiscourse().getMMAX2().getSelectedStyle());
            int b = 0;
            while (b < displayStartPositions.length) {
                doc.bulkApplyStyleToDisplaySpanBackground(displayStartPositions[b], displayEndPositions[b] - displayStartPositions[b] + 1, styleToUse);
                ++b;
            }
            doc.commitChanges();
            MarkableRelation[] thisMarkablesMarkableSetRelations = this.level.getActiveMarkableSetRelationsForMarkable(markable);
            if (thisMarkablesMarkableSetRelations != null) {
                MarkableRelation[] markableAttributes = thisMarkablesMarkableSetRelations;
                int handleStyle = thisMarkablesMarkableSetRelations.length;
                int tempM = 0;
                while (tempM < handleStyle) {
                    MarkableRelation currentRelation = markableAttributes[tempM];
                    String currentAttributeName = currentRelation.getAttributeName();
                    this.level.getCurrentDiscourse().getMMAX2().putOnRenderingList(currentRelation.getMarkableSetWithAttributeValue(markable.getAttributeValue(currentAttributeName)));
                    ++tempM;
                }
            }
            if ((thisMarkablesMarkablePointerRelations = this.level.getActiveMarkablePointerRelationsForSourceMarkable(markable)) != null) {
                int flagLevel = 0;
                MarkableRelation[] currentHandles = thisMarkablesMarkablePointerRelations;
                int currentAttributeName = thisMarkablesMarkablePointerRelations.length;
                int markableAttributes = 0;
                while (markableAttributes < currentAttributeName) {
                    MarkableRelation currentRelation = currentHandles[markableAttributes];
                    MarkablePointer currentRenderable = currentRelation.getMarkablePointerForSourceMarkable(markable);
                    currentRenderable.setFlagLevel(flagLevel);
                    flagLevel += currentRenderable.getSize();
                    this.level.getCurrentDiscourse().getMMAX2().putOnRenderingList(currentRenderable);
                    ++markableAttributes;
                }
            }
        } else if (mode == MMAX2Constants.RENDER_UNSELECTED) {
            doc.startChanges(markable);
            styleToUse = this.getAttributesForMarkable(markable);
            if (!styleToUse.isDefined(StyleConstants.FontSize)) {
                StyleConstants.setFontSize(styleToUse, doc.getDisplayFontSize());
            }
            StyleConstants.setBackground(styleToUse, Color.white);
            StyleConstants.setFontFamily(styleToUse, doc.getDisplayFontFamily());
            int b = 0;
            while (b < displayStartPositions.length) {
                doc.bulkApplyStyleToDisplaySpanBackground(displayStartPositions[b], displayEndPositions[b] - displayStartPositions[b] + 1, styleToUse);
                ++b;
            }
            markable.renderMe(MMAX2Constants.RERENDER_THIS);
            doc.commitChanges();
        } else if (mode == MMAX2Constants.RENDER_ALL_HANDLES) {
            styleToUse = this.defaultActiveHandleStyle;
            StyleConstants.setFontFamily(styleToUse, doc.getDisplayFontFamily());
            int[] startHandles = markable.getLeftHandlePositions();
            int[] endHandles = markable.getRightHandlePositions();
            int z = 0;
            while (z < startHandles.length) {
                doc.setCharacterAttributes(startHandles[z], 1, styleToUse, false);
                doc.setCharacterAttributes(endHandles[z], 1, styleToUse, false);
                ++z;
            }
        } else if (mode == MMAX2Constants.RENDER_NO_HANDLES) {
            styleToUse = new SimpleAttributeSet();
            StyleConstants.setFontFamily(styleToUse, doc.getDisplayFontFamily());
            int[] startHandles = markable.getLeftHandlePositions();
            int[] endHandles = markable.getRightHandlePositions();
            int z = 0;
            while (z < startHandles.length) {
                StyleConstants.setBackground(styleToUse, this.level.getCurrentDiscourse().getCurrentMarkableChart().getPrevailingBackgroundColorForMarkableHandle(startHandles[z]));
                doc.setCharacterAttributes(startHandles[z], 1, styleToUse, false);
                StyleConstants.setBackground(styleToUse, this.level.getCurrentDiscourse().getCurrentMarkableChart().getPrevailingBackgroundColorForMarkableHandle(endHandles[z]));
                doc.setCharacterAttributes(endHandles[z], 1, styleToUse, false);
                ++z;
            }
        } else if (mode == MMAX2Constants.RENDER_CURRENT_HANDLE) {
            styleToUse = new SimpleAttributeSet();
            StyleConstants.setFontFamily(styleToUse, doc.getDisplayFontFamily());
            int[] startHandles = markable.getLeftHandlePositions();
            int[] endHandles = markable.getRightHandlePositions();
            int z = 0;
            while (z < startHandles.length) {
                StyleConstants.setBackground(styleToUse, this.level.getCurrentDiscourse().getCurrentMarkableChart().getPrevailingBackgroundColorForMarkableHandle(startHandles[z]));
                doc.setCharacterAttributes(startHandles[z], 1, styleToUse, false);
                StyleConstants.setBackground(styleToUse, this.level.getCurrentDiscourse().getCurrentMarkableChart().getPrevailingBackgroundColorForMarkableHandle(endHandles[z]));
                doc.setCharacterAttributes(endHandles[z], 1, styleToUse, false);
                ++z;
            }
            styleToUse = this.defaultActiveHandleStyle;
            int FragStart = -1;
            int FragEnd = -1;
            int currentStart = -1;
            int currentEnd = -1;
            int currentMinIndex = -1;
            int currentMinDistance = Integer.MAX_VALUE;
            int distToNextLeftHandle = -1;
            int distToNextRightHandle = -1;
            int z2 = 0;
            while (z2 < startHandles.length) {
                currentStart = startHandles[z2];
                currentEnd = endHandles[z2];
                if (currentStart == pane.getCurrentDot() || currentEnd == pane.getCurrentDot()) {
                    FragStart = currentStart;
                    FragEnd = currentEnd;
                    doc.setCharacterAttributes(FragStart, 1, styleToUse, false);
                    doc.setCharacterAttributes(FragEnd, 1, styleToUse, false);
                    break;
                }
                distToNextLeftHandle = Math.abs(currentStart - pane.getCurrentDot());
                distToNextRightHandle = Math.abs(currentEnd - pane.getCurrentDot());
                if (distToNextRightHandle < distToNextLeftHandle) {
                    if (distToNextRightHandle < currentMinDistance) {
                        currentMinDistance = distToNextRightHandle;
                        currentMinIndex = z2;
                    }
                } else if (distToNextLeftHandle < currentMinDistance) {
                    currentMinDistance = distToNextLeftHandle;
                    currentMinIndex = z2;
                }
                ++z2;
            }
            if (FragStart == -1 && FragEnd == -1) {
                if (currentMinIndex != -1) {
                    FragStart = startHandles[currentMinIndex];
                    FragEnd = endHandles[currentMinIndex];
                    doc.setCharacterAttributes(FragStart, 1, this.defaultActiveHandleStyle, false);
                    doc.setCharacterAttributes(FragEnd, 1, this.defaultActiveHandleStyle, false);
                } else {
                    System.err.println("Couldn't determine fragment!");
                }
            }
        }
    }

    public final void removeHandlesAtDisplayPositions(Integer[] positions) {
        if (positions.length == 0) {
            return;
        }
        MMAX2Document doc = this.level.getCurrentDiscourse().getDisplayDocument();
        doc.startChanges(positions[0], positions[positions.length - 1]);
        SimpleAttributeSet attribs = new SimpleAttributeSet();
        StyleConstants.setFontSize(attribs, doc.getDisplayFontSize());
        StyleConstants.setFontFamily(attribs, doc.getDisplayFontFamily());
        StyleConstants.setForeground(attribs, Color.lightGray);
        StyleConstants.setBackground(attribs, Color.white);
        StyleConstants.setStrikeThrough(attribs, true);
        int o = 0;
        while (o < positions.length) {
            doc.bulkApplyStyleToMarkableHandle(positions[o], attribs, true);
            ++o;
        }
        doc.commitChanges();
    }

    public final SimpleAttributeSet getAttributesForMarkable(Markable _markable) {
        SimpleAttributeSet tempResult = null;
        SimpleAttributeSet result = new SimpleAttributeSet();
        SimpleAttributeSet intermediateResult = null;
        if (this.customizationCount != 0) {
            int u = 0;
            while (u < this.customizationCount) {
                tempResult = this.customizations[u].matches(_markable);
                if (tempResult != null) {
                    result = intermediateResult = MarkableLevelRenderer.mergeAttributes(tempResult, result);
                    intermediateResult = null;
                }
                ++u;
            }
        }
        return result;
    }

    public static final SimpleAttributeSet mergeAttributes(SimpleAttributeSet superiorSet, SimpleAttributeSet inferiorSet) {
        SimpleAttributeSet resultSet = new SimpleAttributeSet(superiorSet);
        if (StyleConstants.isSuperscript(inferiorSet) && !StyleConstants.isSubscript(resultSet)) {
            StyleConstants.setSuperscript(resultSet, true);
        }
        if (!superiorSet.isDefined("handles") && inferiorSet.isDefined("handles")) {
            resultSet.addAttribute("handles", inferiorSet.getAttribute("handles"));
        }
        if (StyleConstants.isSubscript(inferiorSet) && !StyleConstants.isSuperscript(resultSet)) {
            StyleConstants.setSubscript(resultSet, true);
        }
        if (StyleConstants.isStrikeThrough(inferiorSet) && !StyleConstants.isUnderline(resultSet)) {
            StyleConstants.setStrikeThrough(resultSet, true);
        }
        if (StyleConstants.isUnderline(inferiorSet) && !StyleConstants.isStrikeThrough(resultSet)) {
            StyleConstants.setUnderline(resultSet, true);
        }
        if (StyleConstants.isBold(inferiorSet)) {
            StyleConstants.setBold(resultSet, true);
        }
        if (StyleConstants.isItalic(inferiorSet)) {
            StyleConstants.setItalic(resultSet, true);
        }
        if (superiorSet.isDefined(StyleConstants.Foreground)) {
            StyleConstants.setForeground(resultSet, StyleConstants.getForeground(superiorSet));
        } else if (inferiorSet.isDefined(StyleConstants.Foreground)) {
            StyleConstants.setForeground(resultSet, StyleConstants.getForeground(inferiorSet));
        }
        if (superiorSet.isDefined(StyleConstants.Background)) {
            StyleConstants.setBackground(resultSet, StyleConstants.getBackground(superiorSet));
        } else if (inferiorSet.isDefined(StyleConstants.Background)) {
            StyleConstants.setBackground(resultSet, StyleConstants.getBackground(inferiorSet));
        }
        if (inferiorSet.isDefined(StyleConstants.FontSize) && !superiorSet.isDefined(StyleConstants.FontSize)) {
            StyleConstants.setFontSize(resultSet, StyleConstants.getFontSize(inferiorSet));
        }
        return resultSet;
    }

    public final void setHandleColor(Color _color) {
        StyleConstants.setBackground(this.defaultActiveHandleStyle, _color);
    }

    public final void setBackgroundColor(Color _color) {
        this.backgroundColor = _color;
        this.backgroundIsTransparent = _color == null;
    }

    public final Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public final void setForegroundColor(Color _color) {
        this.foregroundColor = _color;
        this.foregroundIsTransparent = _color == null;
    }

    public final Color getForegroundColor() {
        return this.foregroundColor;
    }

    public final boolean getForegroundIsTransparent() {
        return this.foregroundIsTransparent;
    }

    public final boolean getBackgroundIsTransparent() {
        return this.backgroundIsTransparent;
    }

    public final boolean getIsBold() {
        return this.bold;
    }

    public final void setIsBold(boolean status) {
        this.bold = status;
    }

    public final boolean getIsItalic() {
        return this.italic;
    }

    public final void setIsItalic(boolean status) {
        this.italic = status;
    }

    public final boolean getIsUnderline() {
        return this.underline;
    }

    public final void setIsUnderline(boolean status) {
        this.underline = status;
    }

    public final boolean getIsSubscript() {
        return this.subscript;
    }

    public final void setIsSubscript(boolean status) {
        this.subscript = status;
    }

    public final boolean getIsSuperscript() {
        return this.superscript;
    }

    public final void setIsSuperscript(boolean status) {
        this.superscript = status;
    }

    public final boolean getIsStrikethrough() {
        return this.strikethrough;
    }

    public final void setIsStrikethrough(boolean status) {
        this.strikethrough = status;
    }
}

